/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.border.TitledBorder;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;

public class Search
extends JDialog {
    private static Vector searchHistory = new Vector();
    private static Map searchHistoryMap = new HashMap();
    private static Vector replaceHistory = new Vector();
    private static Search wordreplacement = new Search();
    private JPanel jContentPane = null;
    private JPanel jPanel = null;
    private JPanel jPanel1 = null;
    private JLabel searchLabel = null;
    private JTextField searchTextField = null;
    private JLabel replaceLabel = null;
    private JTextField replaceTextField = null;
    private JCheckBox jCheckBox = null;
    private JCheckBox jCheckBox2 = null;
    private JPanel jPanel2 = null;
    private JRadioButton upRadioButton = null;
    private JRadioButton downRadioButton = null;
    private JButton searchNextButton = null;
    private JButton replaceAndSearchButton = null;
    private JButton replaceAllButton = null;
    private JButton cancelButton = null;
    private boolean hasSearched = false;
    private JTextComponent jTextArea;
    private boolean searchedAll = false;

    private Search() {
        this.initialize();
    }

    private void initialize() {
        this.setResizable(false);
        this.setTitle("\u691c\u7d22\u3068\u7f6e\u63db");
        this.setSize(450, 200);
        this.setContentPane(this.getJContentPane());
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                Search.this.hasSearched = false;
            }
        });
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new BorderLayout());
            this.jContentPane.setPreferredSize(new Dimension(500, 200));
            this.jContentPane.add((Component)this.getJPanel(), "Center");
            this.jContentPane.add((Component)this.getJPanel1(), "South");
        }
        return this.jContentPane;
    }

    private JPanel getJPanel() {
        if (this.jPanel == null) {
            this.replaceLabel = new JLabel();
            this.searchLabel = new JLabel();
            JPanel y = new JPanel();
            JPanel z = new JPanel();
            this.jPanel = new JPanel();
            this.searchLabel.setText("\u691c\u7d22:");
            this.replaceLabel.setText("\u7f6e\u63db:");
            y.add((Component)this.searchLabel, null);
            y.add((Component)this.getSearchTextField(), null);
            z.add((Component)this.replaceLabel, null);
            z.add((Component)this.getReplaceTextField(), null);
            this.jPanel.add((Component)y, null);
            this.jPanel.add((Component)z, null);
            JPanel x = new JPanel();
            x.add((Component)this.getJCheckBox(), null);
            x.add((Component)this.getJCheckBox2(), null);
            this.jPanel.add((Component)x, null);
            this.jPanel.add((Component)this.getJPanel2(), null);
        }
        return this.jPanel;
    }

    private JPanel getJPanel1() {
        if (this.jPanel1 == null) {
            this.jPanel1 = new JPanel();
            this.jPanel1.add((Component)this.getSearchNextButton(), null);
            this.jPanel1.add((Component)this.getReplaceAndSearchButton(), null);
            this.jPanel1.add((Component)this.getReplaceAllButton(), null);
            this.jPanel1.add((Component)this.getCancelButton(), null);
        }
        return this.jPanel1;
    }

    static Search getInstance() {
        if (wordreplacement == null) {
            wordreplacement = new Search();
        }
        wordreplacement.initialize();
        return wordreplacement;
    }

    private JComponent getSearchTextField() {
        if (this.searchTextField == null) {
            this.searchTextField = new JTextField();
            this.searchTextField.setPreferredSize(new Dimension(300, 20));
        }
        return this.searchTextField;
    }

    private JTextField getReplaceTextField() {
        if (this.replaceTextField == null) {
            this.replaceTextField = new JTextField();
            this.replaceTextField.setPreferredSize(new Dimension(300, 20));
        }
        return this.replaceTextField;
    }

    private JCheckBox getJCheckBox() {
        if (this.jCheckBox == null) {
            this.jCheckBox = new JCheckBox();
            this.jCheckBox.setText("\u5927\u6587\u5b57\u3068\u5c0f\u6587\u5b57\u306e\u533a\u5225(C)");
            this.jCheckBox.setMnemonic(67);
        }
        return this.jCheckBox;
    }

    private JCheckBox getJCheckBox2() {
        if (this.jCheckBox2 == null) {
            this.jCheckBox2 = new JCheckBox();
            this.jCheckBox2.setText("\u6b63\u898f\u8868\u73fe(X)");
            this.jCheckBox2.setMnemonic(67);
        }
        return this.jCheckBox2;
    }

    private JPanel getJPanel2() {
        if (this.jPanel2 == null) {
            TitledBorder titledBorder1 = BorderFactory.createTitledBorder(null, "\u691c\u7d22\u3059\u308b\u65b9\u5411", 0, 0, null, null);
            this.jPanel2 = new JPanel();
            this.jPanel2.setBorder(titledBorder1);
            JRadioButton upRadioButton = this.getUpRadioButton();
            JRadioButton downRadioButton = this.getDownRadioButton();
            downRadioButton.setSelected(true);
            this.jPanel2.add((Component)upRadioButton, null);
            this.jPanel2.add((Component)downRadioButton, null);
            ButtonGroup buttonGroup = new ButtonGroup();
            buttonGroup.add(upRadioButton);
            buttonGroup.add(downRadioButton);
        }
        return this.jPanel2;
    }

    private JRadioButton getUpRadioButton() {
        if (this.upRadioButton == null) {
            this.upRadioButton = new JRadioButton();
            this.upRadioButton.setText("\u4e0a\u3078(O)");
            this.upRadioButton.setMnemonic(79);
        }
        return this.upRadioButton;
    }

    private JRadioButton getDownRadioButton() {
        if (this.downRadioButton == null) {
            this.downRadioButton = new JRadioButton();
            this.downRadioButton.setText("\u4e0b\u3078(B)");
            this.downRadioButton.setMnemonic(66);
            this.downRadioButton.setSelected(true);
        }
        return this.downRadioButton;
    }

    private JButton getSearchNextButton() {
        if (this.searchNextButton == null) {
            this.searchNextButton = new JButton();
            this.searchNextButton.setText("\u6b21\u3092\u691c\u7d22(F)");
            this.searchNextButton.setMnemonic(70);
            this.getRootPane().setDefaultButton(this.searchNextButton);
            this.searchNextButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Search.this.search();
                }
            });
        }
        return this.searchNextButton;
    }

    private JButton getReplaceAndSearchButton() {
        if (this.replaceAndSearchButton == null) {
            this.replaceAndSearchButton = new JButton();
            this.replaceAndSearchButton.setText("\u7f6e\u63db(R)");
            this.replaceAndSearchButton.setMnemonic(82);
            this.replaceAndSearchButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (Search.this.hasSearched) {
                        Search.this.replace();
                        Search.this.hasSearched = false;
                    } else {
                        Search.this.search();
                        Search.this.hasSearched = true;
                    }
                }
            });
        }
        return this.replaceAndSearchButton;
    }

    private JButton getReplaceAllButton() {
        if (this.replaceAllButton == null) {
            this.replaceAllButton = new JButton();
            this.replaceAllButton.setText("\u3059\u3079\u3066\u7f6e\u63db(A)");
            this.replaceAllButton.setMnemonic(65);
            this.replaceAllButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Search.this.replaceAll();
                }
            });
        }
        return this.replaceAllButton;
    }

    private JButton getCancelButton() {
        if (this.cancelButton == null) {
            this.cancelButton = new JButton();
            this.cancelButton.setText("\u9589\u3058\u308b");
            AbstractAction action = new AbstractAction("\u9589\u3058\u308b"){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    Search.this.hasSearched = false;
                    Search.this.setVisible(false);
                    Highlighter hilighter = Search.this.jTextArea.getHighlighter();
                    hilighter.removeAllHighlights();
                }
            };
            this.cancelButton.getInputMap(2).put(KeyStroke.getKeyStroke(27, 0), "\u9589\u3058\u308b");
            this.cancelButton.getActionMap().put("\u9589\u3058\u308b", action);
            this.cancelButton.setAction(action);
        }
        return this.cancelButton;
    }

    private void replace() {
        String searchingWord = this.searchTextField.getText();
        String replacingWord = this.replaceTextField.getText();
        String str = this.jTextArea.getSelectedText();
        if (str == null) {
            return;
        }
        if (str.equals(searchingWord) || str.equalsIgnoreCase(searchingWord) && !this.jCheckBox.isSelected()) {
            this.jTextArea.replaceSelection(replacingWord);
        }
    }

    private void replaceAll() {
        String searchingWord = this.searchTextField.getText();
        if (searchingWord.equals("")) {
            return;
        }
        String replacingWord = this.replaceTextField.getText();
        String str = this.jTextArea.getText();
        if (this.jCheckBox.isSelected()) {
            if (str.indexOf(searchingWord) < 0) {
                JOptionPane.showMessageDialog(this.jContentPane, "\u898b\u3064\u304b\u308a\u307e\u305b\u3093", "\u898b\u3064\u304b\u308a\u307e\u305b\u3093", 2);
                return;
            }
            this.jTextArea.setText(str.replaceAll("\\Q" + searchingWord, replacingWord));
        } else {
            if (str.toLowerCase().indexOf(searchingWord.toLowerCase()) < 0) {
                JOptionPane.showMessageDialog(this.jContentPane, "\u898b\u3064\u304b\u308a\u307e\u305b\u3093", "\u898b\u3064\u304b\u308a\u307e\u305b\u3093", 2);
                return;
            }
            this.jTextArea.setText(Pattern.compile("\\Q" + searchingWord, 2).matcher(str).replaceAll(replacingWord));
        }
    }

    private void search() {
        this.search(this.downRadioButton.isSelected());
    }

    private void search(boolean isSelected) {
        String word = this.searchTextField.getText();
        String regexp = this.searchTextField.getText();
        if (regexp.length() == 0) {
            return;
        }
        Pattern p = Pattern.compile(regexp, 8);
        Highlighter hilighter = this.jTextArea.getHighlighter();
        DefaultHighlighter.DefaultHighlightPainter painter = new DefaultHighlighter.DefaultHighlightPainter(Color.LIGHT_GRAY);
        DefaultHighlighter.DefaultHighlightPainter defaultpainter = new DefaultHighlighter.DefaultHighlightPainter(Color.WHITE);
        hilighter.removeAllHighlights();
        if (searchHistoryMap == null) {
            searchHistoryMap = new HashMap();
        }
        if (!searchHistoryMap.containsKey(word)) {
            searchHistory.add(word);
            searchHistoryMap.put(word, word);
        }
        if (word.equals("")) {
            return;
        }
        String str = this.jTextArea.getText();
        str = str.replaceAll("\r\n", "\n");
        if (this.searchedAll) {
            this.setTitle(this.getTitle());
            this.searchedAll = false;
        }
        if (!this.jCheckBox.isSelected()) {
            str = str.toLowerCase();
            word = word.toLowerCase();
        }
        Matcher m = p.matcher(str);
        while (m.find()) {
            try {
                hilighter.addHighlight(m.start(), m.end(), painter);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (isSelected) {
            int num = this.jTextArea.getCaretPosition();
            if (str.indexOf(word) < 0) {
                JOptionPane.showMessageDialog(this.jContentPane, "\u30b9\u30c8\u30ea\u30f3\u30b0\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093", this.getTitle(), 2);
                return;
            }
            if ((num = str.indexOf(word, num)) < 0) {
                num = str.indexOf(word);
                this.setTitle(this.getTitle());
                this.searchedAll = true;
            }
            this.jTextArea.select(num, num + word.length());
            try {
                hilighter.addHighlight(num, num + word.length(), defaultpainter);
            }
            catch (BadLocationException e) {
                e.printStackTrace();
            }
        } else {
            if (str.lastIndexOf(word) < 0) {
                JOptionPane.showMessageDialog(this.jContentPane, "\u30b9\u30c8\u30ea\u30f3\u30b0\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093", this.getTitle(), 2);
                return;
            }
            int num = this.jTextArea.getSelectionStart() - 1;
            if ((num = str.lastIndexOf(word, num)) < 0) {
                num = str.lastIndexOf(word);
                this.setTitle(this.getTitle());
                this.searchedAll = true;
            }
            this.jTextArea.select(num, num + word.length());
            try {
                hilighter.addHighlight(num, num + word.length(), defaultpainter);
            }
            catch (BadLocationException e) {
                e.printStackTrace();
            }
        }
    }

    void find(boolean next) {
        this.search(!(next ^ this.downRadioButton.isSelected()));
    }

    void reset() {
        this.hasSearched = false;
    }

    void setJTextArea(JTextComponent jTextArea) {
        this.jTextArea = jTextArea;
        this.setLocationRelativeTo(jTextArea);
    }
}

