/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JToolTip;
import javax.swing.UIManager;

public class MyJTabbedPane
extends JTabbedPane {
    private final JToolTip tip;
    private String name = "";
    private String title = "";
    private final Insets tabInsets = UIManager.getInsets("TabbedPane.tabInsets");
    private int current = -1;

    public MyJTabbedPane() {
        this.tip = super.createToolTip();
        this.setTabLayoutPolicy(1);
        this.addMouseMotionListener(new MouseMotionAdapter(){
            private int prev = -1;

            @Override
            public void mouseMoved(MouseEvent e) {
                JTabbedPane source = (JTabbedPane)e.getSource();
                int tgt = source.indexAtLocation(e.getX(), e.getY());
                int i = 0;
                while (i < source.getTabCount()) {
                    TabPanel tabPanel = (TabPanel)source.getTabComponentAt(i);
                    ++i;
                }
            }
        });
    }

    @Override
    public void addTab(String title, Component content) {
        super.addTab(title, content);
        TabPanel p = new TabPanel(this, title, content);
        this.setTabComponentAt(this.getTabCount() - 1, p);
    }

    @Override
    public void setTitleAt(int i, String s) {
        super.setTitleAt(i, s);
        JPanel p = (JPanel)this.getTabComponentAt(i);
        ((TabPanel)p).setTitle(s);
    }

    @Override
    public String getToolTipText(MouseEvent e) {
        int index = this.indexAtLocation(e.getX(), e.getY());
        super.getToolTipText(e);
        if (index < 0) {
            return null;
        }
        this.current = index;
        String title = this.getTitleAt(index);
        TabPanel tp = (TabPanel)this.getTabComponentAt(index);
        if (tp.getEditingFile() != null) {
            return tp.getEditingFile().getPath();
        }
        return title;
    }

    @Override
    public JToolTip createToolTip() {
        this.initToolTip(this.tip, this.current);
        return this.tip;
    }

    private void initToolTip(JToolTip tip, int index) {
        tip.removeAll();
        JPanel panel = new JPanel(new BorderLayout());
        if (index < 0) {
            return;
        }
        String str = this.getTitleAt(index);
        panel.add((Component)new JLabel(str), "North");
        tip.setBorder(BorderFactory.createLineBorder(Color.BLACK));
        tip.setLayout(new BorderLayout());
        tip.add((Component)panel, "Center");
    }
}

