/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class FontProperty
extends JDialog {
    static final FontProperty INSTANCE = new FontProperty();
    private JPanel jContentPane = null;
    private JPanel choosePanel = null;
    private JLabel nameLabel = null;
    private JLabel styleLabel = null;
    private JLabel sizeLabel = null;
    private JScrollPane nameScrollPane = null;
    private JList nameList = null;
    private JScrollPane styleScrollPane = null;
    private JList styleList = null;
    private JScrollPane sizeScrollPane = null;
    private JList sizeList = null;
    private JTextField nameTextField = null;
    private JTextField styleTextField = null;
    private JTextField sizeTextField = null;
    private JtextPaneArea jTextArea = null;
    private JtextPaneArea fontTextArea = null;
    private JPanel determinePanel = null;
    private JButton okButton = null;
    private JButton cancelButton = null;
    private JScrollPane jScrollPane = null;
    private Font font = null;
    private final String[] fontNames = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
    private final String[] fontStyleNames = new String[]{"\u6a19\u6e96", "\u592a\u5b57", "\u659c\u4f53", "\u592a\u5b57 \u659c\u4f53"};
    private static final int[] FONT_STYLE;
    private static final int MIN_SIZE = 9;
    private static final int MAX_SIZE = 24;

    static {
        int[] nArray = new int[4];
        nArray[1] = 1;
        nArray[2] = 2;
        nArray[3] = 3;
        FONT_STYLE = nArray;
    }

    private FontProperty() {
        this.initialize();
    }

    private void initialize() {
        this.setTitle("\u30d5\u30a9\u30f3\u30c8");
        this.setSize(450, 350);
        this.setContentPane(this.getJContentPane());
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new BorderLayout());
            this.jContentPane.add((Component)this.getDeterminePanel(), "South");
            this.jContentPane.add((Component)this.getChoosePanel(), "Center");
        }
        return this.jContentPane;
    }

    private JPanel getChoosePanel() {
        if (this.choosePanel == null) {
            GridBagConstraints gridBagConstraints11 = new GridBagConstraints();
            GridBagConstraints gridBagConstraints10 = new GridBagConstraints();
            GridBagConstraints gridBagConstraints9 = new GridBagConstraints();
            GridBagConstraints gridBagConstraints8 = new GridBagConstraints();
            this.sizeLabel = new JLabel();
            this.styleLabel = new JLabel();
            this.nameLabel = new JLabel();
            GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
            GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
            GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
            this.choosePanel = new JPanel();
            this.choosePanel.setLayout(new GridBagLayout());
            gridBagConstraints1.gridx = 0;
            gridBagConstraints1.gridy = 0;
            this.nameLabel.setText("\u30d5\u30a9\u30f3\u30c8\u540d");
            gridBagConstraints2.gridx = 1;
            gridBagConstraints2.gridy = 0;
            this.styleLabel.setText("\u30b9\u30bf\u30a4\u30eb");
            gridBagConstraints3.gridx = 2;
            gridBagConstraints3.gridy = 0;
            this.sizeLabel.setText("\u30b5\u30a4\u30ba");
            gridBagConstraints4.gridx = 0;
            gridBagConstraints4.gridy = 2;
            gridBagConstraints4.weightx = 1.0;
            gridBagConstraints4.weighty = 1.0;
            gridBagConstraints4.fill = 1;
            gridBagConstraints5.gridx = 1;
            gridBagConstraints5.gridy = 2;
            gridBagConstraints5.weightx = 1.0;
            gridBagConstraints5.weighty = 1.0;
            gridBagConstraints5.fill = 1;
            gridBagConstraints6.gridx = 2;
            gridBagConstraints6.gridy = 2;
            gridBagConstraints6.weightx = 1.0;
            gridBagConstraints6.weighty = 1.0;
            gridBagConstraints6.fill = 1;
            gridBagConstraints8.weightx = 1.0;
            gridBagConstraints8.fill = 2;
            gridBagConstraints8.gridx = 0;
            gridBagConstraints8.gridy = 1;
            gridBagConstraints9.weightx = 1.0;
            gridBagConstraints9.fill = 2;
            gridBagConstraints9.gridx = 1;
            gridBagConstraints9.gridy = 1;
            gridBagConstraints10.weightx = 1.0;
            gridBagConstraints10.fill = 2;
            gridBagConstraints10.gridx = 2;
            gridBagConstraints10.gridy = 1;
            gridBagConstraints11.weightx = 1.0;
            gridBagConstraints11.weighty = 1.0;
            gridBagConstraints11.fill = 1;
            gridBagConstraints11.gridx = 0;
            gridBagConstraints11.gridy = 3;
            gridBagConstraints11.gridwidth = 3;
            gridBagConstraints11.insets = new Insets(10, 10, 10, 10);
            this.choosePanel.add((Component)this.nameLabel, gridBagConstraints1);
            this.choosePanel.add((Component)this.styleLabel, gridBagConstraints2);
            this.choosePanel.add((Component)this.sizeLabel, gridBagConstraints3);
            this.choosePanel.add((Component)this.getNameTextField(), gridBagConstraints8);
            this.choosePanel.add((Component)this.getStyleTextField(), gridBagConstraints9);
            this.choosePanel.add((Component)this.getSizeTextField(), gridBagConstraints10);
            this.choosePanel.add((Component)this.getJScrollPane(), gridBagConstraints11);
            this.choosePanel.add((Component)this.getNameScrollPane(), gridBagConstraints4);
            this.choosePanel.add((Component)this.getStyleScrollPane(), gridBagConstraints5);
            this.choosePanel.add((Component)this.getSizeScrollPane(), gridBagConstraints6);
        }
        return this.choosePanel;
    }

    private JScrollPane getNameScrollPane() {
        if (this.nameScrollPane == null) {
            this.nameScrollPane = new JScrollPane();
            this.nameScrollPane.setViewportView(this.getNameList());
            this.nameScrollPane.setVisible(true);
        }
        return this.nameScrollPane;
    }

    private JList getNameList() {
        if (this.nameList == null) {
            this.nameList = new JList<String>(this.fontNames);
            this.nameList.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    if (!e.getValueIsAdjusting()) {
                        JList li = (JList)e.getSource();
                        String nameStr = (String)li.getSelectedValue();
                        FontProperty.this.nameTextField.setText(nameStr);
                        FontProperty.this.font = new Font(nameStr, FontProperty.this.font.getStyle(), FontProperty.this.font.getSize());
                        FontProperty.this.fontTextArea.setFont(FontProperty.this.font);
                    }
                }
            });
        }
        return this.nameList;
    }

    private JScrollPane getStyleScrollPane() {
        if (this.styleScrollPane == null) {
            this.styleScrollPane = new JScrollPane();
            this.styleScrollPane.setViewportView(this.getStyleList());
        }
        return this.styleScrollPane;
    }

    private JList getStyleList() {
        if (this.styleList == null) {
            this.styleList = new JList<String>(this.fontStyleNames);
            this.styleList.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    if (!e.getValueIsAdjusting()) {
                        JList li = (JList)e.getSource();
                        int selectedIndex = li.getSelectedIndex();
                        if (selectedIndex < 0) {
                            selectedIndex = 0;
                        }
                        int style = FONT_STYLE[selectedIndex];
                        String styleStr = FontProperty.this.fontStyleNames[selectedIndex];
                        FontProperty.this.styleTextField.setText(styleStr);
                        FontProperty.this.font = new Font(FontProperty.this.font.getName(), style, FontProperty.this.font.getSize());
                        FontProperty.this.fontTextArea.setFont(FontProperty.this.font);
                    }
                }
            });
        }
        return this.styleList;
    }

    private JScrollPane getSizeScrollPane() {
        if (this.sizeScrollPane == null) {
            this.sizeScrollPane = new JScrollPane();
            this.sizeScrollPane.setViewportView(this.getSizeList());
        }
        return this.sizeScrollPane;
    }

    private JList getSizeList() {
        if (this.sizeList == null) {
            Object[] fontSize = new Object[16];
            int i = 9;
            while (i <= 24) {
                fontSize[i - 9] = Integer.toString(i);
                ++i;
            }
            this.sizeList = new JList<Object>(fontSize);
            this.sizeList.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    if (!e.getValueIsAdjusting()) {
                        JList li = (JList)e.getSource();
                        int size = li.getSelectedIndex() + 9;
                        String sizeStr = Integer.toString(size);
                        FontProperty.this.sizeTextField.setText(sizeStr);
                        FontProperty.this.font = new Font(FontProperty.this.font.getName(), FontProperty.this.font.getStyle(), size);
                        FontProperty.this.fontTextArea.setFont(FontProperty.this.font);
                    }
                }
            });
        }
        return this.sizeList;
    }

    private JTextField getNameTextField() {
        if (this.nameTextField == null) {
            this.nameTextField = new JTextField();
            this.nameTextField.setEditable(false);
        }
        return this.nameTextField;
    }

    private JTextField getStyleTextField() {
        if (this.styleTextField == null) {
            this.styleTextField = new JTextField();
            this.styleTextField.setEditable(false);
        }
        return this.styleTextField;
    }

    private JTextField getSizeTextField() {
        if (this.sizeTextField == null) {
            this.sizeTextField = new JTextField();
            this.sizeTextField.setEditable(false);
        }
        return this.sizeTextField;
    }

    private JScrollPane getJScrollPane() {
        if (this.jScrollPane == null) {
            this.jScrollPane = new JScrollPane();
            this.jScrollPane.setViewportView(this.getFontTextArea());
        }
        return this.jScrollPane;
    }

    private JtextPaneArea getFontTextArea() {
        if (this.fontTextArea == null) {
            this.fontTextArea = new JtextPaneArea();
            this.fontTextArea.setText("the quick brown fox jumped over the lazy dogs\n\u3044\u308d\u306f\u306b\u307b\u3078\u3068\u3000\u30a4\u30ed\u30cf\u30cb\u30db\u30d8\u30c8 \u4f0a\u5442\u6ce2");
        }
        return this.fontTextArea;
    }

    private JPanel getDeterminePanel() {
        if (this.determinePanel == null) {
            this.determinePanel = new JPanel();
            this.determinePanel.add((Component)this.getOkButton(), null);
            this.determinePanel.add((Component)this.getCancelButton(), null);
        }
        return this.determinePanel;
    }

    private JButton getOkButton() {
        if (this.okButton == null) {
            this.okButton = new JButton();
            this.okButton.setText("\u4e86\u89e3");
            this.getRootPane().setDefaultButton(this.okButton);
            this.okButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (FontProperty.this.font != null) {
                        FontProperty.this.jTextArea.setFont(FontProperty.this.font);
                    }
                    FontProperty.this.setVisible(false);
                }
            });
        }
        return this.okButton;
    }

    private JButton getCancelButton() {
        if (this.cancelButton == null) {
            this.cancelButton = new JButton();
            this.cancelButton.setText("\u53d6\u6d88\u3057");
            AbstractAction action = new AbstractAction("\u53d6\u6d88\u3057"){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    FontProperty.this.setVisible(false);
                }
            };
            this.cancelButton.getInputMap(2).put(KeyStroke.getKeyStroke(27, 0), "\u53d6\u6d88\u3057");
            this.cancelButton.getActionMap().put("\u53d6\u6d88\u3057", action);
            this.cancelButton.setAction(action);
        }
        return this.cancelButton;
    }

    void setJTextArea(JtextPaneArea jTextArea) {
        this.jTextArea = jTextArea;
        this.setLocationRelativeTo(jTextArea);
        this.font = jTextArea.getFont();
        String nameStr = this.font.getName();
        this.nameTextField.setText(nameStr);
        int i = 0;
        int n = this.fontNames.length;
        while (i < n) {
            if (this.fontNames[i].equals(nameStr)) {
                this.nameList.setSelectedIndex(i);
                this.nameList.ensureIndexIsVisible(i);
                break;
            }
            ++i;
        }
        int fontStyle = this.font.getStyle();
        this.styleTextField.setText(Integer.toString(fontStyle));
        String styleName = this.fontStyleNames[0];
        int styleIndexNum = 0;
        int i2 = 0;
        int n2 = FONT_STYLE.length;
        while (i2 < n2) {
            if (FONT_STYLE[i2] == fontStyle) {
                styleIndexNum = i2;
                styleName = this.fontStyleNames[i2];
                break;
            }
            ++i2;
        }
        this.styleList.setSelectedIndex(styleIndexNum);
        this.styleTextField.setText(styleName);
        int fontSize = this.font.getSize();
        int fontIndexNum = fontSize - 9;
        this.sizeList.setSelectedIndex(fontIndexNum);
        this.sizeList.ensureIndexIsVisible(fontIndexNum);
    }
}

