/*
 * Decompiled with CFR 0.152.
 */
package com.aibonware.viewnaver.window;

import com.aibonware.viewnaver.ViewNaver;
import com.aibonware.viewnaver.window.ChildWindowActivator;
import com.aibonware.viewnaver.window.MainWindow;
import java.awt.Window;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.awt.event.WindowListener;
import java.util.Vector;

public class ChildWindowActivatorImpl
implements ChildWindowActivator {
    private final MainWindow mainWindow;
    private Vector<Window> children = new Vector();
    private Object nowClosingChild = null;
    ChildWindowListener childWindowListener = new ChildWindowListener();

    public ChildWindowActivatorImpl(MainWindow mainWindow) {
        this.mainWindow = mainWindow;
        this.mainWindow.addWindowFocusListener(new WindowAdapter(){

            @Override
            public void windowGainedFocus(WindowEvent e) {
                if (ChildWindowActivatorImpl.this.nowClosingChild != null) {
                    int i = 0;
                    while (i < ChildWindowActivatorImpl.this.children.size()) {
                        Window childWindow = (Window)ChildWindowActivatorImpl.this.children.elementAt(i);
                        if (childWindow != ChildWindowActivatorImpl.this.nowClosingChild && childWindow.isVisible()) {
                            childWindow.toFront();
                            break;
                        }
                        ++i;
                    }
                    ChildWindowActivatorImpl.this.nowClosingChild = null;
                } else {
                    int i = 0;
                    while (i < ChildWindowActivatorImpl.this.children.size()) {
                        Window childWindow = (Window)ChildWindowActivatorImpl.this.children.elementAt(i);
                        if (childWindow.isVisible()) {
                            childWindow.setVisible(false);
                        }
                        ++i;
                    }
                }
            }
        });
    }

    @Override
    public void addChildWindow(Window childWindow) {
        this.children.addElement(childWindow);
        childWindow.addComponentListener(this.childWindowListener);
        childWindow.addWindowListener(this.childWindowListener);
        childWindow.addWindowFocusListener(this.childWindowListener);
    }

    @Override
    public void activateChildren() {
        Window childWindow;
        int i = this.children.size() - 1;
        while (i >= 0) {
            childWindow = this.children.elementAt(i);
            if (!childWindow.isVisible()) {
                childWindow.setVisible(true);
            }
            --i;
        }
        i = 0;
        while (i < this.children.size()) {
            childWindow = this.children.elementAt(i);
            if (childWindow.isVisible()) {
                childWindow.toFront();
                break;
            }
            ++i;
        }
    }

    @Override
    public void setClosingChild(Object child) {
        this.nowClosingChild = child;
    }

    private class ChildWindowListener
    implements ComponentListener,
    WindowListener,
    WindowFocusListener {
        private ChildWindowListener() {
        }

        @Override
        public void componentResized(ComponentEvent e) {
        }

        @Override
        public void componentMoved(ComponentEvent e) {
        }

        @Override
        public void windowOpened(WindowEvent e) {
        }

        @Override
        public void windowIconified(WindowEvent e) {
        }

        @Override
        public void windowDeiconified(WindowEvent e) {
        }

        @Override
        public void windowDeactivated(WindowEvent e) {
        }

        @Override
        public void windowActivated(WindowEvent e) {
        }

        @Override
        public void windowLostFocus(WindowEvent e) {
        }

        private void changeShowChildWindowButton() {
            int i = 0;
            while (i < ChildWindowActivatorImpl.this.children.size()) {
                if (!((Window)ChildWindowActivatorImpl.this.children.elementAt(i)).isVisible()) {
                    ViewNaver.instance.mainWindow.showChildWindowButton.setSelected(false);
                    return;
                }
                ++i;
            }
            ViewNaver.instance.mainWindow.showChildWindowButton.setSelected(true);
        }

        @Override
        public void componentHidden(ComponentEvent e) {
            this.changeShowChildWindowButton();
        }

        @Override
        public void componentShown(ComponentEvent e) {
            this.changeShowChildWindowButton();
        }

        @Override
        public void windowClosed(WindowEvent e) {
            Window childWindow = e.getWindow();
            ChildWindowActivatorImpl.this.children.removeElement(childWindow);
            childWindow.removeComponentListener(this);
            childWindow.removeWindowListener(this);
            childWindow.removeWindowFocusListener(this);
        }

        @Override
        public void windowGainedFocus(WindowEvent e) {
            Window childWindow = e.getWindow();
            ChildWindowActivatorImpl.this.children.removeElement(childWindow);
            ChildWindowActivatorImpl.this.children.insertElementAt(childWindow, 0);
        }

        @Override
        public void windowClosing(WindowEvent e) {
            ChildWindowActivatorImpl.this.nowClosingChild = e.getWindow();
        }
    }
}

