/*
 * Decompiled with CFR 0.152.
 */
package com.aibonware.viewnaver.task;

import com.aibonware.nvrlib.model.SearchType;
import com.aibonware.viewnaver.task.TaskFlow;
import com.aibonware.viewnaver.task.TaskFlowImpl;
import com.aibonware.viewnaver.view.LocalSearchType;
import java.util.HashMap;

public class TaskFlowList {
    private HashMap<Object, TaskFlow> children = new HashMap();

    public TaskFlow createNewFlow() {
        return this.getFlow(new Object());
    }

    private synchronized TaskFlow getFlow(Object tag) {
        TaskFlow taskFlow = this.children.get(tag);
        if (taskFlow == null) {
            taskFlow = new TaskFlowImpl(tag);
            this.children.put(tag, taskFlow);
        }
        return taskFlow;
    }

    public void removeFlow(TaskFlow taskFlow) {
        this.children.remove(taskFlow.getTag());
    }

    public TaskFlow getThreadFlow(String boardName, int nid) {
        return this.getFlow("read thread " + boardName + " nid=" + nid);
    }

    public TaskFlow getBoardFlow(String boardName, int pageNo) {
        return this.getFlow("read board " + boardName + " pageNo=" + pageNo);
    }

    public TaskFlow getSearchRemoteThreadFlow(String boardName, SearchType searchType, String keyword) {
        return this.getFlow("search remote thread " + boardName + ", " + searchType + ", " + keyword);
    }

    public TaskFlow getSearchLocalThreadFlow(LocalSearchType localSearchType, String poster, String keyword) {
        return this.getFlow("search local thread " + (Object)((Object)localSearchType) + ", " + poster + ", " + keyword);
    }

    public TaskFlow getDenyListFlow() {
        return this.getFlow("read deny list");
    }

    public TaskFlow getMessageListFlow() {
        return this.getFlow("read message list");
    }

    public TaskFlow getMessageFlow(int msgno) {
        return this.getFlow("read message " + msgno);
    }

    public TaskFlow getArticleFlow(String boardName, int nid, int articleId) {
        return this.getFlow("read article " + boardName + " nid=" + nid + " aid=" + articleId);
    }

    public TaskFlow getLoginFlow() {
        return this.getFlow("login");
    }
}

