/*
 * Decompiled with CFR 0.152.
 */
package com.aibonware.viewnaver.storage;

import com.aibonware.nvrlib.model.Message;
import com.aibonware.viewnaver.Util;
import com.aibonware.viewnaver.ViewNaver;
import com.aibonware.viewnaver.storage.StorageException;
import com.aibonware.viewnaver.xml.BaseXMLReader;
import com.aibonware.viewnaver.xml.MessageReader;
import com.aibonware.viewnaver.xml.MessageSerializer;
import com.aibonware.viewnaver.xml.XMLReaderException;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.TreeMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class MessageStorage {
    TreeMap<Integer, Message> sentMessages = new TreeMap();
    TreeMap<Integer, Message> receivedMessages = new TreeMap();

    private TreeMap<Integer, Message> getMessages(String dir) throws StorageException {
        if (!Util.makeSureDir(dir)) {
            throw new StorageException("\u30c7\u30a3\u30ec\u30af\u30c8\u30ea'" + dir + "'\u304c\u4f5c\u6210\u3067\u304d\u307e\u305b\u3093\u3002");
        }
        File[] files = new File(dir).listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.startsWith("message") && name.endsWith(".xml");
            }
        });
        TreeMap<Integer, Message> messages = new TreeMap<Integer, Message>();
        int i = 0;
        while (i < files.length) {
            File file = files[i];
            Message message = this.readMessage(file);
            if (message != null) {
                messages.put(message.messageId, message);
            }
            ++i;
        }
        return messages;
    }

    private Message readMessage(File file) {
        try {
            DocumentBuilderFactory dbfactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = dbfactory.newDocumentBuilder();
            Document doc = builder.parse(new BufferedInputStream(new FileInputStream(file)));
            Element root = doc.getDocumentElement();
            Element messageElem = BaseXMLReader.getAttrElem(root, "Message");
            MessageReader reader = new MessageReader();
            Message message = reader.parse(messageElem);
            return message;
        }
        catch (IOException e) {
            ViewNaver.err(e);
            return null;
        }
        catch (XMLReaderException e) {
            ViewNaver.err(e);
            return null;
        }
        catch (SAXException e) {
            ViewNaver.err(e);
            return null;
        }
        catch (ParserConfigurationException e) {
            ViewNaver.err(e);
            return null;
        }
    }

    public TreeMap<Integer, Message> getSentMessages(String loginUserName) throws StorageException {
        this.sentMessages = this.getMessages("message" + File.separator + loginUserName + File.separator + "sent" + File.separator);
        return this.sentMessages;
    }

    public Message getSentMessage(int messageId) {
        return this.sentMessages.get(messageId);
    }

    public TreeMap<Integer, Message> getReceivedMessages(String loginUserName) throws StorageException {
        this.receivedMessages = this.getMessages("message" + File.separator + loginUserName + File.separator + "received" + File.separator);
        return this.receivedMessages;
    }

    public Message getReceivedMessage(int messageId) {
        return this.receivedMessages.get(messageId);
    }

    private void saveMessage(String dir, Message message) throws StorageException {
        try {
            DocumentBuilderFactory dbfactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = dbfactory.newDocumentBuilder();
            Document doc = builder.newDocument();
            Element root = doc.createElement("NDX");
            doc.appendChild(root);
            MessageSerializer serializer = new MessageSerializer(doc);
            root.appendChild(serializer.serialize(message));
            TransformerFactory factory = TransformerFactory.newInstance();
            Transformer transformer = factory.newTransformer();
            transformer.setOutputProperty("method", "xml");
            transformer.setOutputProperty("indent", "yes");
            transformer.transform(new DOMSource(root.getOwnerDocument()), new StreamResult(String.valueOf(dir) + "message" + message.messageId + ".xml"));
        }
        catch (ParserConfigurationException e) {
            throw new StorageException(e);
        }
        catch (TransformerConfigurationException e) {
            throw new StorageException(e);
        }
        catch (TransformerException e) {
            throw new StorageException(e);
        }
    }

    public void saveSentMessage(String loginUserName, Message message) throws StorageException {
        this.sentMessages.put(message.messageId, message);
        this.saveMessage("message" + File.separator + loginUserName + File.separator + "sent" + File.separator, message);
    }

    public void saveReceivedMessage(String loginUserName, Message message) throws StorageException {
        this.receivedMessages.put(message.messageId, message);
        this.saveMessage("message" + File.separator + loginUserName + File.separator + "received" + File.separator, message);
    }
}

