/*
 * Decompiled with CFR 0.152.
 */
package com.aibonware.viewnaver.server.image;

import com.aibonware.viewnaver.ViewNaver;
import com.aibonware.viewnaver.server.UserSession;
import com.aibonware.viewnaver.server.conv.ConverterFilter;
import com.aibonware.viewnaver.server.image.ImageServlet;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ImageConverterFilter
implements ConverterFilter {
    private char marker;
    Vector<ImageTag> tags = new Vector();

    public ImageConverterFilter() {
        this.marker = ViewNaver.instance.getPUA(ImageConverterFilter.class);
    }

    @Override
    public String preprocess(String contents) {
        Matcher matcher = Pattern.compile("<img.*?>", 2).matcher(contents);
        int start = 0;
        while (matcher.find(start)) {
            start = matcher.start();
            int end = matcher.end();
            this.tags.addElement(new ImageTag(contents.substring(start, end)));
            start = end;
        }
        contents = matcher.replaceAll(String.valueOf(this.marker));
        return contents;
    }

    @Override
    public String postprocess(UserSession user, String contents) {
        Pattern pat1 = Pattern.compile("src\\s*=\\s*", 2);
        Pattern pat2 = Pattern.compile("[\\\"'\\s]");
        int i = 0;
        while (i < this.tags.size()) {
            ImageTag tag = this.tags.elementAt(i);
            int pos = contents.indexOf(this.marker);
            Matcher mat1 = pat1.matcher(tag.tag);
            Matcher mat2 = pat2.matcher(tag.tag);
            try {
                char c;
                mat1.find();
                int start = mat1.end();
                while (Character.isWhitespace(c = tag.tag.charAt(start)) || c == '\'' || c == '\"') {
                    ++start;
                }
                mat2.find(start);
                int end = mat2.end() - 1;
                String url = tag.tag.substring(start, end).trim();
                if (url.startsWith("\"") || url.startsWith("'")) {
                    url = url.substring(1);
                }
                int imageNo = user.imageCache.putImageUrl(url);
                contents = String.valueOf(contents.substring(0, pos)) + "<img src=\"" + ImageServlet.createUrl(user, imageNo) + "\">" + contents.substring(pos + 1);
            }
            catch (IllegalStateException e) {
                contents = String.valueOf(contents.substring(0, pos)) + "#img" + contents.substring(pos + 1);
            }
            ++i;
        }
        return contents;
    }

    @Override
    public ConverterFilter newInstance() {
        return new ImageConverterFilter();
    }

    private static class ImageTag {
        public final String tag;

        public ImageTag(String tag) {
            this.tag = tag;
        }
    }
}

