/*
 * Decompiled with CFR 0.152.
 */
package com.aibonware.viewnaver.content.message;

import com.aibonware.nvrlib.model.Message;
import com.aibonware.nvrlib.model.MessageTitle;
import com.aibonware.nvrlib.model.Poster;
import com.aibonware.nvrlib.net.NaverSession;
import com.aibonware.nvrlib.net.NetException;
import com.aibonware.nvrlib.parser.ParsingException;
import com.aibonware.nvrlib.parser.ReplyMessageParser;
import com.aibonware.viewnaver.ViewNaver;
import com.aibonware.viewnaver.content.TabContentCategory;
import com.aibonware.viewnaver.content.message.MessageContentView;
import com.aibonware.viewnaver.content.message.MessageListView;
import com.aibonware.viewnaver.storage.StorageException;
import com.aibonware.viewnaver.task.ButtonBarStatus;
import com.aibonware.viewnaver.task.GUITask;
import com.aibonware.viewnaver.task.TaskFlow;
import com.aibonware.viewnaver.task.WorkerTask;
import com.aibonware.viewnaver.window.WriteMessageWindow;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.HashSet;
import javax.swing.AbstractAction;
import javax.swing.JButton;

public class ReceivedMessageContentView
extends MessageContentView {
    protected JButton replyButton = new JButton("\u8fd4\u4fe1");
    protected JButton denyButton = new JButton("\u53d7\u4fe1\u62d2\u5426");
    private ButtonBarStatus buttonStatus;

    public ReceivedMessageContentView(TabContentCategory category) {
        super(category, "http://bbs.enjoykorea.jp/memo/memo_view.php?no=", new MessageListView.MessageAdapter(){

            @Override
            public void saveMessage(Message message) {
                try {
                    ViewNaver.instance.messageStorage.saveReceivedMessage(ViewNaver.instance.multiSession.getUserName(), message);
                }
                catch (StorageException e) {
                    ViewNaver.err(e);
                }
            }

            @Override
            public Message getMessage(int messageId) {
                return ViewNaver.instance.messageStorage.getReceivedMessage(messageId);
            }
        });
        this.replyButton.setAction(new AbstractAction("\u8fd4\u4fe1"){

            @Override
            public void actionPerformed(ActionEvent event) {
                final MessageTitle message = ReceivedMessageContentView.this.messageListView.getSelectedMessage();
                if (message == null) {
                    return;
                }
                TaskFlow taskFlow = ViewNaver.instance.taskFlowList.getMessageFlow(message.messageId);
                ReceivedMessageContentView.this.buttonStatus.beginTask(ReceivedMessageContentView.this.replyButton, taskFlow, new JButton[]{ReceivedMessageContentView.this.updateButton, ReceivedMessageContentView.this.serverButton, ReceivedMessageContentView.this.denyButton, ReceivedMessageContentView.this.closeButton});
                taskFlow.execute(new WorkerTask(ViewNaver.instance.appTools){

                    @Override
                    public void exec() {
                        try {
                            ViewNaver.println("\u8fd4\u4fe1\u30e1\u30c3\u30bb\u30fc\u30b8\u306e\u8aad\u307f\u8fbc\u307f\u958b\u59cb..");
                            ReplyMessageParser parser = new ReplyMessageParser("http://bbs.enjoykorea.jp/memo/memo_write.php?receive_id=" + message.person + "&id_national=" + message.country.toChar() + "&st=" + message.messageId);
                            final String replyText = parser.parse((NaverSession)ViewNaver.instance.multiSession);
                            ViewNaver.println("\u8fd4\u4fe1\u30e1\u30c3\u30bb\u30fc\u30b8\u306e\u8aad\u307f\u8fbc\u307f\u7d42\u4e86\u3002");
                            this.taskFlow.execute(new GUITask(ViewNaver.instance.appTools){

                                @Override
                                public void exec() {
                                    WriteMessageWindow replyWindow = new WriteMessageWindow(ViewNaver.instance.mainWindow, message.person, message.country, replyText);
                                    replyWindow.setVisible(true);
                                }
                            });
                        }
                        catch (NetException e) {
                            ViewNaver.err((Exception)((Object)e));
                        }
                        catch (ParsingException e) {
                            ViewNaver.err((Exception)((Object)e));
                        }
                    }
                });
            }
        });
        this.denyButton.setAction(new AbstractAction("\u53d7\u4fe1\u62d2\u5426"){

            @Override
            public void actionPerformed(ActionEvent e) {
                MessageTitle[] messageList = ReceivedMessageContentView.this.messageListView.getSelectedMessageList();
                if (messageList.length == 0) {
                    ViewNaver.println("\u30e1\u30c3\u30bb\u30fc\u30b8\u304c\u9078\u629e\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002");
                    return;
                }
                final HashSet<Poster> senders = new HashSet<Poster>();
                int i = 0;
                while (i < messageList.length) {
                    Poster sender = new Poster(messageList[i].person, messageList[i].country);
                    if (!senders.contains(sender)) {
                        senders.add(sender);
                    }
                    ++i;
                }
                TaskFlow taskFlow = ViewNaver.instance.taskFlowList.getDenyListFlow();
                ReceivedMessageContentView.this.buttonStatus.beginTask(ReceivedMessageContentView.this.denyButton, taskFlow, new JButton[]{ReceivedMessageContentView.this.updateButton, ReceivedMessageContentView.this.serverButton, ReceivedMessageContentView.this.replyButton, ReceivedMessageContentView.this.closeButton});
                taskFlow.execute(new WorkerTask(ViewNaver.instance.appTools){

                    @Override
                    public void exec() {
                        try {
                            for (Poster sender : senders) {
                                ViewNaver.println(String.valueOf(sender.name) + "\u306e\u53d7\u4fe1\u62d2\u5426\u958b\u59cb..");
                                ViewNaver.instance.multiSession.denyMessage(sender.name, sender.country);
                            }
                            ViewNaver.println("\u53d7\u4fe1\u62d2\u5426\u7d42\u4e86\u3002");
                        }
                        catch (NetException e) {
                            ViewNaver.err((Exception)((Object)e));
                        }
                    }
                });
            }
        });
        this.toolbar.addSeparator();
        this.toolbar.add(this.replyButton);
        this.toolbar.add(this.denyButton);
        this.add((Component)this.toolbar, "North");
        this.buttonStatus = new ButtonBarStatus(new JButton[]{this.updateButton, this.serverButton, this.replyButton, this.denyButton}, new JButton[]{this.closeButton});
    }

    @Override
    public void beginTask(JButton taskButton, TaskFlow taskFlow) {
        this.buttonStatus.beginTask(taskButton, taskFlow, new JButton[]{this.updateButton, this.serverButton, this.replyButton, this.denyButton, this.closeButton});
    }

    @Override
    public void beginUpdateTask(TaskFlow taskFlow) {
        this.buttonStatus.beginTask(this.updateButton, taskFlow, new JButton[]{this.serverButton, this.replyButton, this.denyButton, this.closeButton});
    }

    @Override
    protected void saveServerMessage(int[] messageIdList) throws NetException {
        ViewNaver.instance.multiSession.saveReceivedMessage(messageIdList);
    }

    @Override
    protected void deleteServerMessage(int[] messageIdList) throws NetException {
        ViewNaver.instance.multiSession.deleteReceivedMessage(messageIdList);
    }
}

