/*
 * Decompiled with CFR 0.152.
 */
package com.aibonware.viewnaver.content.message;

import com.aibonware.nvrlib.model.Message;
import com.aibonware.nvrlib.model.MessageTitle;
import com.aibonware.nvrlib.model.MessageTitleList;
import com.aibonware.nvrlib.net.NaverSession;
import com.aibonware.nvrlib.net.NetException;
import com.aibonware.nvrlib.parser.MessageParser;
import com.aibonware.nvrlib.parser.ParsingException;
import com.aibonware.viewnaver.ViewNaver;
import com.aibonware.viewnaver.browser.Browser;
import com.aibonware.viewnaver.content.message.MessageContentView;
import com.aibonware.viewnaver.task.GUITask;
import com.aibonware.viewnaver.task.TaskFlow;
import com.aibonware.viewnaver.task.WorkerTask;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.SimpleDateFormat;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumnModel;

public class MessageListView
extends JTable {
    private MessageTitleList titles = null;
    private final Browser messageArea;
    private final String messageUrlBase;
    private final JLabel messageHeader;
    private final MessageAdapter messageAdapter;
    private MessageContentView parent;
    private Object[] headerNames = new Object[]{"No", "Server state", "Date", "Country", "ID", "Title"};
    private int[] headerWidthList = new int[]{40, 30, 80, 30, 90, 400};
    private DefaultTableModel tableModel = new DefaultTableModel(this.headerNames, 0){

        @Override
        public boolean isCellEditable(int row, int column) {
            return false;
        }
    };
    private TableColumnModel columnModel;
    private static SimpleDateFormat titleDateFormat = new SimpleDateFormat("yyyy/MM/dd");
    private static SimpleDateFormat headerDateFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");

    private void initController() {
        this.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                int row = MessageListView.this.getSelectedRow();
                if (row == -1) {
                    return;
                }
                MessageTitle title = MessageListView.this.titles.getMessageTitle(row);
                Message message = MessageListView.this.messageAdapter.getMessage(title.messageId);
                if (message == null) {
                    MessageListView.this.showEmptyMessage();
                } else {
                    MessageListView.this.showMessage(message, title.title);
                }
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent event) {
                if (event.getClickCount() > 1) {
                    int row = MessageListView.this.rowAtPoint(event.getPoint());
                    if (row == -1) {
                        return;
                    }
                    if (!ViewNaver.instance.multiSession.nowLogin()) {
                        ViewNaver.println("\u30ed\u30b0\u30a4\u30f3\u3057\u3066\u3044\u307e\u305b\u3093");
                        return;
                    }
                    final MessageTitle messageTitle = MessageListView.this.titles.getMessageTitle(row);
                    TaskFlow taskFlow = ViewNaver.instance.taskFlowList.getMessageFlow(messageTitle.messageId);
                    MessageListView.this.parent.beginTask(null, taskFlow);
                    taskFlow.execute(new WorkerTask(ViewNaver.instance.appTools){

                        @Override
                        public void exec() {
                            try {
                                ViewNaver.println("\u30e1\u30c3\u30bb\u30fc\u30b8No." + messageTitle.messageId + "\u306e\u8aad\u307f\u8fbc\u307f\u958b\u59cb..");
                                MessageParser parser = new MessageParser(messageTitle, String.valueOf(MessageListView.this.messageUrlBase) + messageTitle.messageId);
                                final Message message = parser.parse((NaverSession)ViewNaver.instance.multiSession);
                                ViewNaver.println("\u30e1\u30c3\u30bb\u30fc\u30b8No." + messageTitle.messageId + "\u306e\u8aad\u307f\u8fbc\u307f\u7d42\u4e86\u3002");
                                MessageListView.this.messageAdapter.saveMessage(message);
                                this.taskFlow.execute(new GUITask(ViewNaver.instance.appTools){

                                    @Override
                                    public void exec() {
                                        MessageListView.this.showMessage(message, messageTitle.title);
                                    }
                                });
                            }
                            catch (ParsingException e) {
                                ViewNaver.err((Exception)((Object)e));
                            }
                            catch (NetException e) {
                                ViewNaver.err((Exception)((Object)e));
                            }
                        }
                    });
                }
            }
        });
    }

    public MessageListView(MessageContentView parent, Browser messageArea, String messageUrlBase, JLabel messageHeader, MessageAdapter messageSaver) {
        this.parent = parent;
        this.messageArea = messageArea;
        this.messageUrlBase = messageUrlBase;
        this.messageHeader = messageHeader;
        this.messageAdapter = messageSaver;
        this.setModel(this.tableModel);
        this.columnModel = this.getColumnModel();
        int i = 0;
        while (i < this.headerWidthList.length) {
            this.columnModel.getColumn(i).setPreferredWidth(this.headerWidthList[i]);
            ++i;
        }
        this.setShowGrid(false);
        this.initController();
    }

    public void showEmptyMessage() {
        this.messageArea.setBodyHtml("<font color=gray><i>\uff08\u3053\u306e\u30e1\u30c3\u30bb\u30fc\u30b8\u306e\u5185\u5bb9\u306f\u307e\u3060\u30b5\u30fc\u30d0\u304b\u3089\u53d6\u5f97\u3057\u3066\u3044\u307e\u305b\u3093\u3002\uff09</i></font>");
        this.messageHeader.setText(" ");
    }

    public void showMessage(Message message, String title) {
        this.messageArea.setBodyHtml("<font face=\"" + ViewNaver.instance.platform.getDefaultFont() + "\">" + message.text + "</font>");
        this.messageHeader.setText("    " + message.country + " " + message.poster + "     " + headerDateFormat.format(message.postDate));
    }

    public void setMessageList(MessageTitleList newTitles) {
        if (this.titles != null) {
            this.titles.merge(newTitles);
        } else {
            this.titles = newTitles;
        }
        this.titles.sort();
        this.messageArea.setBodyHtml("");
        this.messageHeader.setText(" ");
        this.tableModel.setRowCount(0);
        if (this.titles == null) {
            return;
        }
        int i = 0;
        while (i < this.titles.getMessageCount()) {
            MessageTitle title = this.titles.getMessageTitle(i);
            String readText = title.received ? " " : "*";
            String serverState = title.remoteStored ? "s" : " ";
            this.tableModel.addRow(new Object[]{title.messageId, serverState, titleDateFormat.format(title.date), title.country, String.valueOf(readText) + title.person, title.title});
            ++i;
        }
    }

    public MessageTitle getSelectedMessage() {
        int row = this.getSelectedRow();
        if (row == -1) {
            return null;
        }
        return this.titles.getMessageTitle(row);
    }

    public int[] getSelectedMessageIdList() {
        int[] rows = this.getSelectedRows();
        int[] idList = new int[rows.length];
        int i = 0;
        while (i < rows.length) {
            idList[i] = this.titles.getMessageTitle((int)rows[i]).messageId;
            ++i;
        }
        return idList;
    }

    public MessageTitle[] getSelectedMessageList() {
        int[] rows = this.getSelectedRows();
        MessageTitle[] messageList = new MessageTitle[rows.length];
        int i = 0;
        while (i < rows.length) {
            messageList[i] = this.titles.getMessageTitle(rows[i]);
            ++i;
        }
        return messageList;
    }

    public static interface MessageAdapter {
        public void saveMessage(Message var1);

        public Message getMessage(int var1);
    }
}

