/*
 * Decompiled with CFR 0.152.
 */
package com.aibonware.viewnaver.content.localsearch;

import com.aibonware.nvrlib.model.Poster;
import com.aibonware.nvrlib.task.TaskCanceller;
import com.aibonware.viewnaver.ViewNaver;
import com.aibonware.viewnaver.browser.Browser;
import com.aibonware.viewnaver.browser.BrowserListener;
import com.aibonware.viewnaver.command.ShowThreadCommand;
import com.aibonware.viewnaver.content.TabContent;
import com.aibonware.viewnaver.content.TabContentCategory;
import com.aibonware.viewnaver.content.TabContentView;
import com.aibonware.viewnaver.content.localsearch.LocalFoundContent;
import com.aibonware.viewnaver.model.Article;
import com.aibonware.viewnaver.model.ArticleList;
import com.aibonware.viewnaver.model.CompositeThread;
import com.aibonware.viewnaver.model.FilterType;
import com.aibonware.viewnaver.model.NThread;
import com.aibonware.viewnaver.storage.ThreadStorageWalker;
import com.aibonware.viewnaver.task.GUITask;
import com.aibonware.viewnaver.task.TaskFlow;
import com.aibonware.viewnaver.task.TaskStatusReceiver;
import com.aibonware.viewnaver.task.WorkerTask;
import com.aibonware.viewnaver.view.LocalSearchType;
import com.aibonware.viewnaver.window.SearchLocalThreadDialog;
import com.aibonware.viewnaver.xml.BaseXMLReader;
import com.aibonware.viewnaver.xml.CompositeThreadReader;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.text.SimpleDateFormat;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import javax.swing.border.BevelBorder;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;

public class LocalFoundContentView
extends TabContentView {
    public Browser browser;
    private boolean mustCancel = false;
    private String SPAN;
    private String HR;
    private LocalFoundContent clientContent;
    private static SimpleDateFormat df = new SimpleDateFormat("MM/dd HH:mm");
    JButton searchThreadButton;
    JButton closeButton;
    AbstractAction searchThreadAction;
    private int count;
    private String curBoardName;

    public LocalFoundContentView(TabContentCategory category) {
        super(category);
        this.SPAN = ViewNaver.instance.getBrowserFactory().SPAN;
        this.HR = ViewNaver.instance.getBrowserFactory().HR;
        this.clientContent = null;
        this.searchThreadButton = new JButton();
        this.closeButton = new JButton("\u9589\u3058\u308b");
        this.searchThreadAction = new AbstractAction("\u691c\u7d22"){

            @Override
            public void actionPerformed(ActionEvent e) {
                SearchLocalThreadDialog dialog = new SearchLocalThreadDialog(ViewNaver.instance.mainWindow, ((LocalFoundContentView)LocalFoundContentView.this).clientContent.category.keyword, ((LocalFoundContentView)LocalFoundContentView.this).clientContent.category.localSearchType);
                dialog.setVisible(true);
            }
        };
        this.count = 0;
        this.curBoardName = "";
        this.setLayout(new BorderLayout());
        String initialHtml = "<html><head><meta http-equiv=\"Content-Type\" content=\"text/html\"></head><body></body></html>";
        this.browser = ViewNaver.instance.getBrowserFactory().createBrowser(initialHtml);
        JPanel panel = new JPanel(new BorderLayout());
        panel.setBorder(new BevelBorder(1));
        panel.add(this.browser.getComponent());
        this.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LocalFoundContentView.this.mustCancel = true;
                ViewNaver.instance.mainWindow.container.removeContent(LocalFoundContentView.this.clientContent);
            }
        });
        JToolBar toolbar = new JToolBar();
        toolbar.add(this.closeButton);
        this.searchThreadButton.setAction(this.searchThreadAction);
        toolbar.add(this.searchThreadButton);
        toolbar.setFloatable(false);
        this.add((Component)toolbar, "North");
        this.add((Component)panel, "Center");
        this.browser.addBrowserListener(new BrowserListener(){

            @Override
            public boolean beforeNavigate(String url) {
                if (url.startsWith("thread:")) {
                    url = url.substring("thread:".length());
                    int dotPos = url.indexOf(46);
                    String boardName = url.substring(0, dotPos);
                    int nid = Integer.parseInt(url.substring(dotPos + 1));
                    TaskFlow taskFlow = ViewNaver.instance.taskFlowList.getThreadFlow(boardName, nid);
                    taskFlow.execute(new ShowThreadCommand(boardName, nid));
                }
                return false;
            }
        });
    }

    public TaskStatusReceiver createTaskStatusReceiver(final TaskFlow taskFlow) {
        return new TaskStatusReceiver(){

            @Override
            public void statusChanged(int status) {
                if (status == 0) {
                    LocalFoundContentView.this.searchThreadButton.setAction(new AbstractAction("\u4e2d\u6b62"){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            taskFlow.cancel();
                        }
                    });
                    LocalFoundContentView.this.closeButton.setEnabled(false);
                } else if (status == 1) {
                    LocalFoundContentView.this.searchThreadButton.setAction(LocalFoundContentView.this.searchThreadAction);
                    LocalFoundContentView.this.closeButton.setEnabled(true);
                }
            }
        };
    }

    @Override
    public void setClientContent(TabContent content) {
        this.clientContent = (LocalFoundContent)content;
        final LocalSearchType localSearchType = this.clientContent.category.localSearchType;
        final String poster = this.clientContent.category.poster;
        final String keyword = this.clientContent.category.keyword;
        this.count = 0;
        this.curBoardName = null;
        this.browser.setBodyHtml("<font size=-1><" + this.SPAN + " id=\"hit:0\"></" + this.SPAN + "></font>");
        TaskFlow taskFlow = ViewNaver.instance.taskFlowList.getSearchLocalThreadFlow(localSearchType, poster, keyword);
        taskFlow.addStatusReceiver(this.createTaskStatusReceiver(taskFlow));
        taskFlow.execute(new WorkerTask(ViewNaver.instance.appTools){

            @Override
            public void exec() {
                TaskCanceller canceller = new TaskCanceller(){

                    public void cancel() {
                        LocalFoundContentView.this.mustCancel = true;
                    }
                };
                this.taskFlow.addTaskCanceller(canceller);
                try {
                    try {
                        DocumentBuilderFactory dbfactory = DocumentBuilderFactory.newInstance();
                        final DocumentBuilder builder = dbfactory.newDocumentBuilder();
                        final CompositeThreadReader compositeThreadReader = new CompositeThreadReader();
                        ViewNaver.instance.threadStorage.flash();
                        ViewNaver.instance.threadStorage.walkFiles(new ThreadStorageWalker(){

                            @Override
                            public void finished() {
                                ViewNaver.println("\u30ed\u30b0\u691c\u7d22\u5b8c\u4e86\u3002");
                            }

                            @Override
                            public void canceled() {
                                ViewNaver.println("\u30ed\u30b0\u691c\u7d22\u30ad\u30e3\u30f3\u30bb\u30eb\u3002");
                            }

                            /*
                             * Enabled aggressive block sorting
                             * Enabled unnecessary exception pruning
                             * Enabled aggressive exception aggregation
                             */
                            @Override
                            public boolean walk(File file) {
                                try {
                                    String text;
                                    if (LocalFoundContentView.this.mustCancel) {
                                        LocalFoundContentView.this.mustCancel = false;
                                        return false;
                                    }
                                    StringBuffer buf = new StringBuffer();
                                    BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF8"));
                                    while (true) {
                                        String line;
                                        if ((line = reader.readLine()) == null) {
                                            reader.close();
                                            text = buf.toString();
                                            boolean preMatch = true;
                                            if (poster != null && !text.contains(poster)) {
                                                preMatch = false;
                                            }
                                            if (keyword != null && preMatch && !text.contains(keyword)) {
                                                return true;
                                            }
                                            if (preMatch) break;
                                            return true;
                                        }
                                        buf.append(line);
                                    }
                                    Document doc = builder.parse(new InputSource(new StringReader(text)));
                                    Element root = doc.getDocumentElement();
                                    Element threadElem = BaseXMLReader.getAttrElem(root, "CompositeThread");
                                    CompositeThread compositeThread = compositeThreadReader.parse(threadElem);
                                    if (localSearchType.equals((Object)LocalSearchType.SearchThreadTitle)) {
                                        if (poster != null && !poster.equals(((NThread)compositeThread.thread).poster)) {
                                            return true;
                                        }
                                        if (keyword != null && !((NThread)compositeThread.thread).title.contains(keyword)) {
                                            return true;
                                        }
                                        LocalFoundContentView.this.addThreadHit(taskFlow, compositeThread);
                                        return true;
                                    }
                                    if (localSearchType.equals((Object)LocalSearchType.SearchThreadContent)) {
                                        if (poster != null && !poster.equals(((NThread)compositeThread.thread).poster)) {
                                            return true;
                                        }
                                        if (keyword != null && !compositeThread.contents.contains(keyword)) {
                                            return true;
                                        }
                                        LocalFoundContentView.this.addThreadHit(taskFlow, compositeThread);
                                        return true;
                                    }
                                    int artNum = ((ArticleList)compositeThread.articleList).getArticleCount();
                                    int i = artNum - 1;
                                    while (true) {
                                        if (i < 0) {
                                            return true;
                                        }
                                        Article art = (Article)((ArticleList)compositeThread.articleList).getArticle(i);
                                        if ((poster == null || poster.equals(art.author)) && (keyword == null || art.content.contains(keyword))) {
                                            LocalFoundContentView.this.addArticleHit(taskFlow, compositeThread, art, keyword);
                                        }
                                        --i;
                                    }
                                }
                                catch (Exception e) {
                                    ViewNaver.err(e);
                                    return false;
                                }
                            }
                        });
                    }
                    catch (Exception e) {
                        ViewNaver.err(e);
                        this.taskFlow.removeTaskCanceller(canceller);
                    }
                }
                finally {
                    this.taskFlow.removeTaskCanceller(canceller);
                }
            }
        });
    }

    private void addBoardName(String name) {
        ++this.count;
        this.browser.insertBodyHtml("hit:" + (this.count - 1), String.valueOf(this.HR) + "<" + this.SPAN + " id=\"hit:" + this.count + "\">" + name + "\uff1a<br><br>\n</" + this.SPAN + ">");
    }

    private void addThreadHit(TaskFlow taskFlow, final CompositeThread compositeThread) {
        FilterType filterType = ViewNaver.instance.config.getFilterConfig().filters.get(new Poster(((NThread)compositeThread.thread).poster, ((NThread)compositeThread.thread).country));
        if (filterType != null) {
            return;
        }
        taskFlow.execute(new GUITask(ViewNaver.instance.appTools){

            @Override
            public void exec() {
                if (!compositeThread.boardName.equals(LocalFoundContentView.this.curBoardName)) {
                    LocalFoundContentView.this.curBoardName = compositeThread.boardName;
                    LocalFoundContentView.this.addBoardName(LocalFoundContentView.this.curBoardName);
                }
                LocalFoundContentView localFoundContentView = LocalFoundContentView.this;
                localFoundContentView.count = localFoundContentView.count + 1;
                LocalFoundContentView.this.browser.insertBodyHtml("hit:" + (LocalFoundContentView.this.count - 1), "<" + LocalFoundContentView.this.SPAN + " id=\"hit:" + LocalFoundContentView.this.count + "\">" + "<a href=\"thread:" + compositeThread.boardName + "." + ((NThread)compositeThread.thread).nid + "\">" + ((NThread)compositeThread.thread).dispId + "</a> " + df.format(((NThread)compositeThread.thread).createDate) + " " + ((NThread)compositeThread.thread).country.toHtml() + " " + " <b>" + ((NThread)compositeThread.thread).poster + "</b> " + ViewNaver.htmlToStr(((NThread)compositeThread.thread).title) + "<br><br>\n</" + LocalFoundContentView.this.SPAN + ">");
            }
        });
    }

    private void addArticleHit(TaskFlow taskFlow, final CompositeThread compositeThread, final Article article, final String keyword) {
        FilterType filterType = ViewNaver.instance.config.getFilterConfig().filters.get(new Poster(((NThread)compositeThread.thread).poster, ((NThread)compositeThread.thread).country));
        if (filterType != null) {
            return;
        }
        taskFlow.execute(new GUITask(ViewNaver.instance.appTools){

            @Override
            public void exec() {
                if (!compositeThread.boardName.equals(LocalFoundContentView.this.curBoardName)) {
                    LocalFoundContentView.this.curBoardName = compositeThread.boardName;
                    LocalFoundContentView.this.addBoardName(LocalFoundContentView.this.curBoardName);
                }
                LocalFoundContentView localFoundContentView = LocalFoundContentView.this;
                localFoundContentView.count = localFoundContentView.count + 1;
                String articleContent = ViewNaver.htmlToStr(article.content);
                if (keyword != null) {
                    articleContent = articleContent.replace(keyword, "<b>" + keyword + "</b>");
                }
                LocalFoundContentView.this.browser.insertBodyHtml("hit:" + (LocalFoundContentView.this.count - 1), "<" + LocalFoundContentView.this.SPAN + " id=\"hit:" + LocalFoundContentView.this.count + "\">" + "<a href=\"thread:" + compositeThread.boardName + "." + ((NThread)compositeThread.thread).nid + "\">" + ((NThread)compositeThread.thread).dispId + "</a> " + df.format(article.postDate) + " " + article.country.toHtml() + " " + " " + article.author + " " + articleContent + "<br><br>\n</" + LocalFoundContentView.this.SPAN + ">");
            }
        });
    }
}

