/*
 * Decompiled with CFR 0.152.
 */
package com.aibonware.viewnaver.content;

import com.aibonware.viewnaver.ViewNaver;
import com.aibonware.viewnaver.content.TabContainer;
import com.aibonware.viewnaver.content.TabContainerListener;
import com.aibonware.viewnaver.content.TabContent;
import com.aibonware.viewnaver.content.TabContentCategory;
import com.aibonware.viewnaver.content.TabContentView;
import com.aibonware.viewnaver.content.TabContentViewFactory;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import javax.swing.JTabbedPane;

public class TabContainerView
extends JTabbedPane {
    private HashMap<Class, TabContentViewFactory> factories = new HashMap();
    private HashMap<TabContentCategory, TabContentView> views = new HashMap();
    private TabContainer container = null;
    private TabContainerListener containerListener = new TabContainerListener(){

        @Override
        public void added(TabContent content, int pos) {
            TabContentCategory category = content.getCategory();
            TabContentView view = (TabContentView)TabContainerView.this.views.get(category);
            if (view == null) {
                TabContentViewFactory factory = (TabContentViewFactory)TabContainerView.this.factories.get(content.getClass());
                view = factory.create(category);
                TabContainerView.this.insertTab(content.getContentTitle(), null, view, null, pos);
            } else {
                TabContainerView.this.setTitleAt(TabContainerView.this.indexOfComponent(view), content.getContentTitle());
            }
            view.setClientContent(content);
            TabContainerView.this.views.put(category, view);
        }

        @Override
        public void removed(TabContent content) {
            TabContentCategory category = content.getCategory();
            TabContentView view = (TabContentView)TabContainerView.this.views.get(category);
            if (view != null) {
                TabContainerView.this.views.remove(category);
                TabContainerView.this.remove(view);
                view.disposeTab();
            }
        }

        @Override
        public void replaced(TabContent oldContent, TabContent newContent) {
            TabContentCategory oldCategory = oldContent.getCategory();
            TabContentCategory newCategory = newContent.getCategory();
            TabContentView oldView = (TabContentView)TabContainerView.this.views.get(oldCategory);
            if (oldView == null) {
                TabContentViewFactory factory = (TabContentViewFactory)TabContainerView.this.factories.get(newContent.getClass());
                TabContentView newView = factory.create(newContent.getCategory());
                newView.setClientContent(newContent);
                TabContainerView.this.views.put(newCategory, newView);
            } else {
                oldView.setClientContent(newContent);
            }
        }
    };

    @Override
    protected void processMouseEvent(MouseEvent event) {
        try {
            super.processMouseEvent(event);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
    }

    @Override
    protected void processMouseMotionEvent(MouseEvent event) {
        try {
            super.processMouseMotionEvent(event);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
    }

    public void addFactory(Class clazz, TabContentViewFactory factory) {
        this.factories.put(clazz, factory);
    }

    public void setClientContainer(TabContainer newContainer) {
        if (this.container != null) {
            this.container.removeListener(this.containerListener);
        }
        this.removeAll();
        this.container = newContainer;
        if (this.container != null) {
            this.container.addListener(this.containerListener);
        }
        int i = 0;
        while (i < this.container.getContentCount()) {
            TabContent content = this.container.getContent(i);
            TabContentViewFactory factory = this.factories.get(content.getClass());
            TabContentView view = factory.create(content.getCategory());
            view.setClientContent(content);
            this.addTab(content.getContentTitle(), view);
            ++i;
        }
    }

    public void activate(TabContentCategory category) {
        TabContentView view = this.views.get(category);
        if (view != null) {
            this.setSelectedComponent(view);
        }
    }

    public void update(TabContentCategory category) {
        TabContentView view = this.views.get(category);
        if (view == null) {
            view = this.registerEmptyView(category);
            category.createInitialContent(this.container, this, view);
        } else {
            TabContent content = this.container.getContentByCategory(category);
            if (content != null) {
                content.replaceUpdatedContent(this.container, this, view);
            } else {
                ViewNaver.println("\u51e6\u7406\u4e2d\u306e\u30bf\u30d6\u304c\u5b58\u5728\u3057\u307e\u3059\u3002");
            }
        }
    }

    public TabContentView registerEmptyView(TabContentCategory category) {
        if (this.views.get(category) != null) {
            return null;
        }
        TabContentViewFactory factory = this.factories.get(category.getContentClass());
        TabContentView view = factory.create(category);
        view.isEmptyView = true;
        this.views.put(category, view);
        int pos = this.container.getInsertPosition(category.getContentClass());
        this.insertTab(category.getCategoryName(), null, view, null, pos);
        this.setSelectedComponent(view);
        return view;
    }

    public void revertEmptyView(TabContentCategory category) {
        TabContentView view = this.views.get(category);
        if (view != null && view.isEmptyView) {
            this.views.remove(category);
            this.remove(view);
            view.disposeTab();
        }
    }

    public void update(TabContent newContent) {
        TabContentCategory newCategory = newContent.getCategory();
        TabContent oldContent = this.container.getContentByCategory(newCategory);
        if (oldContent == null) {
            this.container.addContent(newContent);
            this.activate(newCategory);
        } else {
            this.container.replace(oldContent, newContent);
            this.activate(newCategory);
        }
    }

    public boolean isActiveContentCategory(TabContentCategory category) {
        TabContentView view = this.views.get(category);
        return this.getSelectedComponent() == view;
    }
}

