/*
 * Decompiled with CFR 0.152.
 */
package com.aibonware.viewnaver.browser.basic;

import com.aibonware.viewnaver.browser.Browser;
import com.aibonware.viewnaver.browser.BrowserFactory;
import com.aibonware.viewnaver.browser.EditableBrowser;
import com.aibonware.viewnaver.browser.basic.BasicBrowserImpl;
import java.awt.Container;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;

public class BasicBrowserFactory
extends BrowserFactory {
    public BasicBrowserFactory() {
        super("div", "<hr>");
    }

    @Override
    public void initialize() {
    }

    @Override
    public void terminate() {
    }

    @Override
    public Browser createBrowser(String initialHtml) {
        BasicBrowserImpl browser = new BasicBrowserImpl(false);
        browser.beginDocWriting();
        browser.writeDocHtml(initialHtml);
        browser.endDocWriting();
        return browser;
    }

    @Override
    public String getEngineName() {
        return "Java JEditorPane";
    }

    @Override
    public EditableBrowser createEditableBrowser() {
        return new EditableBrowser(){
            private JTextArea htmlSourceView;
            private JTabbedPane tab = new JTabbedPane();
            {
                this.htmlSourceView = new JTextArea();
                this.htmlSourceView.setLineWrap(true);
                this.tab = new JTabbedPane();
                this.tab.add("HTML", new JScrollPane(this.htmlSourceView));
            }

            @Override
            public String getHtmlContent() {
                return this.htmlSourceView.getText();
            }

            @Override
            public void setHtmlContents(String html) {
                this.htmlSourceView.setText(html);
            }

            @Override
            public Container getContainer() {
                return this.tab;
            }
        };
    }
}

