/*
 * Decompiled with CFR 0.152.
 */
package com.aibonware.viewnaver.storage;

import com.aibonware.viewnaver.Util;
import com.aibonware.viewnaver.ViewNaver;
import com.aibonware.viewnaver.model.CompositeThread;
import com.aibonware.viewnaver.model.NThread;
import com.aibonware.viewnaver.storage.StorageException;
import com.aibonware.viewnaver.storage.ThreadStorageWalker;
import com.aibonware.viewnaver.xml.BaseXMLReader;
import com.aibonware.viewnaver.xml.CompositeThreadReader;
import com.aibonware.viewnaver.xml.CompositeThreadSerializer;
import com.aibonware.viewnaver.xml.XMLReaderException;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.TreeMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class ThreadStorage {
    private HashMap<String, TreeMap<Integer, CompositeThread>> cache = new HashMap();
    private Comparator<File> reverseNidComparator = new Comparator<File>(){

        @Override
        public int compare(File src, File dest) {
            return -(ThreadStorage.this.getNid(src.getName()) - ThreadStorage.this.getNid(dest.getName()));
        }
    };

    public synchronized void storeThread(CompositeThread thread) {
        this.getThreadsInBoard(thread.boardName).put(((NThread)thread.thread).nid, thread);
    }

    public synchronized boolean existsThread(String boardName, int nid) {
        if (this.getThreadsInBoard(boardName).get(nid) != null) {
            return true;
        }
        return new File("logs" + File.separator + boardName + File.separator + boardName + "_" + nid + ".xml").exists();
    }

    private int getNid(String fileName) {
        int end;
        int start = fileName.indexOf("_");
        if (start >= (end = fileName.indexOf("."))) {
            return -1;
        }
        try {
            return Integer.parseInt(fileName.substring(start + 1, end));
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    public void walkFiles(ThreadStorageWalker walker) {
        File[] boardDirs;
        File[] fileArray = boardDirs = new File("logs\\").listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isDirectory();
            }
        });
        int n = boardDirs.length;
        int n2 = 0;
        while (n2 < n) {
            File dir = fileArray[n2];
            final String dirName = dir.getName();
            File[] files = dir.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File parent, String fileName) {
                    return fileName.startsWith(dirName) && fileName.endsWith(".xml");
                }
            });
            Arrays.sort(files, this.reverseNidComparator);
            File[] fileArray2 = files;
            int n3 = files.length;
            int n4 = 0;
            while (n4 < n3) {
                File file = fileArray2[n4];
                if (!walker.walk(file)) {
                    walker.canceled();
                    return;
                }
                ++n4;
            }
            ++n2;
        }
        walker.finished();
    }

    public synchronized CompositeThread readThread(String boardName, int nid) throws StorageException {
        CompositeThread thread = this.getThreadsInBoard(boardName).get(nid);
        if (thread != null) {
            return thread;
        }
        try {
            String fileName = "logs" + File.separator + boardName + File.separator + boardName + "_" + nid + ".xml";
            DocumentBuilderFactory dbfactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = dbfactory.newDocumentBuilder();
            Document doc = builder.parse(new BufferedInputStream(new FileInputStream(fileName)));
            Element root = doc.getDocumentElement();
            Element threadElem = BaseXMLReader.getAttrElem(root, "CompositeThread");
            CompositeThreadReader reader = new CompositeThreadReader();
            return reader.parse(threadElem);
        }
        catch (IOException e) {
            throw new StorageException(e);
        }
        catch (XMLReaderException e) {
            throw new StorageException(e);
        }
        catch (SAXException e) {
            throw new StorageException(e);
        }
        catch (ParserConfigurationException e) {
            throw new StorageException(e);
        }
    }

    private void writeThread(CompositeThread composite) throws StorageException {
        try {
            String fileName = "logs" + File.separator + composite.boardName + File.separator + composite.boardName + "_" + ((NThread)composite.thread).nid + ".xml";
            DocumentBuilderFactory dbfactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = dbfactory.newDocumentBuilder();
            Document doc = builder.newDocument();
            Element root = doc.createElement("NDX");
            doc.appendChild(root);
            CompositeThreadSerializer serializer = new CompositeThreadSerializer(doc);
            root.appendChild(serializer.serialize(composite));
            TransformerFactory factory = TransformerFactory.newInstance();
            Transformer transformer = factory.newTransformer();
            transformer.setOutputProperty("method", "xml");
            transformer.setOutputProperty("indent", "yes");
            transformer.transform(new DOMSource(doc), new StreamResult(fileName));
        }
        catch (TransformerException e) {
            throw new StorageException(e);
        }
        catch (ParserConfigurationException e) {
            throw new StorageException(e);
        }
    }

    public synchronized int flash() throws StorageException {
        int falshedThreadNum = 0;
        for (String boardName : this.cache.keySet()) {
            String dirName = "logs" + File.separator + boardName + File.separator;
            if (!Util.makeSureDir(dirName)) {
                throw new StorageException("\u30c7\u30a3\u30ec\u30af\u30c8\u30ea'" + dirName + "'\u306e\u4f5c\u6210\u306b\u5931\u6557\u3057\u307e\u3057\u305f");
            }
            for (CompositeThread thread : this.cache.get(boardName).values()) {
                this.writeThread(thread);
                ++falshedThreadNum;
            }
            final String finalBoardName = boardName;
            File[] files = new File(dirName).listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File parent, String fileName) {
                    return fileName.startsWith(finalBoardName) && fileName.endsWith(".xml");
                }
            });
            if (!((double)files.length > (double)ViewNaver.instance.config.getCapacityConfig().maxStorageThreads * 1.2)) continue;
            Arrays.sort(files, this.reverseNidComparator);
            int i = ViewNaver.instance.config.getCapacityConfig().maxStorageThreads;
            while (i < files.length) {
                File file = files[i];
                if (!ViewNaver.instance.favoriteThreads.exists(boardName, this.getNid(file.getName()))) {
                    file.delete();
                }
                ++i;
            }
        }
        this.cache.clear();
        return falshedThreadNum;
    }

    private TreeMap<Integer, CompositeThread> getThreadsInBoard(String boardName) {
        TreeMap<Integer, CompositeThread> threads = this.cache.get(boardName);
        if (threads == null) {
            threads = new TreeMap();
            this.cache.put(boardName, threads);
        }
        return threads;
    }
}

