/*
 * Decompiled with CFR 0.152.
 */
package com.aibonware.viewnaver.model;

import com.aibonware.viewnaver.ViewNaver;
import com.aibonware.viewnaver.model.FavoriteThread;
import com.aibonware.viewnaver.xml.BaseXMLReader;
import com.aibonware.viewnaver.xml.FavoriteThreadReader;
import com.aibonware.viewnaver.xml.FavoriteThreadSerializer;
import com.aibonware.viewnaver.xml.XMLReaderException;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class FavoriteThreads {
    private Vector<FavoriteThread> threads = new Vector();

    public void addThread(FavoriteThread thread) {
        this.threads.addElement(thread);
    }

    public void removeThread(FavoriteThread thread) {
        this.threads.removeElement(thread);
    }

    public void removeThread(int index) {
        this.threads.removeElementAt(index);
    }

    public int getThreadCount() {
        return this.threads.size();
    }

    public boolean exists(String boardName, int nid) {
        int i = 0;
        while (i < this.threads.size()) {
            FavoriteThread thread = this.threads.elementAt(i);
            if (thread.boardName.equals(boardName) && thread.nid == nid) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public FavoriteThread getThread(int index) {
        return this.threads.elementAt(index);
    }

    public void load(String fileName) {
        this.threads.clear();
        try {
            FileInputStream in;
            try {
                in = new FileInputStream(fileName);
            }
            catch (FileNotFoundException e) {
                return;
            }
            DocumentBuilderFactory dbfactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = dbfactory.newDocumentBuilder();
            Document doc = builder.parse(new BufferedInputStream(in));
            Element root = doc.getDocumentElement();
            Element threadsElem = BaseXMLReader.getAttrElem(root, "FavoriteThreads");
            FavoriteThreadReader reader = new FavoriteThreadReader();
            Vector<Element> children = BaseXMLReader.getAttrElems(threadsElem, "FavoriteThread");
            int i = 0;
            while (i < children.size()) {
                this.threads.addElement(reader.parse(children.elementAt(i)));
                ++i;
            }
            in.close();
        }
        catch (IOException e) {
            ViewNaver.err(e);
        }
        catch (XMLReaderException e) {
            ViewNaver.err(e);
        }
        catch (SAXException e) {
            ViewNaver.err(e);
        }
        catch (ParserConfigurationException e) {
            ViewNaver.err(e);
        }
    }

    public void save(String fileName) {
        try {
            DocumentBuilderFactory dbfactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = dbfactory.newDocumentBuilder();
            Document doc = builder.newDocument();
            Element root = doc.createElement("NDX");
            doc.appendChild(root);
            FavoriteThreadSerializer serializer = new FavoriteThreadSerializer(doc);
            Element threadsElem = doc.createElement("FavoriteThreads");
            root.appendChild(threadsElem);
            int i = 0;
            while (i < this.threads.size()) {
                threadsElem.appendChild(serializer.serialize(this.threads.elementAt(i)));
                ++i;
            }
            TransformerFactory factory = TransformerFactory.newInstance();
            Transformer transformer = factory.newTransformer();
            transformer.setOutputProperty("method", "xml");
            transformer.setOutputProperty("indent", "yes");
            transformer.transform(new DOMSource(root.getOwnerDocument()), new StreamResult(fileName));
        }
        catch (ParserConfigurationException e) {
            ViewNaver.err(e);
        }
        catch (TransformerConfigurationException e) {
            ViewNaver.err(e);
        }
        catch (TransformerException e) {
            ViewNaver.err(e);
        }
    }
}

