/*
 * Decompiled with CFR 0.152.
 */
package com.aibonware.viewnaver.content.thread;

import com.aibonware.viewnaver.ViewNaver;
import com.aibonware.viewnaver.config.ThreadWindowConfig;
import com.aibonware.viewnaver.content.TabContainer;
import com.aibonware.viewnaver.content.TabContainerView;
import com.aibonware.viewnaver.content.TabContentCategory;
import com.aibonware.viewnaver.content.TabContentProxy;
import com.aibonware.viewnaver.content.TabContentView;
import com.aibonware.viewnaver.content.thread.ThreadView;
import com.aibonware.viewnaver.model.CompositeThread;
import com.aibonware.viewnaver.model.NThread;
import com.aibonware.viewnaver.task.GUITask;
import com.aibonware.viewnaver.task.TaskFlow;
import com.aibonware.viewnaver.task.WorkerTask;

public class ThreadContent
extends TabContentProxy<CompositeThread> {
    private final String dispName;
    private final String boardName;

    private static String titleToDispName(String poster, String title) {
        ThreadWindowConfig config = (ThreadWindowConfig)ViewNaver.instance.config.getAncestor("ThreadWindow");
        if (title.length() > config.maxThreadTabTitleLen) {
            title = String.valueOf(title.substring(0, config.maxThreadTabTitleLen)) + "..";
        }
        return String.valueOf(poster) + ":" + title;
    }

    public ThreadContent(CompositeThread target, String boardName) {
        super(target);
        this.boardName = boardName;
        this.dispName = ThreadContent.titleToDispName(((NThread)target.thread).poster, ((NThread)target.thread).title);
    }

    public static ThreadClientContentCategory getCategory(String boardName, int nid, String poster, String title) {
        return new ThreadClientContentCategory(boardName, nid, ThreadContent.titleToDispName(poster, title));
    }

    public static ThreadClientContentCategory getCategory(String boardName, int nid) {
        return new ThreadClientContentCategory(boardName, nid, String.valueOf("thread:" + nid));
    }

    @Override
    public String getContentTitle() {
        return this.dispName;
    }

    @Override
    public TabContentCategory getCategory() {
        return new ThreadClientContentCategory(this.boardName, ((NThread)((CompositeThread)((Object)this.target)).thread).nid, this.dispName);
    }

    @Override
    public void replaceUpdatedContent(final TabContainer container, final TabContainerView containerView, TabContentView contentView) {
        TaskFlow taskFlow = ViewNaver.instance.taskFlowList.getThreadFlow(this.boardName, ((NThread)((CompositeThread)((Object)this.target)).thread).nid);
        taskFlow.addStatusReceiver(((ThreadView)contentView).createTaskStatusReceiver(taskFlow));
        taskFlow.execute(new WorkerTask(ViewNaver.instance.appTools){

            @Override
            public void exec() {
                final CompositeThread thread = ViewNaver.instance.cache.getCompositeThread(ThreadContent.this.boardName, ((NThread)((CompositeThread)((Object)ThreadContent.this.target)).thread).nid, true);
                this.taskFlow.execute(new GUITask(ViewNaver.instance.appTools){

                    @Override
                    public void exec() {
                        ThreadContent newContent = new ThreadContent(thread, ThreadContent.this.boardName);
                        container.replace(ThreadContent.this, newContent);
                        containerView.activate(newContent.getCategory());
                    }
                });
            }
        });
    }

    private static class ThreadClientContentCategory
    implements TabContentCategory {
        private final String boardName;
        private final int nid;
        private final String dispName;

        public ThreadClientContentCategory(String boardName, int nid, String dispName) {
            this.boardName = boardName;
            this.nid = nid;
            this.dispName = dispName;
        }

        public boolean equals(Object o) {
            if (!(o instanceof ThreadClientContentCategory)) {
                return false;
            }
            ThreadClientContentCategory dest = (ThreadClientContentCategory)o;
            if (!this.boardName.equals(dest.boardName)) {
                return false;
            }
            return this.nid == dest.nid;
        }

        @Override
        public void createInitialContent(final TabContainer container, final TabContainerView containerView, TabContentView initialView) {
            TaskFlow taskFlow = ViewNaver.instance.taskFlowList.getThreadFlow(this.boardName, this.nid);
            taskFlow.addStatusReceiver(((ThreadView)initialView).createTaskStatusReceiver(taskFlow));
            taskFlow.execute(new WorkerTask(ViewNaver.instance.appTools){

                @Override
                public void exec() {
                    final CompositeThread newThread = ViewNaver.instance.cache.getCompositeThread(ThreadClientContentCategory.this.boardName, ThreadClientContentCategory.this.nid, false);
                    if (newThread != null) {
                        ViewNaver.instance.cache.putCompositeThread(newThread);
                        ViewNaver.instance.threadStorage.storeThread(newThread);
                    }
                    this.taskFlow.execute(new GUITask(ViewNaver.instance.appTools){

                        @Override
                        public void exec() {
                            if (newThread == null) {
                                containerView.revertEmptyView(ThreadClientContentCategory.this);
                                return;
                            }
                            ThreadContent content = new ThreadContent(newThread, ThreadClientContentCategory.this.boardName);
                            container.addContent(content);
                            containerView.activate(content.getCategory());
                        }
                    });
                }
            });
        }

        @Override
        public String getCategoryName() {
            return this.dispName;
        }

        public int hashCode() {
            return this.boardName.hashCode() + this.nid;
        }

        public Class getContentClass() {
            return ThreadContent.class;
        }
    }
}

