/*
 * Decompiled with CFR 0.152.
 */
package com.aibonware.viewnaver.content.message;

import com.aibonware.nvrlib.model.Message;
import com.aibonware.nvrlib.model.MessageTitleList;
import com.aibonware.nvrlib.net.NaverSession;
import com.aibonware.nvrlib.parser.MessageListParser;
import com.aibonware.viewnaver.ViewNaver;
import com.aibonware.viewnaver.content.TabContainer;
import com.aibonware.viewnaver.content.TabContainerView;
import com.aibonware.viewnaver.content.TabContent;
import com.aibonware.viewnaver.content.TabContentCategory;
import com.aibonware.viewnaver.content.TabContentView;
import com.aibonware.viewnaver.content.message.MessageContentView;
import com.aibonware.viewnaver.task.GUITask;
import com.aibonware.viewnaver.task.TaskFlow;
import com.aibonware.viewnaver.task.WorkerTask;
import java.util.TreeMap;

public abstract class MessageContent
implements TabContent {
    public final MessageTitleList messageTitles;
    private final String listUrl;
    private final String title;
    public final String userName;

    public MessageContent(String userName, MessageTitleList messages, String listUrl, String title, MessageLogReader messageLogReader) {
        this.userName = userName;
        this.messageTitles = messages;
        this.listUrl = listUrl;
        this.title = title;
    }

    @Override
    public String getContentTitle() {
        return this.title;
    }

    @Override
    public abstract TabContentCategory getCategory();

    @Override
    public void replaceUpdatedContent(final TabContainer container, final TabContainerView containerView, TabContentView contentView) {
        TaskFlow taskFlow = ViewNaver.instance.taskFlowList.getMessageListFlow();
        ((MessageContentView)contentView).beginUpdateTask(taskFlow);
        taskFlow.execute(new WorkerTask(ViewNaver.instance.appTools){
            MessageTitleList messages;
            {
                super($anonymous0);
                this.messages = null;
            }

            @Override
            public void exec() {
                try {
                    ViewNaver.println(String.valueOf(MessageContent.this.title) + "\u8aad\u307f\u8fbc\u307f\u4e2d...");
                    MessageListParser parser = new MessageListParser(MessageContent.this.listUrl);
                    this.messages = parser.parse((NaverSession)ViewNaver.instance.multiSession);
                    ViewNaver.println(String.valueOf(MessageContent.this.title) + "\u8aad\u307f\u8fbc\u307f\u7d42\u4e86\u3002");
                }
                catch (Exception e) {
                    ViewNaver.err(e);
                }
                this.taskFlow.execute(new GUITask(ViewNaver.instance.appTools){

                    @Override
                    public void exec() {
                        MessageContent newContent = ((MessageContentCategory)MessageContent.this.getCategory()).createMessageContent(ViewNaver.instance.multiSession.getUserName(), messages);
                        container.replace(MessageContent.this, newContent);
                        containerView.activate(newContent.getCategory());
                    }
                });
            }
        });
    }

    protected static abstract class MessageContentCategory
    implements TabContentCategory {
        private final String listUrl;
        private final String title;
        private final MessageLogReader messageLogReader;

        public MessageContentCategory(String listUrl, String title, MessageLogReader messageLogReader) {
            this.listUrl = listUrl;
            this.title = title;
            this.messageLogReader = messageLogReader;
        }

        public boolean equals(Object o) {
            if (!(o instanceof MessageContentCategory)) {
                return false;
            }
            MessageContentCategory dest = (MessageContentCategory)o;
            return this.listUrl.equals(dest.listUrl);
        }

        public abstract MessageContent createMessageContent(String var1, MessageTitleList var2);

        @Override
        public void createInitialContent(final TabContainer container, final TabContainerView containerView, TabContentView initialView) {
            TaskFlow taskFlow = ViewNaver.instance.taskFlowList.getMessageListFlow();
            ((MessageContentView)initialView).beginUpdateTask(taskFlow);
            taskFlow.execute(new WorkerTask(ViewNaver.instance.appTools){
                MessageTitleList messageTitles;
                {
                    super($anonymous0);
                    this.messageTitles = null;
                }

                @Override
                public void exec() {
                    ViewNaver.println(String.valueOf(MessageContentCategory.this.title) + "\u30ed\u30b0\u306e\u8aad\u307f\u8fbc\u307f\u4e2d...");
                    TreeMap<Integer, Message> messageLog = MessageContentCategory.this.messageLogReader.getMessageLog();
                    ViewNaver.println(String.valueOf(MessageContentCategory.this.title) + "\u30ed\u30b0\u306e\u8aad\u307f\u8fbc\u307f\u5b8c\u4e86\u3002");
                    if (messageLog != null) {
                        this.messageTitles = new MessageTitleList(-1, -1, -1);
                        for (Message message : messageLog.values()) {
                            this.messageTitles.addMessageTitle(message.getTempMessageTitle());
                        }
                    }
                    if (ViewNaver.instance.multiSession.nowLogin()) {
                        try {
                            ViewNaver.println(String.valueOf(MessageContentCategory.this.title) + "\u3092\u30b5\u30fc\u30d0\u304b\u3089\u53d6\u5f97\u4e2d...");
                            MessageListParser parser = new MessageListParser(MessageContentCategory.this.listUrl);
                            MessageTitleList remoteMessages = parser.parse((NaverSession)ViewNaver.instance.multiSession);
                            if (this.messageTitles != null) {
                                this.messageTitles.merge(remoteMessages);
                            } else {
                                this.messageTitles = remoteMessages;
                            }
                            ViewNaver.println(String.valueOf(MessageContentCategory.this.title) + "\u3092\u30b5\u30fc\u30d0\u304b\u3089\u53d6\u5f97\u5b8c\u4e86\u3002");
                        }
                        catch (Exception e) {
                            ViewNaver.err(e);
                        }
                    }
                    this.messageTitles.sort();
                    this.taskFlow.execute(new GUITask(ViewNaver.instance.appTools){

                        @Override
                        public void exec() {
                            if (messageTitles == null) {
                                containerView.revertEmptyView(MessageContentCategory.this);
                                return;
                            }
                            MessageContent content = MessageContentCategory.this.createMessageContent(ViewNaver.instance.multiSession.getUserName(), messageTitles);
                            container.addContent(content);
                            containerView.activate(content.getCategory());
                        }
                    });
                }
            });
        }

        @Override
        public String getCategoryName() {
            return this.title;
        }

        public int hashCode() {
            return MessageContentCategory.class.hashCode() + this.listUrl.hashCode();
        }

        public abstract Class getContentClass();
    }

    public static interface MessageLogReader {
        public TreeMap<Integer, Message> getMessageLog();
    }
}

