/*
 * Decompiled with CFR 0.152.
 */
package com.aibonware.viewnaver.content.board;

import com.aibonware.nvrlib.BaseInstantiator;
import com.aibonware.nvrlib.net.NaverSession;
import com.aibonware.viewnaver.ViewNaver;
import com.aibonware.viewnaver.config.ThreadListConfig;
import com.aibonware.viewnaver.content.TabContentCategory;
import com.aibonware.viewnaver.content.board.BaseBoardView;
import com.aibonware.viewnaver.content.board.FoundThreadsContent;
import com.aibonware.viewnaver.model.BoardTitle;
import com.aibonware.viewnaver.model.FoundThreads;
import com.aibonware.viewnaver.task.GUITask;
import com.aibonware.viewnaver.task.TaskFlow;
import com.aibonware.viewnaver.task.TaskStatusReceiver;
import com.aibonware.viewnaver.task.WorkerTask;
import com.aibonware.viewnaver.window.SearchRemoteThreadDialog;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JButton;

public class FoundThreadsView
extends BaseBoardView<FoundThreads> {
    JButton searchThreadButton = new JButton();
    AbstractAction searchThreadAction = new AbstractAction("\u691c\u7d22"){

        @Override
        public void actionPerformed(ActionEvent e) {
            FoundThreadsContent.FoundThreadsCategory category = (FoundThreadsContent.FoundThreadsCategory)FoundThreadsView.this.category;
            SearchRemoteThreadDialog dialog = new SearchRemoteThreadDialog(ViewNaver.instance.mainWindow, new BoardTitle(category.boardName, category.dispName), category.keyword, category.searchType);
            dialog.setVisible(true);
        }
    };

    public FoundThreadsView(TabContentCategory category) {
        super(category);
        this.searchThreadButton.setAction(this.searchThreadAction);
        this.toolbar.add(this.searchThreadButton);
    }

    public TaskStatusReceiver createTaskStatusReceiver(final TaskFlow taskFlow) {
        return new TaskStatusReceiver(){

            @Override
            public void statusChanged(int status) {
                if (status == 0) {
                    FoundThreadsView.this.searchThreadButton.setAction(new AbstractAction("\u4e2d\u6b62"){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            taskFlow.cancel();
                        }
                    });
                    FoundThreadsView.this.prevButton.setEnabled(false);
                    FoundThreadsView.this.nextButton.setEnabled(false);
                    FoundThreadsView.this.closeButton.setEnabled(false);
                } else if (status == 1) {
                    FoundThreadsView.this.searchThreadButton.setAction(FoundThreadsView.this.searchThreadAction);
                    FoundThreadsView.this.prevButton.setEnabled(true);
                    FoundThreadsView.this.nextButton.setEnabled(true);
                    FoundThreadsView.this.closeButton.setEnabled(true);
                }
            }
        };
    }

    @Override
    protected void loadNewPage(final FoundThreads oldboard, int pageNo, boolean forceUpdate) {
        TaskFlow taskFlow = ViewNaver.instance.taskFlowList.getSearchRemoteThreadFlow(oldboard.boardName, oldboard.searchType, oldboard.keyword);
        taskFlow.addStatusReceiver(this.createTaskStatusReceiver(taskFlow));
        taskFlow.execute(new WorkerTask(ViewNaver.instance.appTools){

            @Override
            public void exec() {
                int newPageNo = FoundThreadsView.this.getSpecifiedPageNo();
                if (newPageNo < 1) {
                    ViewNaver.println("\u4e0d\u6b63\u306a\u30da\u30fc\u30b8\u756a\u53f7\u3067\u3059\u3002");
                    return;
                }
                final FoundThreads newThreads = (FoundThreads)oldboard.searchType.execSearch((BaseInstantiator)ViewNaver.instance.modelProvider, ViewNaver.instance.appTools, (NaverSession)ViewNaver.instance.multiSession, oldboard.boardName, oldboard.dispName, oldboard.boardType, oldboard.keyword, newPageNo);
                if (newThreads == null) {
                    return;
                }
                this.taskFlow.execute(new GUITask(ViewNaver.instance.appTools){

                    @Override
                    public void exec() {
                        ViewNaver.instance.mainWindow.containerView.update(new FoundThreadsContent(newThreads));
                    }
                });
            }
        });
    }

    @Override
    protected ThreadListConfig getConfig() {
        return ViewNaver.instance.config.getSearchConfig();
    }
}

