/*
 * Decompiled with CFR 0.152.
 */
package com.aibonware.viewnaver.content.board;

import com.aibonware.viewnaver.ViewNaver;
import com.aibonware.viewnaver.content.TabContainer;
import com.aibonware.viewnaver.content.TabContainerView;
import com.aibonware.viewnaver.content.TabContentCategory;
import com.aibonware.viewnaver.content.TabContentView;
import com.aibonware.viewnaver.content.board.BaseBoardContent;
import com.aibonware.viewnaver.content.board.BoardView;
import com.aibonware.viewnaver.model.Board;
import com.aibonware.viewnaver.model.BoardTitle;
import com.aibonware.viewnaver.task.GUITask;
import com.aibonware.viewnaver.task.TaskFlow;
import com.aibonware.viewnaver.task.WorkerTask;

public class BoardContent
extends BaseBoardContent<Board> {
    public BoardContent(Board board) {
        super(board);
    }

    @Override
    public String getContentTitle() {
        return ((Board)((Object)this.target)).dispName;
    }

    @Override
    public TabContentCategory getCategory() {
        return BoardContent.getCategory(((Board)((Object)this.target)).boardName);
    }

    public static TabContentCategory getCategory(String boardName) {
        BoardTitle board = (BoardTitle)ViewNaver.instance.boardTitles.getBoardTitle(boardName);
        if (board == null) {
            return new BoardClientContentCategory(boardName, boardName);
        }
        return new BoardClientContentCategory(boardName, board.dispName);
    }

    @Override
    public void replaceUpdatedContent(final TabContainer container, final TabContainerView containerView, TabContentView contentView) {
        TaskFlow taskFlow = ViewNaver.instance.taskFlowList.getBoardFlow(((Board)((Object)this.target)).boardName, ((Board)((Object)this.target)).pageNo);
        taskFlow.addStatusReceiver(((BoardView)contentView).createTaskStatusReceiver(taskFlow));
        taskFlow.execute(new WorkerTask(ViewNaver.instance.appTools){

            @Override
            public void exec() {
                final Board newBoard = ViewNaver.instance.cache.getBoard(((Board)((Object)BoardContent.this.target)).boardName, ((Board)((Object)BoardContent.this.target)).pageNo, true);
                this.taskFlow.execute(new GUITask(ViewNaver.instance.appTools){

                    @Override
                    public void exec() {
                        if (newBoard != null) {
                            BoardContent newContent = new BoardContent(newBoard);
                            container.replace(BoardContent.this, newContent);
                            containerView.activate(newContent.getCategory());
                        }
                    }
                });
            }
        });
    }

    static class BoardClientContentCategory
    implements TabContentCategory {
        public final String boardName;
        public final String dispName;

        public BoardClientContentCategory(String boardName, String dispName) {
            this.boardName = boardName;
            this.dispName = dispName;
        }

        public boolean equals(Object o) {
            if (!(o instanceof BoardClientContentCategory)) {
                return false;
            }
            BoardClientContentCategory dest = (BoardClientContentCategory)o;
            return this.boardName.equals(dest.boardName);
        }

        @Override
        public void createInitialContent(final TabContainer container, final TabContainerView containerView, TabContentView initialView) {
            TaskFlow taskFlow = ViewNaver.instance.taskFlowList.getBoardFlow(this.boardName, 1);
            taskFlow.addStatusReceiver(((BoardView)initialView).createTaskStatusReceiver(taskFlow));
            taskFlow.execute(new WorkerTask(ViewNaver.instance.appTools){

                @Override
                public void exec() {
                    final Board board = ViewNaver.instance.cache.getBoard(BoardClientContentCategory.this.boardName, 1, true);
                    this.taskFlow.execute(new GUITask(ViewNaver.instance.appTools){

                        @Override
                        public void exec() {
                            if (board == null) {
                                containerView.revertEmptyView(BoardClientContentCategory.this);
                                return;
                            }
                            BoardContent content = new BoardContent(board);
                            container.addContent(content);
                            containerView.activate(content.getCategory());
                        }
                    });
                }
            });
        }

        @Override
        public String getCategoryName() {
            return this.dispName;
        }

        public int hashCode() {
            return this.boardName.hashCode();
        }

        public Class getContentClass() {
            return BoardContent.class;
        }
    }
}

