/*
 * Decompiled with CFR 0.152.
 */
package com.aibonware.viewnaver.browser.win32;

import com.aibonware.viewnaver.browser.EditableBrowser;
import com.aibonware.viewnaver.browser.win32.RichEditDecorator;
import com.aibonware.viewnaver.browser.win32.Win32BrowserImpl;
import com.aibonware.viewnaver.browser.win32.Win32BrowserThread;
import java.awt.Container;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class Win32EditableBrowser
extends JTabbedPane
implements EditableBrowser {
    private JTextArea htmlSourceView = new JTextArea();
    private RichEditDecorator richEditor = null;

    public Win32EditableBrowser(Win32BrowserThread browserThread) {
        this.htmlSourceView.setLineWrap(true);
        Win32BrowserImpl browser = new Win32BrowserImpl(browserThread, null);
        this.richEditor = new RichEditDecorator(browser, this);
        JPanel browserPanel = this.richEditor.getJPanel();
        this.add("\u7de8\u96c6", browserPanel);
        this.add("HTML", new JScrollPane(this.htmlSourceView));
        this.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (Win32EditableBrowser.this.richEditor != null) {
                    if (Win32EditableBrowser.this.getSelectedIndex() == 1) {
                        Win32EditableBrowser.this.htmlSourceView.setText(Win32EditableBrowser.this.richEditor.getHtml());
                    } else {
                        Win32EditableBrowser.this.richEditor.setHtml(Win32EditableBrowser.this.htmlSourceView.getText());
                    }
                }
            }
        });
        this.setVisible(true);
    }

    @Override
    public String getHtmlContent() {
        if (this.richEditor == null) {
            return this.htmlSourceView.getText();
        }
        if (this.getSelectedIndex() == 0) {
            return this.richEditor.getHtml();
        }
        return this.htmlSourceView.getText();
    }

    @Override
    public void setHtmlContents(String html) {
        this.htmlSourceView.setText(html);
        this.richEditor.setInitialHtml(html);
    }

    @Override
    public Container getContainer() {
        return this;
    }
}

