/*
 * Decompiled with CFR 0.152.
 */
package com.aibonware.viewnaver.browser.win32;

import com.aibonware.viewnaver.ViewNaver;
import com.aibonware.viewnaver.browser.win32.Win32BrowserFactory;
import com.aibonware.viewnaver.browser.win32.Win32BrowserImpl;
import java.awt.Canvas;
import java.util.Vector;
import java.util.concurrent.Semaphore;

public class Win32BrowserThread
extends Thread {
    private volatile boolean mustExit = false;
    private static final int MSG_EXEC_COMMAND = 32752;
    private static final int CMD_EXIT_LOOP = 0;
    private static Vector<Win32BrowserImpl> browsers = new Vector();
    private Vector<Task> tasks = new Vector();

    private static native boolean messageLoop();

    private static native void postMessage(int var0, int var1, int var2);

    private static native int createBrowser(Canvas var0, int[] var1) throws Exception;

    private static native void resizeBrowser(int var0, int var1, int var2) throws Exception;

    private static native void setBodyHtml(int var0, String var1) throws Exception;

    private static native void insertBodyHtml(int var0, String var1, String var2) throws Exception;

    private static native void replaceBodyHtml(int var0, String var1, String var2) throws Exception;

    private static native String getBodyHtml(int var0) throws Exception;

    private static native void setEditable(int var0, boolean var1) throws Exception;

    private static native void destroyBrowser(int var0) throws Exception;

    private static native void openDocHtml(int var0) throws Exception;

    private static native void writeDocHtml(int var0, String var1) throws Exception;

    private static native void clearDocHtml(int var0) throws Exception;

    private static native void closeDocHtml(int var0) throws Exception;

    private static native void toggleBold(int var0) throws Exception;

    private static native void setColor(int var0, String var1) throws Exception;

    private static native void insertHR(int var0) throws Exception;

    private static native void toggleItalic(int var0) throws Exception;

    private static native void toggleUnderLine(int var0) throws Exception;

    private static native void setFontName(int var0, String var1) throws Exception;

    private static native void setFontSize(int var0, String var1) throws Exception;

    private static native void scrollTop(int var0, String var1) throws Exception;

    private static native void refreshBrowser(int var0) throws Exception;

    private static native void resetBrowser(int var0) throws Exception;

    static void addBrowser(Win32BrowserImpl browser) {
        browsers.addElement(browser);
    }

    static void removeBrowser(Win32BrowserImpl browser) {
        browsers.removeElement(browser);
    }

    private static Win32BrowserImpl findBrowser(int hBrowser) {
        int i = 0;
        while (i < browsers.size()) {
            Win32BrowserImpl browser = browsers.elementAt(i);
            if (browser.hBrowser == hBrowser) {
                return browser;
            }
            ++i;
        }
        return null;
    }

    private static boolean beforeNavigate2(int hBrowser, String url) {
        Win32BrowserImpl browser = Win32BrowserThread.findBrowser(hBrowser);
        if (browser == null) {
            return true;
        }
        return browser.notifyBeforeNavigate(url);
    }

    private static void receiveLog(String log) {
        ViewNaver.println(log);
    }

    public Win32BrowserThread() {
        super("Win32BrowserThread");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addTasks(Task task) {
        Vector<Task> vector = this.tasks;
        synchronized (vector) {
            this.tasks.addElement(task);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (!this.mustExit) {
            Vector<Task> executingTasks = new Vector<Task>();
            Vector<Task> vector = this.tasks;
            synchronized (vector) {
                executingTasks.addAll(this.tasks);
                this.tasks.clear();
            }
            for (Task task : executingTasks) {
                try {
                    try {
                        task.result = task.run();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        ViewNaver.err(e);
                        task.lock.release();
                        continue;
                    }
                }
                catch (Throwable throwable) {
                    task.lock.release();
                    throw throwable;
                }
                task.lock.release();
            }
            Win32BrowserThread.messageLoop();
        }
    }

    public void exit() {
        this.mustExit = true;
        this.wake();
    }

    private void wake() {
        Win32BrowserThread.postMessage(32752, 0, 0);
    }

    private Object executeTask(Task task) {
        this.addTasks(task);
        this.wake();
        try {
            task.lock.acquire();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        Object result = task.result;
        return result;
    }

    public int createWin32Browser(final Canvas canvas) {
        return (Integer)this.executeTask(new Task(){

            @Override
            public Object run() throws Exception {
                return Win32BrowserThread.createBrowser(canvas, Win32BrowserFactory.browserConfig.actions.createRawDump());
            }
        });
    }

    public void resizeWin32Browser(final int hBrowser, final int width, final int height) {
        this.executeTask(new Task(){

            @Override
            public Object run() throws Exception {
                Win32BrowserThread.resizeBrowser(hBrowser, width, height);
                return null;
            }
        });
    }

    public void setWin32BodyHtml(final int hBrowser, final String html) {
        this.executeTask(new Task(){

            @Override
            public Object run() throws Exception {
                Win32BrowserThread.setBodyHtml(hBrowser, html);
                return null;
            }
        });
    }

    public void insertWin32BodyHtml(final int hBrowser, final String tagid, final String html) {
        this.executeTask(new Task(){

            @Override
            public Object run() throws Exception {
                Win32BrowserThread.insertBodyHtml(hBrowser, tagid, html);
                return null;
            }
        });
    }

    public void replaceWin32BodyHtml(final int hBrowser, final String tagid, final String html) {
        this.executeTask(new Task(){

            @Override
            public Object run() throws Exception {
                Win32BrowserThread.replaceBodyHtml(hBrowser, tagid, html);
                return null;
            }
        });
    }

    public String getWin32BodyHtml(final int hBrowser) {
        return (String)this.executeTask(new Task(){

            @Override
            public Object run() throws Exception {
                return Win32BrowserThread.getBodyHtml(hBrowser);
            }
        });
    }

    public void setWin32Editable(final int hBrowser, final boolean editable) {
        this.executeTask(new Task(){

            @Override
            public Object run() throws Exception {
                Win32BrowserThread.setEditable(hBrowser, editable);
                return null;
            }
        });
    }

    public void disposeWin32Browser(final int hBrowser) {
        this.executeTask(new Task(){

            @Override
            public Object run() throws Exception {
                Win32BrowserThread.destroyBrowser(hBrowser);
                return null;
            }
        });
    }

    public void toggleWin32Bold(final int hBrowser) {
        this.executeTask(new Task(){

            @Override
            public Object run() throws Exception {
                Win32BrowserThread.toggleBold(hBrowser);
                return null;
            }
        });
    }

    public void setWin32Color(final int hBrowser, final String color) {
        this.executeTask(new Task(){

            @Override
            public Object run() throws Exception {
                Win32BrowserThread.setColor(hBrowser, color);
                return null;
            }
        });
    }

    public void insertWin32HR(final int hBrowser) {
        this.executeTask(new Task(){

            @Override
            public Object run() throws Exception {
                Win32BrowserThread.insertHR(hBrowser);
                return null;
            }
        });
    }

    public void toggleWin32Italic(final int hBrowser) {
        this.executeTask(new Task(){

            @Override
            public Object run() throws Exception {
                Win32BrowserThread.toggleItalic(hBrowser);
                return null;
            }
        });
    }

    public void toggleWin32UnderLine(final int hBrowser) {
        this.executeTask(new Task(){

            @Override
            public Object run() throws Exception {
                Win32BrowserThread.toggleUnderLine(hBrowser);
                return null;
            }
        });
    }

    public void setWin32FontName(final int hBrowser, final String fontName) {
        this.executeTask(new Task(){

            @Override
            public Object run() throws Exception {
                Win32BrowserThread.setFontName(hBrowser, fontName);
                return null;
            }
        });
    }

    public void setWin32FontSize(final int hBrowser, final String fontSize) {
        this.executeTask(new Task(){

            @Override
            public Object run() throws Exception {
                Win32BrowserThread.setFontSize(hBrowser, fontSize);
                return null;
            }
        });
    }

    public void win32scrollTop(final int hBrowser, final String tagid) {
        this.executeTask(new Task(){

            @Override
            public Object run() throws Exception {
                Win32BrowserThread.scrollTop(hBrowser, tagid);
                return null;
            }
        });
    }

    public void win32Refresh(final int hBrowser) {
        this.executeTask(new Task(){

            @Override
            public Object run() throws Exception {
                Win32BrowserThread.refreshBrowser(hBrowser);
                return null;
            }
        });
    }

    public void win32Reset(final int hBrowser) {
        this.executeTask(new Task(){

            @Override
            public Object run() throws Exception {
                Win32BrowserThread.resetBrowser(hBrowser);
                return null;
            }
        });
    }

    public void openWin32DocHtml(final int hBrowser) {
        this.executeTask(new Task(){

            @Override
            public Object run() throws Exception {
                Win32BrowserThread.openDocHtml(hBrowser);
                return null;
            }
        });
    }

    public void writeWin32DocHtml(final int hBrowser, final String html) {
        this.executeTask(new Task(){

            @Override
            public Object run() throws Exception {
                Win32BrowserThread.writeDocHtml(hBrowser, html);
                return null;
            }
        });
    }

    public void clearWin32DocHtml(final int hBrowser) {
        this.executeTask(new Task(){

            @Override
            public Object run() throws Exception {
                Win32BrowserThread.clearDocHtml(hBrowser);
                return null;
            }
        });
    }

    public void closeWin32DocHtml(final int hBrowser) {
        this.executeTask(new Task(){

            @Override
            public Object run() throws Exception {
                Win32BrowserThread.closeDocHtml(hBrowser);
                return null;
            }
        });
    }

    private static abstract class Task {
        public Semaphore lock = new Semaphore(1);
        public volatile Object result = null;

        public Task() {
            try {
                this.lock.acquire();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        public abstract Object run() throws Exception;
    }
}

