/*
 * Decompiled with CFR 0.152.
 */
package com.aibonware.viewnaver;

import com.aibonware.nvrlib.AppTools;
import com.aibonware.nvrlib.model.BoardType;
import com.aibonware.nvrlib.net.AnonymousSession;
import com.aibonware.nvrlib.net.HttpCancellerProvider;
import com.aibonware.nvrlib.net.NaverSession;
import com.aibonware.viewnaver.Cache;
import com.aibonware.viewnaver.PluginManager;
import com.aibonware.viewnaver.Version;
import com.aibonware.viewnaver.browser.BrowserFactory;
import com.aibonware.viewnaver.browser.basic.BasicBrowserFactory;
import com.aibonware.viewnaver.browser.win32.Win32BrowserFactory;
import com.aibonware.viewnaver.command.PosterMenuItemCreator;
import com.aibonware.viewnaver.component.DefaultTextOperation;
import com.aibonware.viewnaver.config.Config;
import com.aibonware.viewnaver.content.DefaultTabContentOrder;
import com.aibonware.viewnaver.decorator.ContentsDecorator;
import com.aibonware.viewnaver.decorator.DecoratorChain;
import com.aibonware.viewnaver.decorator.EmbeddedMovieDecorator;
import com.aibonware.viewnaver.decorator.GoyakuDecorator;
import com.aibonware.viewnaver.decorator.LinkGenerator;
import com.aibonware.viewnaver.format.DefaultFormatter;
import com.aibonware.viewnaver.model.BoardTitle;
import com.aibonware.viewnaver.model.BoardTitles;
import com.aibonware.viewnaver.model.FavoriteThreads;
import com.aibonware.viewnaver.model.GoyakuJiten;
import com.aibonware.viewnaver.model.IDJitenList;
import com.aibonware.viewnaver.model.ModelProvider;
import com.aibonware.viewnaver.net.MultiSession;
import com.aibonware.viewnaver.net.RemoteSite;
import com.aibonware.viewnaver.os.LinuxPlatform;
import com.aibonware.viewnaver.os.Platform;
import com.aibonware.viewnaver.os.Win32Platform;
import com.aibonware.viewnaver.server.MiniServer;
import com.aibonware.viewnaver.storage.MessageStorage;
import com.aibonware.viewnaver.storage.ThreadStorage;
import com.aibonware.viewnaver.task.HttpTaskCancellerProvider;
import com.aibonware.viewnaver.task.TaskFlow;
import com.aibonware.viewnaver.task.TaskFlowList;
import com.aibonware.viewnaver.task.ThreadPool;
import com.aibonware.viewnaver.task.WorkerTask;
import com.aibonware.viewnaver.view.LogView;
import com.aibonware.viewnaver.window.ChildWindowActivator;
import com.aibonware.viewnaver.window.ChildWindowActivatorImpl;
import com.aibonware.viewnaver.window.LoginFrame;
import com.aibonware.viewnaver.window.MainWindow;
import com.aibonware.viewnaver.window.MainWindowController;
import com.aibonware.viewnaver.window.ThreadWindow;
import com.aibonware.viewnaver.window.WindowFactory;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashMap;
import javax.swing.SwingUtilities;

public class ViewNaver
implements Runnable {
    public final PluginManager pluginManager = new PluginManager();
    public Config config;
    public MainWindow mainWindow;
    public ThreadWindow threadWindow;
    public static ViewNaver instance;
    public RemoteSite web;
    public ThreadPool threadPool;
    public BrowserFactory browserFactory = null;
    public MultiSession multiSession = null;
    public Cache cache;
    public GoyakuJiten goyakuList = null;
    public IDJitenList idJiten = null;
    public BoardTitles boardTitles = null;
    public ChildWindowActivator childWindowActivator = null;
    public ThreadStorage threadStorage = null;
    public MessageStorage messageStorage = null;
    public DefaultTabContentOrder defaultCategoryComparator = null;
    public FavoriteThreads favoriteThreads = null;
    public DefaultTextOperation deftex = null;
    public MiniServer server = null;
    public ModelProvider modelProvider = null;
    public DefaultFormatter formatter = null;
    public ContentsDecorator threadDecorator = null;
    public ContentsDecorator articleDecorator = null;
    public TaskFlowList taskFlowList = null;
    public PosterMenuItemCreator posterMenuItemCreator = null;
    public Platform platform = null;
    public WindowFactory windowFactory = null;
    public MainWindowController mainWindowController = null;
    private static LogView logView;
    public AppTools appTools = new AppTools(){

        public void err(Exception e) {
            ViewNaver.err(e);
        }

        public void println(String s) {
            ViewNaver.println(s);
        }
    };
    private HashMap<Class, Character> allocatedPUAList = new HashMap();

    static {
        logView = new LogView(5, 80);
    }

    public synchronized BrowserFactory getBrowserFactory() {
        return this.browserFactory;
    }

    public ViewNaver() {
        instance = this;
        this.platform = System.getProperty("os.name").contains("Windows") ? new Win32Platform() : new LinuxPlatform();
        this.config = new Config();
        this.taskFlowList = new TaskFlowList();
        this.threadPool = new ThreadPool();
        this.web = new RemoteSite();
        this.cache = new Cache();
        this.boardTitles = this.createBoardTitles();
    }

    private BoardTitles createBoardTitles() {
        BoardTitles group = new BoardTitles();
        group.addBoardTitle(new BoardTitle("ttravel", "\u65c5\u884c", BoardType.Text));
        group.addBoardTitle(new BoardTitle("tlife", "\u751f\u6d3b/\u6587\u5316", BoardType.Text));
        group.addBoardTitle(new BoardTitle("thistory", "\u4f1d\u7d71", BoardType.Text));
        group.addBoardTitle(new BoardTitle("tbook", "BOOK", BoardType.Text));
        group.addBoardTitle(new BoardTitle("tselftalk", "\u3072\u3068\u308a\u8a00", BoardType.Text));
        group.addBoardTitle(new BoardTitle("ttrouble", "\u60a9\u307f", BoardType.Text));
        group.addBoardTitle(new BoardTitle("tjob", "\u5c31\u8077", BoardType.Text));
        group.addBoardTitle(new BoardTitle("thumor", "\u30e6\u30fc\u30e2\u30a2", BoardType.Text));
        group.addBoardTitle(new BoardTitle("tpop", "\u97f3\u697d", BoardType.Text));
        group.addBoardTitle(new BoardTitle("tdrama", "\u30c9\u30e9\u30de", BoardType.Text));
        group.addBoardTitle(new BoardTitle("tmovie", "\u6620\u753b", BoardType.Text));
        group.addBoardTitle(new BoardTitle("tactor", "\u82b8\u80fd\u4eba", BoardType.Text));
        group.addBoardTitle(new BoardTitle("tcosmetic", "\u30d5\u30a1\u30c3\u30b7\u30e7\u30f3", BoardType.Text));
        group.addBoardTitle(new BoardTitle("tgame", "\u30b2\u30fc\u30e0", BoardType.Text));
        group.addBoardTitle(new BoardTitle("tanimation", "\u30de\u30f3\u30ac/\u30a2\u30cb\u30e1", BoardType.Text));
        group.addBoardTitle(new BoardTitle("tinternet", "IT/\u30c7\u30b8\u30bf\u30eb", BoardType.Text));
        group.addBoardTitle(new BoardTitle("tdigital", "\u30ab\u30e1\u30e9/\u96fb\u5316\u88fd\u54c1", BoardType.Text));
        group.addBoardTitle(new BoardTitle("teconomy", "\u6642\u4e8b\u30cb\u30e5\u30fc\u30b9", BoardType.Text));
        group.addBoardTitle(new BoardTitle("tsports", "\u30b9\u30dd\u30fc\u30c4", BoardType.Text));
        group.addBoardTitle(new BoardTitle("ttalk", "Hot! \u8a0e\u8ad6", BoardType.Text));
        group.addBoardTitle(new BoardTitle("tfree", "\u81ea\u7531\u63b2\u793a\u677f", BoardType.Text));
        group.addBoardTitle(new BoardTitle("ptravel", "\u89b3\u5149/\u98a8\u666f", BoardType.Image));
        group.addBoardTitle(new BoardTitle("pfood", "\u30b0\u30eb\u30e1", BoardType.Image));
        group.addBoardTitle(new BoardTitle("pfriend", "\u604b\u4eba/\u53cb\u9054/\u5bb6\u65cf", BoardType.Image));
        group.addBoardTitle(new BoardTitle("ppet", "\u30da\u30c3\u30c8", BoardType.Image));
        group.addBoardTitle(new BoardTitle("pvillage", "\u308f\u305f\u3057\u306e\u8857", BoardType.Image));
        group.addBoardTitle(new BoardTitle("pmything", "\u81ea\u6162\u306e\u4e00\u54c1", BoardType.Image));
        group.addBoardTitle(new BoardTitle("pstar", "\u82b8\u80fd\u4eba", BoardType.Image));
        group.addBoardTitle(new BoardTitle("psports", "\u30b9\u30dd\u30fc\u30c4", BoardType.Image));
        group.addBoardTitle(new BoardTitle("phumor", "\u30e6\u30fc\u30e2\u30a2", BoardType.Image));
        group.addBoardTitle(new BoardTitle("phistory", "\u4f1d\u7d71", BoardType.Image));
        group.addBoardTitle(new BoardTitle("pcar", "\u30af\u30eb\u30de", BoardType.Image));
        group.addBoardTitle(new BoardTitle("pbike", "\u30d0\u30a4\u30af", BoardType.Image));
        group.addBoardTitle(new BoardTitle("pmodel", "\u30d7\u30e9\u30e2\u30c7\u30eb/\u30d5\u30a3\u30ae\u30e5\u30a2", BoardType.Image));
        group.addBoardTitle(new BoardTitle("pgame", "\u30b2\u30fc\u30e0", BoardType.Image));
        group.addBoardTitle(new BoardTitle("panimation", "\u30de\u30f3\u30ac/\u30a2\u30cb\u30e1", BoardType.Image));
        group.addBoardTitle(new BoardTitle("pfree", "\u81ea\u7531\u30d5\u30a9\u30c8\u63b2\u793a\u677f", BoardType.Image));
        return group;
    }

    @Override
    public void run() {
        DecoratorChain decorator;
        this.pluginManager.init();
        this.pluginManager.load();
        this.pluginManager.beforeDefaultSetup();
        this.platform.initLookAndFeel();
        if (this.modelProvider == null) {
            this.modelProvider = new ModelProvider();
        }
        if (this.defaultCategoryComparator == null) {
            this.defaultCategoryComparator = new DefaultTabContentOrder();
        }
        if (this.windowFactory == null) {
            this.windowFactory = new WindowFactory();
        }
        if (this.mainWindow == null) {
            this.mainWindow = new MainWindow();
        }
        if (this.childWindowActivator == null) {
            this.childWindowActivator = new ChildWindowActivatorImpl(this.mainWindow);
        }
        if (this.threadWindow == null) {
            this.threadWindow = new ThreadWindow(this.mainWindow);
        }
        if (this.threadStorage == null) {
            this.threadStorage = new ThreadStorage();
        }
        if (this.messageStorage == null) {
            this.messageStorage = new MessageStorage();
        }
        if (this.favoriteThreads == null) {
            this.favoriteThreads = new FavoriteThreads();
        }
        if (this.deftex == null) {
            this.deftex = new DefaultTextOperation();
        }
        if (this.browserFactory == null) {
            this.browserFactory = new Win32BrowserFactory();
        }
        if (this.multiSession == null) {
            this.multiSession = new MultiSession();
        }
        if (this.formatter == null) {
            this.formatter = new DefaultFormatter();
        }
        if (this.threadDecorator == null) {
            decorator = new DecoratorChain();
            decorator.addDecorator(new EmbeddedMovieDecorator());
            decorator.addDecorator(new GoyakuDecorator());
            this.threadDecorator = decorator;
        }
        if (this.articleDecorator == null) {
            decorator = new DecoratorChain();
            decorator.addDecorator(new LinkGenerator());
            decorator.addDecorator(new GoyakuDecorator());
            this.articleDecorator = decorator;
        }
        if (this.posterMenuItemCreator == null) {
            this.posterMenuItemCreator = new PosterMenuItemCreator();
        }
        if (this.mainWindowController == null) {
            this.mainWindowController = new MainWindowController(this.mainWindow);
        }
        this.config.loadFile("config.xml");
        this.favoriteThreads.load("favorite.xml");
        this.mainWindowController.start();
        this.pluginManager.afterDefaultSetup();
        try {
            this.browserFactory.initialize();
        }
        catch (Throwable e) {
            ViewNaver.println("HTML\u30ec\u30f3\u30c0\u30ea\u30f3\u30b0\u30a8\u30f3\u30b8\u30f3\u306e\u521d\u671f\u5316\u306b\u5931\u6557\u3057\u307e\u3057\u305f(" + e.getMessage() + ")\u3002\u4ee3\u66ff\u51e6\u7406\u3092\u884c\u3044\u307e\u3059\u3002");
            this.browserFactory = new BasicBrowserFactory();
            this.browserFactory.initialize();
        }
        ViewNaver.println("viewNVR " + Version.STATUS + " " + 0 + "." + 31 + " rev." + Version.REVISION);
        ViewNaver.println("Rendering Engine: " + this.browserFactory.getEngineName());
        ViewNaver.println("");
        if (this.config.getLoginConfig().showLoginDialogOnBoot) {
            final LoginFrame loginDialog = new LoginFrame(logView, "");
            loginDialog.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosed(WindowEvent e) {
                    if (!loginDialog.loginView.confirmed) {
                        ViewNaver.this.browserFactory.terminate();
                        System.exit(-1);
                        return;
                    }
                    ViewNaver.this.mainWindow.logView.print(logView.getText());
                    ViewNaver.logView = ViewNaver.this.mainWindow.logView;
                    ViewNaver.this.mainWindow.setVisible(true);
                }
            });
            loginDialog.setVisible(true);
        } else {
            this.multiSession.addSession((NaverSession)new AnonymousSession("", this.config.getNetworkConfig().getProxyInfo(), (HttpCancellerProvider)new HttpTaskCancellerProvider()));
            this.mainWindow.logView.print(logView.getText());
            logView = this.mainWindow.logView;
            this.mainWindow.setVisible(true);
        }
    }

    private static boolean runGUI(final Runnable runnable) {
        if (SwingUtilities.isEventDispatchThread()) {
            try {
                runnable.run();
            }
            catch (RuntimeException e) {
                ViewNaver.err(e);
            }
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    try {
                        runnable.run();
                    }
                    catch (RuntimeException e) {
                        ViewNaver.err(e);
                    }
                }
            });
        }
        return true;
    }

    public static void err(final Exception e) {
        e.printStackTrace();
        ViewNaver.runGUI(new Runnable(){

            @Override
            public void run() {
                StringWriter buf = new StringWriter();
                PrintWriter writer = new PrintWriter(buf);
                e.printStackTrace(writer);
                logView.append(buf.toString());
                writer.close();
            }
        });
    }

    public static void println(final String s) {
        ViewNaver.runGUI(new Runnable(){

            @Override
            public void run() {
                logView.print(String.valueOf(s) + "\n");
            }
        });
    }

    public void exit() {
        this.config.saveFile("config.xml");
        TaskFlow taskFlow = this.taskFlowList.createNewFlow();
        taskFlow.execute(new WorkerTask(this.appTools){

            @Override
            public void exec() {
                ViewNaver.this.pluginManager.terminate();
                try {
                    ViewNaver.println("\u30b9\u30ec\u30c3\u30c9\u30ed\u30b0\u51fa\u529b\u958b\u59cb...");
                    int num = ViewNaver.instance.threadStorage.flash();
                    ViewNaver.println("\u30b9\u30ec\u30c3\u30c9\u30ed\u30b0\u51fa\u529b\u7d42\u4e86(" + num + "\u30b9\u30ec\u30c3\u30c9\u4fdd\u5b58)");
                }
                catch (Exception e) {
                    ViewNaver.err(e);
                }
                try {
                    ViewNaver.println("\u30ed\u30b0\u30a2\u30a6\u30c8\u958b\u59cb..");
                    if (ViewNaver.this.multiSession != null) {
                        ViewNaver.this.multiSession.logoutAll();
                    }
                    ViewNaver.println("\u30ed\u30b0\u30a2\u30a6\u30c8\u7d42\u4e86\u3002");
                }
                catch (Exception e) {
                    ViewNaver.err(e);
                }
                ViewNaver.runGUI(new Runnable(){

                    @Override
                    public void run() {
                        ViewNaver.println("\u30d0\u30c3\u30af\u30b0\u30e9\u30a6\u30f3\u30c9\u30bf\u30b9\u30af\u306e\u7d42\u4e86...");
                        (this).ViewNaver.this.threadPool.shutdownNow();
                        (this).ViewNaver.this.mainWindow.dispose();
                        if ((this).ViewNaver.this.browserFactory != null) {
                            (this).ViewNaver.this.browserFactory.terminate();
                        }
                        System.exit(0);
                    }
                });
            }
        });
    }

    public static String strToHtml(String s) {
        return ViewNaver.getArticleHtml(s, false, '\u0000', '\u0000');
    }

    public static String htmlToStr(String s) {
        s = s.replaceAll("&quot;", "\"");
        s = s.replaceAll("&amp;", "&");
        s = s.replaceAll("&lt;", "<");
        s = s.replaceAll("&gt;", ">");
        s = s.replaceAll("&nbsp;", " ");
        s = s.replaceAll("<br>", "\n");
        return s;
    }

    public static String getArticleHtml(String s, boolean unicode, char unicodeStartChar, char unicodeEndChar) {
        if (s == null) {
            return "";
        }
        StringBuffer buf = new StringBuffer();
        int len = s.length();
        int i = 0;
        while (i < len) {
            char c = s.charAt(i);
            switch (c) {
                case '\"': {
                    buf.append("&quot;");
                    break;
                }
                case '&': {
                    buf.append("&amp;");
                    break;
                }
                case '<': {
                    buf.append("&lt;");
                    break;
                }
                case '>': {
                    buf.append("&gt;");
                    break;
                }
                case ' ': {
                    buf.append("&nbsp;");
                    break;
                }
                default: {
                    buf.append(c);
                }
            }
            ++i;
        }
        s = buf.toString();
        if (unicode) {
            int start;
            while ((start = s.indexOf(unicodeStartChar)) != -1) {
                int end = s.indexOf(unicodeEndChar, start);
                if (end == -1) break;
                s = String.valueOf(s.substring(0, start)) + ViewNaver.toUnicode(s.substring(start + 1, end)) + s.substring(end + 1);
            }
        }
        return s;
    }

    private static String toUnicode(String s) {
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < s.length()) {
            buf.append("&#" + s.charAt(i) + ";");
            ++i;
        }
        return buf.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public char getPUA(Class clazz) {
        HashMap<Class, Character> hashMap = this.allocatedPUAList;
        synchronized (hashMap) {
            if (this.allocatedPUAList.containsKey(clazz)) {
                return this.allocatedPUAList.get(clazz).charValue();
            }
            char c = (char)(57344 + this.allocatedPUAList.size());
            if (c >= '\ue400') {
                throw new IndexOutOfBoundsException("PUA is full");
            }
            this.allocatedPUAList.put(clazz, Character.valueOf(c));
            return c;
        }
    }
}

