/*
 * Decompiled with CFR 0.152.
 */
package com.aibonware.viewnaver;

import com.aibonware.viewnaver.Plugin;
import com.aibonware.viewnaver.Util;
import com.aibonware.viewnaver.ViewNaver;
import java.io.File;
import java.util.Collections;
import java.util.Comparator;
import java.util.Vector;

public class PluginManager {
    Vector<Plugin> plugins = new Vector();

    public void init() {
        Util.makeSureDir("plugins");
    }

    public void load() {
        File[] files = new File("plugins").listFiles();
        if (files != null) {
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                String fileName = file.getName();
                if (file.isFile() && fileName.endsWith(".jar")) {
                    try {
                        String pluginName = fileName.substring(0, fileName.length() - 4);
                        if (!pluginName.contains(".")) {
                            pluginName = "com.aibonware.viewnaver.plugins." + pluginName;
                        }
                        Plugin plugin = (Plugin)Class.forName(pluginName).newInstance();
                        this.plugins.addElement(plugin);
                    }
                    catch (Exception e) {
                        ViewNaver.println("\u30d7\u30e9\u30b0\u30a4\u30f3" + fileName + "\u306e\u30ed\u30fc\u30c9\u306b\u5931\u6557\u3057\u307e\u3057\u305f(" + e.getMessage() + ")\u3002");
                    }
                }
                ++n2;
            }
        }
        Collections.sort(this.plugins, new Comparator<Plugin>(){

            @Override
            public int compare(Plugin src, Plugin dest) {
                return src.getPriorityPoint() - dest.getPriorityPoint();
            }
        });
    }

    private void processPlugin(String processName, PluginInvoker invoker) {
        int i = 0;
        while (i < this.plugins.size()) {
            Plugin plugin = this.plugins.elementAt(i);
            try {
                invoker.invoke(plugin);
            }
            catch (Exception e) {
                ViewNaver.println("\u30d7\u30e9\u30b0\u30a4\u30f3" + plugin.getName() + "\u306e\u547c\u3073\u51fa\u3057(" + processName + ")\u306b\u5931\u6557\u3057\u307e\u3057\u305f(" + e.getMessage() + ")\u3002");
                this.plugins.removeElementAt(i);
                --i;
            }
            ++i;
        }
    }

    public void beforeDefaultSetup() {
        this.processPlugin("beforeDefaultSetup", new PluginInvoker(){

            @Override
            public void invoke(Plugin plugin) {
                plugin.beforeDefaultSetup();
            }
        });
    }

    public void afterDefaultSetup() {
        this.processPlugin("afterDefaultSetup", new PluginInvoker(){

            @Override
            public void invoke(Plugin plugin) {
                plugin.afterDefaultSetup();
            }
        });
    }

    public void terminate() {
        this.processPlugin("terminate", new PluginInvoker(){

            @Override
            public void invoke(Plugin plugin) {
                plugin.afterDefaultSetup();
            }
        });
    }

    private static interface PluginInvoker {
        public void invoke(Plugin var1);
    }
}

