/*
 * Decompiled with CFR 0.152.
 */
package Acme.Serve;

import Acme.Serve.CgiServlet;
import Acme.Serve.FileServlet;
import Acme.Serve.ServeConfig;
import Acme.Serve.ServeConnection;
import Acme.Serve.servlet.Servlet;
import Acme.Serve.servlet.ServletContext;
import Acme.Serve.servlet.ServletException;
import Acme.WildcardDictionary;
import com.aibonware.viewnaver.ViewNaver;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;

public class Serve
implements ServletContext {
    private static final String progName = "Serve";
    private int port;
    WildcardDictionary registry;
    protected Hashtable servlets = new Hashtable();

    private static void usage() {
        System.err.println("usage:  Serve [-p port]");
        System.exit(1);
    }

    public Serve(int port, PrintStream logStream) {
        this.port = port;
        this.registry = new WildcardDictionary();
    }

    public Serve(int port) {
        this(port, System.err);
    }

    public Serve() {
        this(9090, System.err);
    }

    public void addServlet(String urlPat, String className) {
        int i;
        Servlet servlet = (Servlet)this.servlets.get(className);
        if (servlet != null) {
            this.addServlet(urlPat, servlet);
            return;
        }
        SecurityManager security = System.getSecurityManager();
        if (security != null && (i = className.lastIndexOf(46)) != -1) {
            security.checkPackageAccess(className.substring(0, i));
            security.checkPackageDefinition(className.substring(0, i));
        }
        try {
            servlet = (Servlet)Class.forName(className).newInstance();
            this.addServlet(urlPat, servlet);
            return;
        }
        catch (ClassNotFoundException e) {
            this.log("Class not found: " + className);
        }
        catch (ClassCastException e) {
            this.log("Class cast problem: " + e.getMessage());
        }
        catch (InstantiationException e) {
            this.log("Instantiation problem: " + e.getMessage());
        }
        catch (IllegalAccessException e) {
            this.log("Illegal class access: " + e.getMessage());
        }
        catch (Exception e) {
            this.log("Unexpected problem creating servlet: " + e);
        }
    }

    public void addServlet(String urlPat, Servlet servlet) {
        try {
            servlet.init(new ServeConfig(this));
            this.registry.put(urlPat, servlet);
            this.servlets.put(servlet.getClass().getName(), servlet);
        }
        catch (ServletException e) {
            this.log("Problem initializing servlet: " + e);
        }
    }

    public void addDefaultServlets(boolean cgi) {
        if (cgi) {
            this.addServlet("*.cgi", new CgiServlet());
        }
        this.addServlet("*", new FileServlet());
    }

    public void addDefaultServlets(boolean cgi, String throttles) throws IOException {
        if (cgi) {
            this.addServlet("*.cgi", new CgiServlet());
        }
        this.addServlet("*", new FileServlet(throttles));
    }

    public void serve() {
        ServerSocket serverSocket;
        try {
            serverSocket = new ServerSocket(this.port, 1000);
        }
        catch (IOException e) {
            this.log("Server socket: " + e);
            return;
        }
        this.log("server started.");
        try {
            try {
                while (true) {
                    Socket socket = serverSocket.accept();
                    this.log("socket accepted: " + socket.getRemoteSocketAddress());
                    new ServeConnection(socket, this);
                }
            }
            catch (IOException e) {
                this.log("Accept: " + e);
                try {
                    serverSocket.close();
                    this.destroyAllServlets();
                }
                catch (IOException iOException) {}
            }
        }
        catch (Throwable throwable) {
            try {
                serverSocket.close();
                this.destroyAllServlets();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw throwable;
        }
    }

    @Override
    public Servlet getServlet(String name) {
        return (Servlet)this.servlets.get(name);
    }

    @Override
    public Enumeration getServlets() {
        return this.servlets.elements();
    }

    @Override
    public Enumeration getServletNames() {
        return this.servlets.keys();
    }

    public void destroyAllServlets() {
        Enumeration en = this.servlets.elements();
        while (en.hasMoreElements()) {
            Servlet servlet = (Servlet)en.nextElement();
            servlet.destroy();
        }
        this.servlets.clear();
    }

    @Override
    public void log(String message) {
        Date date = new Date(System.currentTimeMillis());
        ViewNaver.println("[" + date.toString() + "] " + message);
    }

    @Override
    public void log(Exception exception, String message) {
        this.log(message);
    }

    @Override
    public String getRealPath(String path) {
        return path;
    }

    @Override
    public String getMimeType(String file) {
        int lastDot = file.lastIndexOf(46);
        int lastSep = file.lastIndexOf(File.separatorChar);
        if (lastDot == -1 || lastSep != -1 && lastDot < lastSep) {
            return "text/plain; charset=iso-8859-1";
        }
        String extension = file.substring(lastDot + 1);
        if (extension.equals("html") || extension.equals("htm")) {
            return "text/html; charset=iso-8859-1";
        }
        if (extension.equals("gif")) {
            return "image/gif";
        }
        if (extension.equals("jpg") || extension.equals("jpeg")) {
            return "image/jpeg";
        }
        if (extension.equals("au")) {
            return "audio/basic";
        }
        if (extension.equals("ra") || extension.equals("ram")) {
            return "audio/x-pn-realaudio";
        }
        if (extension.equals("wav")) {
            return "audio/wav";
        }
        if (extension.equals("mpg") || extension.equals("mpeg")) {
            return "video/mpeg";
        }
        if (extension.equals("qt") || extension.equals("mov")) {
            return "video/quicktime";
        }
        if (extension.equals("class")) {
            return "application/octet-stream";
        }
        if (extension.equals("ps")) {
            return "application/postscript";
        }
        if (extension.equals("wrl")) {
            return "x-world/x-vrml";
        }
        if (extension.equals("pac")) {
            return "application/x-ns-proxy-autoconfig";
        }
        return "text/plain; charset=iso-8859-1";
    }

    @Override
    public String getServerInfo() {
        return "Acme.Serve v1.7 of 13nov96 (http://www.acme.com/java/software/Acme.Serve.Serve.html)";
    }

    @Override
    public Object getAttribute(String name) {
        return null;
    }
}

