/*
 * Decompiled with CFR 0.152.
 */
package chrriis.dj.nativeswing.components;

import chrriis.common.Utils;
import chrriis.dj.nativeswing.Message;
import chrriis.dj.nativeswing.NSOption;
import chrriis.dj.nativeswing.NSPanelComponent;
import chrriis.dj.nativeswing.components.JWebBrowserWindow;
import chrriis.dj.nativeswing.components.NativeWebBrowser;
import chrriis.dj.nativeswing.components.WebBrowserAdapter;
import chrriis.dj.nativeswing.components.WebBrowserEvent;
import chrriis.dj.nativeswing.components.WebBrowserListener;
import chrriis.dj.nativeswing.components.WebBrowserNavigationEvent;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.lang.reflect.Array;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.border.AbstractBorder;
import javax.swing.border.Border;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

public class JWebBrowser
extends NSPanelComponent {
    private static final String USE_XULRUNNER_RUNTIME_OPTION_KEY = "XULRunner Runtime";
    private static final NSOption XUL_RUNNER_RUNTIME_OPTION = new NSOption("XULRunner Runtime");
    private final ResourceBundle RESOURCES = ResourceBundle.getBundle(String.valueOf(JWebBrowser.class.getPackage().getName().replace('.', '/')) + "/resource/WebBrowser");
    private NativeWebBrowser nativeComponent;
    private JPanel menuToolAndLocationBarPanel;
    private JMenuBar menuBar;
    private JMenu fileMenu;
    private JMenu viewMenu;
    private ButtonBarPane buttonBarPane;
    private JCheckBoxMenuItem buttonBarCheckBoxMenuItem;
    private LocationBarPane locationBarPane;
    private JCheckBoxMenuItem locationBarCheckBoxMenuItem;
    private StatusBarPane statusBarPane;
    private JCheckBoxMenuItem statusBarCheckBoxMenuItem;
    private JPanel webBrowserPanel;
    private JMenuItem backMenuItem;
    private JMenuItem forwardMenuItem;
    private JMenuItem reloadMenuItem;
    private JMenuItem stopMenuItem;
    private boolean isViewMenuVisible;
    private static final Border STATUS_BAR_BORDER = new AbstractBorder(){

        public Insets getBorderInsets(Component c) {
            return new Insets(1, 1, 1, 1);
        }

        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            Color background = c.getBackground();
            g.setColor(background == null ? Color.LIGHT_GRAY : background.darker());
            g.drawLine(0, 0, width - 1, 0);
            g.drawLine(width - 1, 0, width - 1, height - 1);
            g.drawLine(0, height - 1, width - 1, height - 1);
            g.drawLine(0, 0, 0, height - 1);
        }
    };

    public static NSOption useXULRunnerRuntime() {
        return XUL_RUNNER_RUNTIME_OPTION;
    }

    public static void clearSessionCookies() {
        NativeWebBrowser.clearSessionCookies();
    }

    private void updateNavigationButtons() {
        if (this.isViewMenuVisible || this.isButtonBarVisible()) {
            boolean isForwardEnabled;
            boolean isBackEnabled;
            boolean bl = isBackEnabled = this.nativeComponent.isNativePeerInitialized() ? this.nativeComponent.isBackNavigationEnabled() : false;
            if (this.buttonBarPane != null) {
                this.buttonBarPane.backButton.setEnabled(isBackEnabled);
            }
            this.backMenuItem.setEnabled(isBackEnabled);
            boolean bl2 = isForwardEnabled = this.nativeComponent.isNativePeerInitialized() ? this.nativeComponent.isForwardNavigationEnabled() : false;
            if (this.buttonBarPane != null) {
                this.buttonBarPane.forwardButton.setEnabled(isForwardEnabled);
            }
            this.forwardMenuItem.setEnabled(isForwardEnabled);
        }
    }

    public static void copyAppearance(JWebBrowser fromWebBrowser, JWebBrowser toWebBrowser) {
        toWebBrowser.setLocationBarVisible(fromWebBrowser.isLocationBarVisible());
        toWebBrowser.setButtonBarVisible(fromWebBrowser.isButtonBarVisible());
        toWebBrowser.setMenuBarVisible(fromWebBrowser.isMenuBarVisible());
        toWebBrowser.setStatusBarVisible(fromWebBrowser.isStatusBarVisible());
    }

    public static void copyContent(JWebBrowser fromWebBrowser, JWebBrowser toWebBrowser) {
        String location = fromWebBrowser.getResourceLocation();
        if ("about:blank".equals(location)) {
            toWebBrowser.setHTMLContent(fromWebBrowser.getHTMLContent());
        } else {
            toWebBrowser.navigate(location);
        }
    }

    public JWebBrowser(NSOption ... options) {
        Map<Object, Object> optionMap = NSOption.createOptionMap(options);
        this.nativeComponent = new NativeWebBrowser(this, optionMap.get(USE_XULRUNNER_RUNTIME_OPTION_KEY) != null);
        this.initialize(this.nativeComponent);
        this.menuToolAndLocationBarPanel = new JPanel(new BorderLayout(0, 0));
        this.menuBar = new JMenuBar();
        this.menuToolAndLocationBarPanel.add((Component)this.menuBar, "North");
        this.add((Component)this.menuToolAndLocationBarPanel, "North");
        this.webBrowserPanel = new JPanel(new BorderLayout(0, 0));
        this.webBrowserPanel.add(this.nativeComponent.createEmbeddableComponent(optionMap), "Center");
        this.add((Component)this.webBrowserPanel, "Center");
        this.nativeComponent.addWebBrowserListener(new NWebBrowserListener());
        this.adjustBorder();
        this.fileMenu = new JMenu(this.RESOURCES.getString("FileMenu"));
        JMenuItem fileNewWindowMenuItem = new JMenuItem(this.RESOURCES.getString("FileNewWindowMenu"));
        fileNewWindowMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JWebBrowser webBrowser = new JWebBrowser(new NSOption[0]);
                JWebBrowser.copyAppearance(JWebBrowser.this, webBrowser);
                JWebBrowser.copyContent(JWebBrowser.this, webBrowser);
                JWebBrowserWindow webBrowserWindow = new JWebBrowserWindow(webBrowser);
                webBrowserWindow.setVisible(true);
            }
        });
        this.fileMenu.add(fileNewWindowMenuItem);
        JMenuItem fileOpenLocationMenuItem = new JMenuItem(this.RESOURCES.getString("FileOpenLocationMenu"));
        fileOpenLocationMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                String path = JOptionPane.showInputDialog(JWebBrowser.this, JWebBrowser.this.RESOURCES.getString("FileOpenLocationDialogMessage"), JWebBrowser.this.RESOURCES.getString("FileOpenLocationDialogTitle"), 3);
                if (path != null) {
                    JWebBrowser.this.navigate(path);
                }
            }
        });
        this.fileMenu.add(fileOpenLocationMenuItem);
        JMenuItem fileOpenFileMenuItem = new JMenuItem(this.RESOURCES.getString("FileOpenFileMenu"));
        fileOpenFileMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JFileChooser fileChooser = new JFileChooser();
                if (fileChooser.showOpenDialog(JWebBrowser.this) == 0) {
                    try {
                        JWebBrowser.this.navigate(fileChooser.getSelectedFile().getAbsolutePath());
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            }
        });
        this.fileMenu.add(fileOpenFileMenuItem);
        this.menuBar.add(this.fileMenu);
        this.viewMenu = new JMenu(this.RESOURCES.getString("ViewMenu"));
        JMenu viewToolbarsMenu = new JMenu(this.RESOURCES.getString("ViewToolbarsMenu"));
        this.buttonBarCheckBoxMenuItem = new JCheckBoxMenuItem(this.RESOURCES.getString("ViewToolbarsButtonBarMenu"));
        this.buttonBarCheckBoxMenuItem.setSelected(this.isButtonBarVisible());
        this.buttonBarCheckBoxMenuItem.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                JWebBrowser.this.setButtonBarVisible(e.getStateChange() == 1);
            }
        });
        viewToolbarsMenu.add(this.buttonBarCheckBoxMenuItem);
        this.locationBarCheckBoxMenuItem = new JCheckBoxMenuItem(this.RESOURCES.getString("ViewToolbarsLocationBarMenu"));
        this.locationBarCheckBoxMenuItem.setSelected(this.isLocationBarVisible());
        this.locationBarCheckBoxMenuItem.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                JWebBrowser.this.setLocationBarVisible(e.getStateChange() == 1);
            }
        });
        viewToolbarsMenu.add(this.locationBarCheckBoxMenuItem);
        this.viewMenu.add(viewToolbarsMenu);
        this.statusBarCheckBoxMenuItem = new JCheckBoxMenuItem(this.RESOURCES.getString("ViewStatusBarMenu"));
        this.statusBarCheckBoxMenuItem.setSelected(this.isStatusBarVisible());
        this.statusBarCheckBoxMenuItem.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                JWebBrowser.this.setStatusBarVisible(e.getStateChange() == 1);
            }
        });
        this.viewMenu.add(this.statusBarCheckBoxMenuItem);
        this.viewMenu.addSeparator();
        this.backMenuItem = new JMenuItem(this.RESOURCES.getString("ViewMenuBack"), this.createIcon("ViewMenuBackIcon"));
        this.backMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JWebBrowser.this.navigateBack();
                JWebBrowser.this.nativeComponent.requestFocus();
            }
        });
        this.backMenuItem.setEnabled(false);
        this.viewMenu.add(this.backMenuItem);
        this.forwardMenuItem = new JMenuItem(this.RESOURCES.getString("ViewMenuForward"), this.createIcon("ViewMenuForwardIcon"));
        this.forwardMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JWebBrowser.this.navigateForward();
                JWebBrowser.this.nativeComponent.requestFocus();
            }
        });
        this.forwardMenuItem.setEnabled(false);
        this.viewMenu.add(this.forwardMenuItem);
        this.reloadMenuItem = new JMenuItem(this.RESOURCES.getString("ViewMenuReload"), this.createIcon("ViewMenuReloadIcon"));
        this.reloadMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JWebBrowser.this.reloadPage();
                JWebBrowser.this.nativeComponent.requestFocus();
            }
        });
        this.reloadMenuItem.setEnabled(false);
        this.viewMenu.add(this.reloadMenuItem);
        this.stopMenuItem = new JMenuItem(this.RESOURCES.getString("ViewMenuStop"), this.createIcon("ViewMenuStopIcon"));
        this.stopMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JWebBrowser.this.stopLoading();
            }
        });
        this.stopMenuItem.setEnabled(false);
        this.viewMenu.add(this.stopMenuItem);
        this.menuBar.add(this.viewMenu);
        this.viewMenu.getPopupMenu().addPopupMenuListener(new PopupMenuListener(){

            public void popupMenuCanceled(PopupMenuEvent e) {
            }

            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                JWebBrowser.this.isViewMenuVisible = false;
            }

            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                JWebBrowser.this.isViewMenuVisible = true;
                if (!JWebBrowser.this.isButtonBarVisible()) {
                    JWebBrowser.this.updateNavigationButtons();
                }
            }
        });
        this.setButtonBarVisible(true);
        this.setLocationBarVisible(true);
        this.setStatusBarVisible(true);
    }

    public void setStatusBarVisible(boolean isStatusBarVisible) {
        if (isStatusBarVisible == this.isStatusBarVisible()) {
            return;
        }
        if (isStatusBarVisible) {
            this.statusBarPane = new StatusBarPane();
            this.add((Component)this.statusBarPane, "South");
        } else {
            this.remove(this.statusBarPane);
            this.statusBarPane = null;
        }
        this.revalidate();
        this.repaint();
        this.statusBarCheckBoxMenuItem.setSelected(isStatusBarVisible);
        this.adjustBorder();
    }

    public boolean isStatusBarVisible() {
        return this.statusBarPane != null;
    }

    public void setMenuBarVisible(boolean isMenuBarVisible) {
        if (isMenuBarVisible == this.isMenuBarVisible()) {
            return;
        }
        this.menuBar.setVisible(isMenuBarVisible);
        this.adjustBorder();
    }

    public boolean isMenuBarVisible() {
        return this.menuBar.isVisible();
    }

    public void setButtonBarVisible(boolean isButtonBarVisible) {
        if (isButtonBarVisible == this.isButtonBarVisible()) {
            return;
        }
        if (isButtonBarVisible) {
            this.buttonBarPane = new ButtonBarPane();
            this.menuToolAndLocationBarPanel.add((Component)this.buttonBarPane, "West");
        } else {
            this.menuToolAndLocationBarPanel.remove(this.buttonBarPane);
            this.buttonBarPane = null;
        }
        this.menuToolAndLocationBarPanel.revalidate();
        this.menuToolAndLocationBarPanel.repaint();
        this.buttonBarCheckBoxMenuItem.setSelected(isButtonBarVisible);
        this.adjustBorder();
        if (isButtonBarVisible && !this.isViewMenuVisible) {
            this.updateNavigationButtons();
        }
    }

    public boolean isButtonBarVisible() {
        return this.buttonBarPane != null;
    }

    public void setLocationBarVisible(boolean isLocationBarVisible) {
        if (isLocationBarVisible == this.isLocationBarVisible()) {
            return;
        }
        if (isLocationBarVisible) {
            this.locationBarPane = new LocationBarPane();
            this.menuToolAndLocationBarPanel.add((Component)this.locationBarPane, "Center");
        } else {
            this.menuToolAndLocationBarPanel.remove(this.locationBarPane);
            this.locationBarPane = null;
        }
        this.menuToolAndLocationBarPanel.revalidate();
        this.menuToolAndLocationBarPanel.repaint();
        this.locationBarCheckBoxMenuItem.setSelected(isLocationBarVisible);
        this.adjustBorder();
    }

    public boolean isLocationBarVisible() {
        return this.locationBarPane != null;
    }

    public String getPageTitle() {
        return this.nativeComponent.getPageTitle();
    }

    public String getStatusText() {
        return this.nativeComponent.getStatusText();
    }

    public String getHTMLContent() {
        return this.nativeComponent.getHTMLContent();
    }

    public boolean setHTMLContent(String html) {
        return this.nativeComponent.setHTMLContent(html);
    }

    public String getResourceLocation() {
        return this.nativeComponent.getResourceLocation();
    }

    public boolean navigate(String resourceLocation) {
        return this.nativeComponent.navigate(resourceLocation);
    }

    public boolean isBackNavigationEnabled() {
        return this.nativeComponent.isBackNavigationEnabled();
    }

    public void navigateBack() {
        this.nativeComponent.navigateBack();
    }

    public boolean isForwardNavigationEnabled() {
        return this.nativeComponent.isForwardNavigationEnabled();
    }

    public void navigateForward() {
        this.nativeComponent.navigateForward();
    }

    public void reloadPage() {
        this.nativeComponent.reloadPage();
    }

    public void stopLoading() {
        this.nativeComponent.stopLoading();
    }

    public void executeJavascript(String javascript) {
        this.nativeComponent.executeJavascript(javascript);
    }

    public Object executeJavascriptWithResult(String javascript) {
        String[] result;
        if (!javascript.endsWith(";")) {
            javascript = String.valueOf(javascript) + ";";
        }
        if ((result = this.executeJavascriptWithCommandResult("[[getScriptResult]]", "try {  var result = function() {" + javascript + "}();" + "  var type = result? typeof(result): '';" + "  if('string' == type) {" + "    window.location = 'command://' + encodeURIComponent('[[getScriptResult]]') + '&' + encodeURIComponent(result);" + "  } else {" + "    window.location = 'command://' + encodeURIComponent('[[getScriptResult]]') + '&' + encodeURIComponent(type) + '&' + encodeURIComponent(result);" + "  }" + "} catch(exxxxx) {" + "  window.location = 'command://' + encodeURIComponent('[[getScriptResult]]') + '&&'" + "}")) == null) {
            return null;
        }
        if (result.length == 1) {
            return JWebBrowser.convertJavascriptObjectToJava("string", result[0]);
        }
        return JWebBrowser.convertJavascriptObjectToJava(result[0], result[1]);
    }

    public static String createJavascriptFunctionCall(String functionName, Object ... args) {
        StringBuilder sb = new StringBuilder();
        sb.append(functionName).append('(');
        int i = 0;
        while (i < args.length) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(JWebBrowser.convertJavaObjectToJavascript(args[i]));
            ++i;
        }
        sb.append(")");
        return sb.toString();
    }

    public static String convertJavaObjectToJavascript(Object o) {
        String encodedArg;
        if (o == null) {
            return "null";
        }
        if (o instanceof Boolean || o instanceof Number) {
            return o.toString();
        }
        if (o.getClass().isArray()) {
            StringBuilder sb = new StringBuilder();
            sb.append('[');
            int length = Array.getLength(o);
            int i = 0;
            while (i < length) {
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append(JWebBrowser.convertJavaObjectToJavascript(Array.get(o, i)));
                ++i;
            }
            sb.append(']');
            return sb.toString();
        }
        if ((o = o.toString()).equals(encodedArg = Utils.encodeURL((String)o))) {
            return String.valueOf('\'') + (String)o + '\'';
        }
        return "decodeURIComponent('" + encodedArg + "')";
    }

    private static Object convertJavascriptObjectToJava(String type, String value) {
        if (type.length() == 0) {
            return null;
        }
        if ("boolean".equals(type)) {
            return Boolean.parseBoolean(value);
        }
        if ("number".equals(type)) {
            try {
                return Integer.parseInt(value);
            }
            catch (Exception exception) {
                try {
                    return Float.valueOf(Float.parseFloat(value));
                }
                catch (Exception exception2) {
                    try {
                        return Long.parseLong(value);
                    }
                    catch (Exception exception3) {
                        throw new IllegalStateException("Could not convert number: " + value);
                    }
                }
            }
        }
        return value;
    }

    private String[] executeJavascriptWithCommandResult(String command, String script) {
        if (!this.nativeComponent.isNativePeerInitialized()) {
            return null;
        }
        Object[] resultArray = new Object[1];
        NCommandListener webBrowserListener = new NCommandListener(command, resultArray);
        this.nativeComponent.addWebBrowserListener(webBrowserListener);
        if (this.nativeComponent.executeJavascriptAndWait(script)) {
            int i = 0;
            while (i < 20) {
                if (resultArray[0] != null) break;
                new Message().syncSend();
                if (resultArray[0] != null) break;
                try {
                    Thread.sleep(50L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ++i;
            }
        }
        this.nativeComponent.removeWebBrowserListener(webBrowserListener);
        return (String[])resultArray[0];
    }

    public int getLoadingProgress() {
        return this.nativeComponent.getLoadingProgress();
    }

    public void addWebBrowserListener(WebBrowserListener listener) {
        this.listenerList.add(WebBrowserListener.class, listener);
        this.nativeComponent.addWebBrowserListener(listener);
    }

    public void removeWebBrowserListener(WebBrowserListener listener) {
        this.listenerList.remove(WebBrowserListener.class, listener);
        this.nativeComponent.removeWebBrowserListener(listener);
    }

    public WebBrowserListener[] getWebBrowserListeners() {
        return (WebBrowserListener[])this.listenerList.getListeners(WebBrowserListener.class);
    }

    public void setBarsVisible(boolean areBarsVisible) {
        this.setMenuBarVisible(areBarsVisible);
        this.setButtonBarVisible(areBarsVisible);
        this.setLocationBarVisible(areBarsVisible);
        this.setStatusBarVisible(areBarsVisible);
    }

    private void adjustBorder() {
        if (this.isMenuBarVisible() || this.isButtonBarVisible() || this.isLocationBarVisible() || this.isStatusBarVisible()) {
            this.webBrowserPanel.setBorder(BorderFactory.createBevelBorder(1));
        } else {
            this.webBrowserPanel.setBorder(null);
        }
    }

    public JMenuBar getMenuBar() {
        return this.menuBar;
    }

    public JMenu getFileMenu() {
        return this.fileMenu;
    }

    private Icon createIcon(String resourceKey) {
        String value = this.RESOURCES.getString(resourceKey);
        return value.length() == 0 ? null : new ImageIcon(JWebBrowser.class.getResource(value));
    }

    public JWebBrowserWindow getWebBrowserWindow() {
        Window window = SwingUtilities.getWindowAncestor(this);
        if (window instanceof JWebBrowserWindow) {
            return (JWebBrowserWindow)window;
        }
        return null;
    }

    public void setDefaultPopupMenuRegistered(boolean isDefaultPopupMenuRegistered) {
        this.nativeComponent.setDefaultPopupMenuRegistered(isDefaultPopupMenuRegistered);
    }

    private class ButtonBarPane
    extends JPanel {
        private JButton backButton;
        private JButton forwardButton;
        private JButton reloadButton;
        private JButton stopButton;

        public ButtonBarPane() {
            super(new BorderLayout(0, 0));
            JToolBar buttonToolBar = new JToolBar();
            buttonToolBar.add(Box.createHorizontalStrut(2));
            buttonToolBar.setFloatable(false);
            this.backButton = new JButton(JWebBrowser.this.createIcon("BackIcon"));
            this.backButton.setEnabled(JWebBrowser.this.backMenuItem.isEnabled());
            this.backButton.setToolTipText(JWebBrowser.this.RESOURCES.getString("BackText"));
            this.backButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JWebBrowser.this.navigateBack();
                    JWebBrowser.this.nativeComponent.requestFocus();
                }
            });
            buttonToolBar.add(this.backButton);
            this.forwardButton = new JButton(JWebBrowser.this.createIcon("ForwardIcon"));
            this.forwardButton.setToolTipText(JWebBrowser.this.RESOURCES.getString("ForwardText"));
            this.forwardButton.setEnabled(JWebBrowser.this.forwardMenuItem.isEnabled());
            this.forwardButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JWebBrowser.this.navigateForward();
                    JWebBrowser.this.nativeComponent.requestFocus();
                }
            });
            buttonToolBar.add(this.forwardButton);
            this.reloadButton = new JButton(JWebBrowser.this.createIcon("ReloadIcon"));
            this.reloadButton.setToolTipText(JWebBrowser.this.RESOURCES.getString("ReloadText"));
            this.reloadButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JWebBrowser.this.reloadPage();
                    JWebBrowser.this.nativeComponent.requestFocus();
                }
            });
            buttonToolBar.add(this.reloadButton);
            this.stopButton = new JButton(JWebBrowser.this.createIcon("StopIcon"));
            this.stopButton.setToolTipText(JWebBrowser.this.RESOURCES.getString("StopText"));
            this.stopButton.setEnabled(JWebBrowser.this.stopMenuItem.isEnabled());
            this.stopButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JWebBrowser.this.stopLoading();
                }
            });
            buttonToolBar.add(this.stopButton);
            this.add((Component)buttonToolBar, "Center");
        }
    }

    private class LocationBarPane
    extends JPanel {
        private JTextField locationField;

        public LocationBarPane() {
            super(new BorderLayout(0, 0));
            JToolBar locationToolBar = new JToolBar();
            locationToolBar.setLayout(new BoxLayout(locationToolBar, 2));
            JPanel locationToolBarInnerPanel = new JPanel(new BorderLayout(0, 0));
            locationToolBarInnerPanel.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
            locationToolBarInnerPanel.setOpaque(false);
            locationToolBar.setFloatable(false);
            this.locationField = new JTextField();
            this.locationField.addKeyListener(new KeyAdapter(){

                public void keyPressed(KeyEvent e) {
                    if (e.getKeyCode() == 27) {
                        LocationBarPane.this.updateLocation();
                    }
                }
            });
            ActionListener goActionListener = new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JWebBrowser.this.navigate(LocationBarPane.this.locationField.getText());
                    JWebBrowser.this.nativeComponent.requestFocus();
                }
            };
            this.locationField.addActionListener(goActionListener);
            this.updateLocation();
            locationToolBarInnerPanel.add((Component)this.locationField, "Center");
            JButton goButton = new JButton(JWebBrowser.this.createIcon("GoIcon"));
            goButton.setToolTipText(JWebBrowser.this.RESOURCES.getString("GoText"));
            goButton.addActionListener(goActionListener);
            locationToolBar.add(locationToolBarInnerPanel);
            locationToolBar.add(goButton);
            this.add((Component)locationToolBar, "Center");
        }

        public void updateLocation(String location) {
            this.locationField.setText(location);
        }

        public void updateLocation() {
            this.locationField.setText(JWebBrowser.this.nativeComponent.isNativePeerInitialized() ? JWebBrowser.this.nativeComponent.getResourceLocation() : "");
        }
    }

    private static class NCommandListener
    extends WebBrowserAdapter {
        private String command;
        private Object[] resultArray;

        private NCommandListener(String command, Object[] resultArray) {
            this.command = command;
            this.resultArray = resultArray;
        }

        public void commandReceived(WebBrowserEvent e, String command, String[] args) {
            if (this.command.equals(command)) {
                this.resultArray[0] = args;
                ((NativeWebBrowser)e.getWebBrowser().getNativeComponent()).removeWebBrowserListener(this);
            }
        }
    }

    private static class NWebBrowserListener
    extends WebBrowserAdapter {
        private NWebBrowserListener() {
        }

        public void locationChanged(WebBrowserNavigationEvent e) {
            JWebBrowser webBrowser = e.getWebBrowser();
            this.updateStopButton(webBrowser, false);
            if (e.isTopFrame() && webBrowser.locationBarPane != null) {
                webBrowser.locationBarPane.updateLocation();
            }
            webBrowser.updateNavigationButtons();
        }

        public void locationChanging(WebBrowserNavigationEvent e) {
            JWebBrowser webBrowser = e.getWebBrowser();
            if (e.isTopFrame() && webBrowser.locationBarPane != null) {
                webBrowser.locationBarPane.updateLocation(e.getNewResourceLocation());
            }
            this.updateStopButton(webBrowser, true);
        }

        public void locationChangeCanceled(WebBrowserNavigationEvent e) {
            JWebBrowser webBrowser = e.getWebBrowser();
            this.updateStopButton(webBrowser, false);
            if (e.isTopFrame() && webBrowser.locationBarPane != null) {
                webBrowser.locationBarPane.updateLocation();
            }
            webBrowser.updateNavigationButtons();
        }

        public void statusChanged(WebBrowserEvent e) {
            JWebBrowser webBrowser = e.getWebBrowser();
            if (webBrowser.statusBarPane != null) {
                webBrowser.statusBarPane.updateStatus();
            }
        }

        public void loadingProgressChanged(WebBrowserEvent e) {
            JWebBrowser webBrowser = e.getWebBrowser();
            if (webBrowser.statusBarPane != null) {
                webBrowser.statusBarPane.updateProgressValue();
            }
            this.updateStopButton(webBrowser, false);
        }

        private void updateStopButton(JWebBrowser webBrowser, boolean isForcedOn) {
            boolean isStopEnabled;
            boolean bl = isStopEnabled = isForcedOn || webBrowser.getLoadingProgress() != 100;
            if (webBrowser.buttonBarPane != null) {
                webBrowser.buttonBarPane.stopButton.setEnabled(isStopEnabled);
            }
            webBrowser.stopMenuItem.setEnabled(isStopEnabled);
        }
    }

    private class StatusBarPane
    extends JPanel {
        private JLabel statusLabel;
        private JProgressBar progressBar;

        public StatusBarPane() {
            super(new BorderLayout(0, 0));
            this.setBorder(BorderFactory.createCompoundBorder(STATUS_BAR_BORDER, BorderFactory.createEmptyBorder(2, 2, 2, 2)));
            this.statusLabel = new JLabel();
            this.updateStatus();
            this.add((Component)this.statusLabel, "Center");
            this.progressBar = new JProgressBar(){

                public Dimension getPreferredSize() {
                    return new Dimension(this.getParent().getWidth() / 10, 0);
                }
            };
            this.updateProgressValue();
            this.add((Component)this.progressBar, "East");
        }

        public void updateProgressValue() {
            int loadingProgress = JWebBrowser.this.nativeComponent.isNativePeerInitialized() ? JWebBrowser.this.nativeComponent.getLoadingProgress() : 100;
            this.progressBar.setValue(loadingProgress);
            this.progressBar.setVisible(loadingProgress < 100);
        }

        public void updateStatus() {
            String status = JWebBrowser.this.nativeComponent.isNativePeerInitialized() ? JWebBrowser.this.nativeComponent.getStatusText() : "";
            this.statusLabel.setText(status.length() == 0 ? " " : status);
        }
    }
}

