/*
 * Decompiled with CFR 0.152.
 */
package chrriis.dj.nativeswing.components;

import chrriis.common.ObjectRegistry;
import chrriis.common.Utils;
import chrriis.common.WebServer;
import chrriis.dj.nativeswing.LocalMessage;
import chrriis.dj.nativeswing.Message;
import chrriis.dj.nativeswing.NSOption;
import chrriis.dj.nativeswing.NSPanelComponent;
import chrriis.dj.nativeswing.NativeComponent;
import chrriis.dj.nativeswing.components.HTMLEditorListener;
import chrriis.dj.nativeswing.components.HTMLEditorSaveEvent;
import chrriis.dj.nativeswing.components.JWebBrowser;
import chrriis.dj.nativeswing.components.WebBrowserAdapter;
import chrriis.dj.nativeswing.components.WebBrowserEvent;
import java.awt.Component;
import java.io.File;
import java.io.FileFilter;
import java.io.InputStream;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.net.MalformedURLException;
import java.util.EventListener;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.SwingUtilities;

public class JHTMLEditor
extends NSPanelComponent {
    private static final String SET_CUSTOM_JAVASCRIPT_CONFIGURATION_OPTION_KEY = "HTML Editor Custom Configuration Script";
    private static final String FCK_INSTANCE = "FCKeditor1";
    private JWebBrowser webBrowser;
    private int instanceID;
    private static final String LS = Utils.LINE_SEPARATOR;
    private String customJavascriptConfiguration;
    private Object tempResult;

    public static NSOption setCustomJavascriptConfiguration(final String javascript) {
        return new NSOption(SET_CUSTOM_JAVASCRIPT_CONFIGURATION_OPTION_KEY){

            public Object getOptionValue() {
                return javascript;
            }
        };
    }

    public JHTMLEditor(NSOption ... options) {
        if (this.getClass().getResource("/fckeditor/fckeditor.js") == null) {
            throw new IllegalStateException("The FCKEditor distribution is missing from the classpath!");
        }
        Map<Object, Object> optionMap = NSOption.createOptionMap(options);
        this.customJavascriptConfiguration = (String)optionMap.get(SET_CUSTOM_JAVASCRIPT_CONFIGURATION_OPTION_KEY);
        this.webBrowser = new JWebBrowser(options);
        this.initialize(this.webBrowser.getNativeComponent());
        this.webBrowser.addWebBrowserListener(new NWebBrowserListener(this));
        this.webBrowser.setBarsVisible(false);
        this.add((Component)this.webBrowser, "Center");
        this.instanceID = ObjectRegistry.getInstance().add(this);
        final Boolean[] resultArray = new Boolean[]{Boolean.FALSE};
        InitializationListener initializationListener = new InitializationListener(){

            public void objectInitialized() {
                JHTMLEditor.this.removeInitializationListener(this);
                resultArray[0] = Boolean.TRUE;
            }
        };
        this.addInitializationListener(initializationListener);
        this.webBrowser.navigate(WebServer.getDefaultWebServer().getDynamicContentURL(JHTMLEditor.class.getName(), String.valueOf(this.instanceID), "index.html"));
        this.webBrowser.getNativeComponent().runSync(new CMLocal_waitForInitialization(), initializationListener, resultArray);
    }

    public JWebBrowser getWebBrowser() {
        return this.webBrowser;
    }

    protected static WebServer.WebServerContent getWebServerContent(final WebServer.HTTPRequest httpRequest) {
        String resourcePath = httpRequest.getResourcePath();
        int index = resourcePath.indexOf(47);
        final int instanceID = Integer.parseInt(resourcePath.substring(0, index));
        final String resourcePath_ = resourcePath.substring(index + 1);
        final JHTMLEditor htmlEditor = (JHTMLEditor)ObjectRegistry.getInstance().get(instanceID);
        if (htmlEditor == null) {
            return null;
        }
        if ("index.html".equals(resourcePath_)) {
            return new WebServer.WebServerContent(){

                public String getContentType() {
                    int index = resourcePath_.lastIndexOf(46);
                    return 3.getDefaultMimeType(index == -1 ? null : resourcePath_.substring(index));
                }

                public InputStream getInputStream() {
                    String content = "<html>" + LS + "  <head>" + LS + "    <style type=\"text/css\">" + LS + "      body, form {margin: 0; padding: 0; overflow: auto;}" + LS + "    </style>" + LS + "    <script type=\"text/javascript\" src=\"fckeditor.js\"></script>" + LS + "    <script type=\"text/javascript\">" + LS + "      function FCKeditor_IsCompatibleBrowser() {" + LS + "        return true;" + LS + "      }" + LS + "      function sendCommand(command) {" + LS + "        var s = 'command://' + encodeURIComponent(command);" + LS + "        for(var i=1; i<arguments.length; s+='&'+encodeURIComponent(arguments[i++]));" + LS + "        window.location = s;" + LS + "      }" + LS + "      function JH_setData(html) {" + LS + "        var inst = FCKeditorAPI.GetInstance('" + JHTMLEditor.FCK_INSTANCE + "');" + LS + "        inst.SetHTML(decodeURIComponent(html));" + LS + "      }" + LS + "      function JH_sendData() {" + LS + "        document.jhtml_form.action = 'jhtml_sendData';" + LS + "        document.jhtml_form.submit();" + LS + "        return false;" + LS + "      }" + LS + "      function JH_doSave() {" + LS + "        document.jhtml_form.action = 'jhtml_save';" + LS + "        document.jhtml_form.submit();" + LS + "        return false;" + LS + "      }" + LS + "      function createEditor() {" + LS + "        var oFCKeditor = new FCKeditor('" + JHTMLEditor.FCK_INSTANCE + "');" + LS + "        oFCKeditor.Width = \"100%\";" + LS + "        oFCKeditor.Height = \"100%\";" + LS + "        oFCKeditor.BasePath = \"\";" + LS + (htmlEditor.customJavascriptConfiguration != null ? "        oFCKeditor.Config[\"CustomConfigurationsPath\"] = '" + WebServer.getDefaultWebServer().getDynamicContentURL(JHTMLEditor.class.getName(), String.valueOf(instanceID), "customConfigurationScript.js") + "';" + LS : "") + "        oFCKeditor.Create();" + LS + "      }" + LS + "      function FCKeditor_OnComplete(editorInstance) {" + LS + "        editorInstance.LinkedField.form.onsubmit = JH_doSave;" + LS + "        sendCommand('JH_setLoaded');" + LS + "      }" + LS + "    </script>" + LS + "  </head>" + LS + "  <body>" + LS + "  <iframe style=\"display:none;\" name=\"j_iframe\"></iframe>" + LS + "  <form name=\"jhtml_form\" method=\"POST\" target=\"j_iframe\">" + LS + "    <script type=\"text/javascript\">" + LS + "      createEditor();" + LS + "    </script>" + "</form>" + LS + "  </body>" + LS + "</html>" + LS;
                    return 3.getInputStream(content);
                }
            };
        }
        if ("customConfigurationScript.js".equals(resourcePath_)) {
            return new WebServer.WebServerContent(){

                public String getContentType() {
                    return 4.getDefaultMimeType(".js");
                }

                public InputStream getInputStream() {
                    return 4.getInputStream(JHTMLEditor.this.customJavascriptConfiguration);
                }
            };
        }
        if ("jhtml_save".equals(resourcePath_)) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    String html = JHTMLEditor.convertLinksToLocal(httpRequest.getHTTPPostDataArray()[0].getHeaderMap().get(JHTMLEditor.FCK_INSTANCE));
                    Object[] listeners = htmlEditor.listenerList.getListenerList();
                    HTMLEditorSaveEvent e = null;
                    int i = listeners.length - 2;
                    while (i >= 0) {
                        if (listeners[i] == HTMLEditorListener.class) {
                            if (e == null) {
                                e = new HTMLEditorSaveEvent(htmlEditor, html);
                            }
                            ((HTMLEditorListener)listeners[i + 1]).saveHTML(e);
                        }
                        i -= 2;
                    }
                }
            });
            return new WebServer.WebServerContent(){

                public InputStream getInputStream() {
                    String content = "<html>" + LS + "  <body>" + LS + "    Save successful." + LS + "  </body>" + LS + "</html>" + LS;
                    return 6.getInputStream(content);
                }
            };
        }
        if ("jhtml_sendData".equals(resourcePath_)) {
            String data = httpRequest.getHTTPPostDataArray()[0].getHeaderMap().get(FCK_INSTANCE);
            htmlEditor.tempResult = data;
            return new WebServer.WebServerContent(){

                public InputStream getInputStream() {
                    String content = "<html>" + LS + "  <body>" + LS + "    Send data successful." + LS + "  </body>" + LS + "</html>" + LS;
                    return 7.getInputStream(content);
                }
            };
        }
        if ("editor/filemanager/connectors/php/upload.php".equals(resourcePath_)) {
            return new WebServer.WebServerContent(){

                public InputStream getInputStream() {
                    String content = "<html>" + LS + "  <head>" + LS + "    <script type=\"text/javascript\">" + LS + "      alert('upload to local system are not allowed...');" + LS + "    </script>" + LS + "  </head>" + LS + "  <body>" + LS + "    Upload successful." + LS + "  </body>" + LS + "</html>" + LS;
                    return 8.getInputStream(content);
                }
            };
        }
        if ("editor/filemanager/connectors/php/connector.php".equals(resourcePath_)) {
            Map<String, String> queryParameterMap = httpRequest.getQueryParameterMap();
            String command = queryParameterMap.get("Command");
            String content = null;
            if ("GetFoldersAndFiles".equals(command) || "GetFolders".equals(command)) {
                final String type = queryParameterMap.get("Type");
                String currentDir = queryParameterMap.get("CurrentFolder");
                File[] roots = File.listRoots();
                StringBuilder sb = new StringBuilder();
                sb.append("<?xml version=\"1.0\" encoding=\"utf-8\" ?>");
                sb.append("<Connector command=\"").append(command).append("\" resourceType=\"").append(type).append("\">");
                sb.append("<CurrentFolder path=\"").append(currentDir).append("\" url=\"").append(WebServer.getDefaultWebServer().getResourcePathURL(currentDir, "")).append("\" />");
                if (("GetFoldersAndFiles".equals(command) || "GetFolders".equals(command)) && currentDir.equals("/") && roots.length > 1) {
                    sb.append("<Folders>");
                    File[] fileArray = roots;
                    int n = 0;
                    int n2 = fileArray.length;
                    while (n < n2) {
                        File file = fileArray[n];
                        sb.append("<Folder name=\"").append(Utils.escapeXML(file.getAbsolutePath())).append("\"/>");
                        ++n;
                    }
                    sb.append("</Folders>");
                } else {
                    File file;
                    int n;
                    int n3;
                    File[] fileArray;
                    if ("GetFoldersAndFiles".equals(command) || "GetFolders".equals(command)) {
                        sb.append("<Folders>");
                        fileArray = new File(currentDir).listFiles(new FileFilter(){

                            public boolean accept(File pathname) {
                                return !pathname.isFile();
                            }
                        });
                        n3 = 0;
                        n = fileArray.length;
                        while (n3 < n) {
                            file = fileArray[n3];
                            sb.append("<Folder name=\"").append(Utils.escapeXML(file.getName())).append("\"/>");
                            ++n3;
                        }
                        sb.append("</Folders>");
                    }
                    if ("GetFoldersAndFiles".equals(command)) {
                        sb.append("<Files>");
                        fileArray = new File(currentDir).listFiles(new FileFilter(){

                            public boolean accept(File pathname) {
                                if (!pathname.isFile()) {
                                    return false;
                                }
                                if ("Image".equals(type)) {
                                    String name = pathname.getName().toLowerCase();
                                    return name.endsWith(".bmp") || name.endsWith(".jpg") || name.endsWith(".gif") || name.endsWith(".png");
                                }
                                if ("Flash".equals(type)) {
                                    String name = pathname.getName().toLowerCase();
                                    return name.endsWith(".swf");
                                }
                                return true;
                            }
                        });
                        n3 = 0;
                        n = fileArray.length;
                        while (n3 < n) {
                            file = fileArray[n3];
                            sb.append("<File name=\"").append(Utils.escapeXML(file.getName())).append("\" size=\"").append(file.length() / 1000L).append("\"/>");
                            ++n3;
                        }
                        sb.append("</Files>");
                    }
                }
                sb.append("</Connector>");
                content = sb.toString();
            }
            final String content_ = content;
            return new WebServer.WebServerContent(){

                public String getContentType() {
                    return "text/xml; charset=utf-8";
                }

                public InputStream getInputStream() {
                    return 11.getInputStream(content_);
                }
            };
        }
        return WebServer.getDefaultWebServer().getURLContent(WebServer.getDefaultWebServer().getClassPathResourceURL(JHTMLEditor.class.getName(), "/fckeditor/" + resourcePath_));
    }

    public String getHTMLContent() {
        if (!this.webBrowser.isNativePeerInitialized()) {
            return "";
        }
        this.tempResult = this;
        this.webBrowser.executeJavascript("JH_sendData();");
        String html = null;
        int i = 0;
        while (i < 20) {
            if (this.tempResult != this) {
                html = (String)this.tempResult;
                break;
            }
            new Message().syncSend();
            if (this.tempResult != this) {
                html = (String)this.tempResult;
                break;
            }
            try {
                Thread.sleep(50L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++i;
        }
        return JHTMLEditor.convertLinksToLocal(html);
    }

    private static String convertLinksToLocal(String html) {
        Matcher m;
        if (html == null) {
            return html;
        }
        Pattern p = Pattern.compile("=\\s*\"(" + WebServer.getDefaultWebServer().getURLPrefix() + "/resource/)([^/]+)/([^\"]+)\"\\s");
        while ((m = p.matcher(html)).find()) {
            String codeBase = html.substring(m.start(2), m.end(2));
            String resource = html.substring(m.start(3), m.end(3));
            try {
                resource = new File(Utils.decodeURL(Utils.decodeURL(codeBase)), resource).toURI().toURL().toExternalForm();
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
            html = String.valueOf(html.substring(0, m.start(1))) + resource + html.substring(m.end(3));
        }
        return html;
    }

    private static String convertLinksFromLocal(String html) {
        Matcher m;
        if (html == null) {
            return html;
        }
        Pattern p = Pattern.compile("=\\s*\"(file:/{1,3})([^\"]+)\"\\s");
        while ((m = p.matcher(html)).find()) {
            String resource = html.substring(m.start(2), m.end(2));
            File resourceFile = new File(resource);
            resource = WebServer.getDefaultWebServer().getResourcePathURL(Utils.encodeURL(resourceFile.getParent()), resourceFile.getName());
            html = String.valueOf(html.substring(0, m.start(1))) + resource + html.substring(m.end(2));
        }
        return html;
    }

    public void setHTMLContent(String html) {
        html = JHTMLEditor.convertLinksFromLocal(html.replaceAll("[\r\n]", ""));
        NativeComponent nativeComponent = this.webBrowser.getNativeComponent();
        boolean isEnabled = nativeComponent.isEnabled();
        nativeComponent.setEnabled(false);
        new Message().syncSend();
        this.webBrowser.executeJavascript("JH_setData('" + Utils.encodeURL(html) + "');");
        new Message().syncSend();
        nativeComponent.setEnabled(isEnabled);
    }

    public void addHTMLEditorListener(HTMLEditorListener listener) {
        this.listenerList.add(HTMLEditorListener.class, listener);
    }

    public void removeHTMLEditorListener(HTMLEditorListener listener) {
        this.listenerList.remove(HTMLEditorListener.class, listener);
    }

    public HTMLEditorListener[] getHTMLEditorListeners() {
        return (HTMLEditorListener[])this.listenerList.getListeners(HTMLEditorListener.class);
    }

    private void addInitializationListener(InitializationListener listener) {
        this.listenerList.add(InitializationListener.class, listener);
    }

    private void removeInitializationListener(InitializationListener listener) {
        this.listenerList.remove(InitializationListener.class, listener);
    }

    private class CMLocal_waitForInitialization
    extends LocalMessage {
        private CMLocal_waitForInitialization() {
        }

        public Object run(Object[] args) {
            InitializationListener initializationListener = (InitializationListener)args[0];
            Boolean[] resultArray = (Boolean[])args[1];
            long time = System.currentTimeMillis();
            while (!resultArray[0].booleanValue() && System.currentTimeMillis() - time < 4000L) {
                new Message().syncSend();
                try {
                    Thread.sleep(50L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            JHTMLEditor.this.removeInitializationListener(initializationListener);
            return null;
        }
    }

    private static interface InitializationListener
    extends EventListener {
        public void objectInitialized();
    }

    private static class NWebBrowserListener
    extends WebBrowserAdapter {
        protected Reference<JHTMLEditor> htmlEditor;

        protected NWebBrowserListener(JHTMLEditor htmlEditor) {
            this.htmlEditor = new WeakReference<JHTMLEditor>(htmlEditor);
        }

        public void commandReceived(WebBrowserEvent e, String command, String[] args) {
            JHTMLEditor htmlEditor = this.htmlEditor.get();
            if (htmlEditor == null) {
                return;
            }
            if ("JH_setLoaded".equals(command)) {
                Object[] listeners = htmlEditor.listenerList.getListenerList();
                int i = listeners.length - 2;
                while (i >= 0) {
                    if (listeners[i] == InitializationListener.class) {
                        ((InitializationListener)listeners[i + 1]).objectInitialized();
                    }
                    i -= 2;
                }
            }
        }
    }
}

