/*
 * Decompiled with CFR 0.152.
 */
package chrriis.dj.nativeswing;

import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.WritableRaster;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.RGB;

public class SWTUtils {
    private SWTUtils() {
    }

    public static int translateSWTKeyCode(int key) {
        switch (key) {
            case 65536: {
                return 18;
            }
            case 131072: {
                return 16;
            }
            case 262144: {
                return 17;
            }
            case 0x400000: {
                return 524;
            }
            case 0x1000001: {
                return 38;
            }
            case 0x1000002: {
                return 40;
            }
            case 0x1000003: {
                return 37;
            }
            case 0x1000004: {
                return 39;
            }
            case 0x1000005: {
                return 33;
            }
            case 0x1000006: {
                return 34;
            }
            case 0x1000007: {
                return 36;
            }
            case 0x1000008: {
                return 35;
            }
            case 0x1000009: {
                return 155;
            }
            case 8: {
                return 8;
            }
            case 13: {
                return 10;
            }
            case 127: {
                return 127;
            }
            case 27: {
                return 27;
            }
            case 10: {
                return 10;
            }
            case 9: {
                return 9;
            }
            case 0x100000A: {
                return 112;
            }
            case 0x100000B: {
                return 113;
            }
            case 0x100000C: {
                return 114;
            }
            case 0x100000D: {
                return 115;
            }
            case 0x100000E: {
                return 116;
            }
            case 0x100000F: {
                return 117;
            }
            case 0x1000010: {
                return 118;
            }
            case 0x1000011: {
                return 119;
            }
            case 0x1000012: {
                return 120;
            }
            case 0x1000013: {
                return 121;
            }
            case 0x1000014: {
                return 122;
            }
            case 0x1000015: {
                return 123;
            }
            case 0x1000016: {
                return 61440;
            }
            case 0x1000017: {
                return 61441;
            }
            case 0x1000018: {
                return 61442;
            }
            case 16777258: {
                return 106;
            }
            case 16777259: {
                return 107;
            }
            case 0x1000050: {
                return 10;
            }
            case 16777261: {
                return 109;
            }
            case 16777262: {
                return 110;
            }
            case 16777263: {
                return 111;
            }
            case 0x1000030: {
                return 96;
            }
            case 0x1000031: {
                return 97;
            }
            case 16777266: {
                return 98;
            }
            case 0x1000033: {
                return 99;
            }
            case 16777268: {
                return 100;
            }
            case 16777269: {
                return 101;
            }
            case 16777270: {
                return 102;
            }
            case 16777271: {
                return 103;
            }
            case 16777272: {
                return 104;
            }
            case 16777273: {
                return 105;
            }
            case 16777298: {
                return 20;
            }
            case 16777299: {
                return 144;
            }
            case 16777300: {
                return 145;
            }
            case 0x1000055: {
                return 19;
            }
            case 16777302: {
                return 3;
            }
            case 16777303: {
                return 154;
            }
            case 0x1000051: {
                return 156;
            }
        }
        return 0;
    }

    public static int translateSWTMouseButton(int button) {
        switch (button) {
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 3;
            }
        }
        return 0;
    }

    public static int translateSWTModifiers(int stateMask) {
        int modifiers = 0;
        if ((stateMask & 0x20000) != 0) {
            modifiers |= 1;
        }
        if ((stateMask & 0x40000) != 0) {
            modifiers |= 2;
        }
        if ((stateMask & 0x10000) != 0) {
            modifiers |= 8;
        }
        return modifiers;
    }

    public static ImageData convertAWTImage(Image image) {
        BufferedImage handle = new BufferedImage(image.getWidth(null), image.getHeight(null), 2);
        Graphics g = handle.getGraphics();
        g.drawImage(image, 0, 0, null);
        g.dispose();
        ColorModel colorModel = handle.getColorModel();
        PaletteData paletteData = new PaletteData(0xFF0000, 65280, 255);
        int width = handle.getWidth();
        ImageData imageData = new ImageData(width, handle.getHeight(), colorModel.getPixelSize(), paletteData);
        int height = handle.getHeight();
        byte[] maskData = new byte[(width + 7) / 8 * height];
        int x = width - 1;
        while (x >= 0) {
            int y = height - 1;
            while (y >= 0) {
                int rgb = handle.getRGB(x, y);
                int pixel = paletteData.getPixel(new RGB(rgb >> 16 & 0xFF, rgb >> 8 & 0xFF, rgb & 0xFF));
                imageData.setPixel(x, y, pixel);
                int alpha = rgb >> 24 & 0xFF;
                imageData.setAlpha(x, y, alpha);
                if (alpha != 0) {
                    int index = x + y * ((width + 7) / 8) * 8;
                    int n = index / 8;
                    maskData[n] = (byte)(maskData[n] | (byte)(1 << 7 - index % 8));
                }
                --y;
            }
            --x;
        }
        imageData.maskPad = 1;
        imageData.maskData = maskData;
        return imageData;
    }

    public static BufferedImage convertSWTImage(ImageData data) {
        IndexColorModel colorModel = null;
        PaletteData palette = data.palette;
        if (palette.isDirect) {
            BufferedImage bufferedImage = new BufferedImage(data.width, data.height, 2);
            ImageData transparencyMask = data.getTransparencyMask();
            int x = data.width - 1;
            while (x >= 0) {
                int y = data.height - 1;
                while (y >= 0) {
                    int alpha;
                    RGB rgb = data.palette.getRGB(data.getPixel(x, y));
                    int pixel = rgb.red << 16 | rgb.green << 8 | rgb.blue;
                    rgb = transparencyMask.palette.getRGB(transparencyMask.getPixel(x, y));
                    int mask = rgb.red << 16 | rgb.green << 8 | rgb.blue;
                    if (mask != 0 && (alpha = data.getAlpha(x, y)) > 0) {
                        pixel = pixel & 0xFFFFFF | alpha << 24;
                        bufferedImage.setRGB(x, y, pixel);
                    }
                    --y;
                }
                --x;
            }
            return bufferedImage;
        }
        RGB[] rgbs = palette.getRGBs();
        byte[] red = new byte[rgbs.length];
        byte[] green = new byte[rgbs.length];
        byte[] blue = new byte[rgbs.length];
        int i = 0;
        while (i < rgbs.length) {
            RGB rgb = rgbs[i];
            red[i] = (byte)rgb.red;
            green[i] = (byte)rgb.green;
            blue[i] = (byte)rgb.blue;
            ++i;
        }
        colorModel = data.transparentPixel != -1 ? new IndexColorModel(data.depth, rgbs.length, red, green, blue, data.transparentPixel) : new IndexColorModel(data.depth, rgbs.length, red, green, blue);
        BufferedImage bufferedImage = new BufferedImage(colorModel, ((ColorModel)colorModel).createCompatibleWritableRaster(data.width, data.height), false, null);
        WritableRaster raster = bufferedImage.getRaster();
        int[] pixelArray = new int[1];
        int y = 0;
        while (y < data.height) {
            int x = 0;
            while (x < data.width) {
                int pixel;
                pixelArray[0] = pixel = data.getPixel(x, y);
                raster.setPixel(x, y, pixelArray);
                ++x;
            }
            ++y;
        }
        return bufferedImage;
    }
}

