/*
 * Decompiled with CFR 0.152.
 */
package chrriis.dj.nativeswing;

import chrriis.common.NetworkURLClassLoader;
import chrriis.common.Utils;
import chrriis.common.WebServer;
import chrriis.dj.nativeswing.CommandMessage;
import chrriis.dj.nativeswing.LocalMessage;
import chrriis.dj.nativeswing.Message;
import chrriis.dj.nativeswing.MessagingInterface;
import chrriis.dj.nativeswing.NativeComponent;
import chrriis.dj.nativeswing.NativeComponentProxy;
import chrriis.dj.nativeswing.NativeInterfaceConfiguration;
import chrriis.dj.nativeswing.NativeInterfaceListener;
import java.awt.AWTEvent;
import java.awt.Canvas;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.event.AWTEventListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.StringReader;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.Set;
import javax.swing.SwingUtilities;
import javax.swing.event.EventListenerList;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.DeviceData;
import org.eclipse.swt.widgets.Display;

public class NativeInterface {
    private static final boolean IS_SYNCING_MESSAGES = Boolean.parseBoolean(System.getProperty("nativeswing.interface.syncmessages"));
    private static volatile List<Canvas> canvasList;
    private static Set<Window> windowSet;
    private static boolean isInitialized;
    private static boolean isOpen;
    private static NativeInterfaceConfiguration nativeInterfaceConfiguration;
    private static volatile MessagingInterface messagingInterface;
    private static Display display;
    private static EventListenerList listenerList;

    static {
        listenerList = new EventListenerList();
    }

    static Canvas[] getCanvas() {
        if (canvasList == null) {
            return new Canvas[0];
        }
        return canvasList.toArray(new Canvas[0]);
    }

    static void addCanvas(Canvas canvas) {
        if (canvasList == null) {
            canvasList = new ArrayList<Canvas>();
        }
        canvasList.add(canvas);
        HeavyweightForcer.activate(canvas);
    }

    static void removeCanvas(Canvas canvas) {
        canvasList.remove(canvas);
    }

    static Window[] getWindows() {
        if (Utils.IS_JAVA_6_OR_GREATER) {
            ArrayList<Window> windowList = new ArrayList<Window>();
            Window[] windowArray = Window.getWindows();
            int n = 0;
            int n2 = windowArray.length;
            while (n < n2) {
                Window window = windowArray[n];
                if (!(window instanceof HeavyweightForcerWindow)) {
                    windowList.add(window);
                }
                ++n;
            }
            return windowList.toArray(new Window[0]);
        }
        return windowSet == null ? new Window[]{} : windowSet.toArray(new Window[0]);
    }

    static boolean isAlive() {
        return NativeInterface.isOpen() && messagingInterface.isAlive();
    }

    private static boolean isInitialized() {
        return isInitialized;
    }

    private static boolean isOpen() {
        return isOpen;
    }

    private static void checkOpen() {
        if (!NativeInterface.isOpen()) {
            throw new IllegalStateException("The native interface is not open! Please refer to the instructions to set it up properly.");
        }
    }

    public static void close() {
        isOpen = false;
        messagingInterface.destroy();
        messagingInterface = null;
        NativeInterfaceListener[] nativeInterfaceListenerArray = NativeInterface.getNativeInterfaceListeners();
        int n = 0;
        int n2 = nativeInterfaceListenerArray.length;
        while (n < n2) {
            NativeInterfaceListener listener = nativeInterfaceListenerArray[n];
            listener.nativeInterfaceClosed();
            ++n;
        }
    }

    public static NativeInterfaceConfiguration getConfiguration() {
        if (nativeInterfaceConfiguration == null) {
            nativeInterfaceConfiguration = new NativeInterfaceConfiguration();
        }
        return nativeInterfaceConfiguration;
    }

    private static void loadClipboardDebuggingProperties() {
        try {
            Clipboard systemClipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            if (!systemClipboard.isDataFlavorAvailable(DataFlavor.stringFlavor)) {
                return;
            }
            BufferedReader reader = new BufferedReader(new StringReader((String)systemClipboard.getData(DataFlavor.stringFlavor)));
            if ("[nativeswing debug]".equals(reader.readLine().trim().toLowerCase(Locale.ENGLISH))) {
                String line;
                while ((line = reader.readLine()) != null) {
                    if (line.length() == 0) continue;
                    int index = line.indexOf(61);
                    if (index <= 0) break;
                    String propertyName = line.substring(0, index).trim();
                    String propertyValue = line.substring(index + 1).trim();
                    if (!propertyName.startsWith("nativeswing.")) continue;
                    System.setProperty(propertyName, propertyValue);
                }
            }
            reader.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void initialize() {
        if (NativeInterface.isInitialized()) {
            return;
        }
        if (nativeInterfaceConfiguration == null) {
            nativeInterfaceConfiguration = new NativeInterfaceConfiguration();
        }
        System.setProperty("sun.awt.noerasebackground", "true");
        System.setProperty("sun.awt.xembedserver", "true");
        System.setProperty("jna.force_hw_popups", "false");
        Toolkit.getDefaultToolkit().addAWTEventListener(new AWTEventListener(){
            protected Set<Dialog> dialogSet = new HashSet<Dialog>();
            protected volatile Set<Window> blockedWindowSet = new HashSet<Window>();

            protected void adjustNativeComponents() {
                if (canvasList == null) {
                    return;
                }
                int i = canvasList.size() - 1;
                while (i >= 0) {
                    NativeComponentProxy componentProxy;
                    Canvas canvas = (Canvas)canvasList.get(i);
                    Component c = canvas;
                    if (canvas instanceof NativeComponent && (componentProxy = ((NativeComponent)canvas).getNativeComponentProxy()) != null) {
                        c = componentProxy;
                    }
                    Window embedderWindowAncestor = SwingUtilities.getWindowAncestor(c);
                    boolean isBlocked = this.blockedWindowSet.contains(embedderWindowAncestor);
                    boolean isShowing = c.isShowing();
                    if (canvas instanceof NativeComponent) {
                        ((NativeComponent)canvas).setShellEnabled(!isBlocked && isShowing);
                    }
                    boolean hasFocus = canvas.hasFocus();
                    if (!isShowing && hasFocus) {
                        canvas.transferFocus();
                    }
                    --i;
                }
            }

            public void eventDispatched(AWTEvent e) {
                boolean isAdjusting = false;
                switch (e.getID()) {
                    case 102: 
                    case 103: {
                        isAdjusting = true;
                    }
                }
                if (!Utils.IS_JAVA_6_OR_GREATER && e.getSource() instanceof Window) {
                    if (windowSet == null) {
                        windowSet = new HashSet();
                    }
                    switch (e.getID()) {
                        case 102: 
                        case 200: {
                            windowSet.add((Window)e.getSource());
                            break;
                        }
                        case 103: 
                        case 202: {
                            windowSet.remove(e.getSource());
                        }
                    }
                }
                if (e.getSource() instanceof Dialog) {
                    switch (e.getID()) {
                        case 102: 
                        case 200: {
                            this.dialogSet.add((Dialog)e.getSource());
                            break;
                        }
                        case 103: 
                        case 202: {
                            this.dialogSet.remove(e.getSource());
                        }
                    }
                    switch (e.getID()) {
                        case 102: 
                        case 103: 
                        case 200: 
                        case 202: {
                            this.blockedWindowSet.clear();
                            for (Dialog dialog : this.dialogSet) {
                                if (!dialog.isVisible() || !dialog.isModal()) continue;
                                this.blockedWindowSet.add(dialog.getOwner());
                            }
                            isAdjusting = true;
                        }
                    }
                }
                if (isAdjusting) {
                    this.adjustNativeComponents();
                }
            }
        }, 65L);
        isInitialized = true;
        try {
            NativeInterfaceListener[] nativeInterfaceListenerArray = NativeInterface.getNativeInterfaceListeners();
            int n = 0;
            int n2 = nativeInterfaceListenerArray.length;
            while (n < n2) {
                NativeInterfaceListener listener = nativeInterfaceListenerArray[n];
                listener.nativeInterfaceInitialized();
                ++n;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void open() {
        if (NativeInterface.isOpen()) {
            return;
        }
        NativeInterface.initialize();
        NativeInterface.loadClipboardDebuggingProperties();
        NativeInterface.createCommunicationChannel();
        try {
            NativeInterfaceListener[] nativeInterfaceListenerArray = NativeInterface.getNativeInterfaceListeners();
            int n = 0;
            int n2 = nativeInterfaceListenerArray.length;
            while (n < n2) {
                NativeInterfaceListener listener = nativeInterfaceListenerArray[n];
                listener.nativeInterfaceOpened();
                ++n;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static boolean notifyKilled() {
        isOpen = false;
        messagingInterface = null;
        try {
            NativeInterfaceListener[] nativeInterfaceListenerArray = NativeInterface.getNativeInterfaceListeners();
            int n = 0;
            int n2 = nativeInterfaceListenerArray.length;
            while (n < n2) {
                NativeInterfaceListener listener = nativeInterfaceListenerArray[n];
                listener.nativeInterfaceClosed();
                ++n;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (!NativeInterface.isNativeSide() && nativeInterfaceConfiguration.isNativeSideRespawnedOnError()) {
            NativeInterface.createCommunicationChannel();
            return true;
        }
        return false;
    }

    static void notifyRespawned() {
        try {
            NativeInterfaceListener[] nativeInterfaceListenerArray = NativeInterface.getNativeInterfaceListeners();
            int n = 0;
            int n2 = nativeInterfaceListenerArray.length;
            while (n < n2) {
                NativeInterfaceListener listener = nativeInterfaceListenerArray[n];
                listener.nativeInterfaceOpened();
                ++n;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void createCommunicationChannel() {
        messagingInterface = NativeInterface.createMessagingInterface();
        isOpen = true;
        new CMN_setProperties().syncExec(System.getProperties());
    }

    /*
     * WARNING - void declaration
     */
    private static Process createProcess(int port) {
        String[] flags;
        int n;
        boolean isProxyClassLoaderUsed;
        String[] nativeClassPathReferenceResources;
        ArrayList<String> classPathList = new ArrayList<String>();
        String pathSeparator = System.getProperty("path.separator");
        ArrayList<Object> referenceList = new ArrayList<Object>();
        referenceList.add(NativeInterface.class);
        referenceList.add("org/eclipse/swt/widgets/Display.class");
        Class<?>[] nativeClassPathReferenceClasses = nativeInterfaceConfiguration.getNativeClassPathReferenceClasses();
        if (nativeClassPathReferenceClasses != null) {
            referenceList.addAll((Collection)Arrays.asList(nativeClassPathReferenceClasses));
        }
        if ((nativeClassPathReferenceResources = nativeInterfaceConfiguration.getNativeClassPathReferenceResources()) != null) {
            referenceList.addAll((Collection)Arrays.asList(nativeClassPathReferenceResources));
        }
        if (!(isProxyClassLoaderUsed = Boolean.parseBoolean(System.getProperty("nativeswing.peervm.forceproxyclassloader")))) {
            for (Object e : referenceList) {
                File clazzClassPath;
                if (e instanceof Class) {
                    clazzClassPath = Utils.getClassPathFile((Class)e);
                } else {
                    clazzClassPath = Utils.getClassPathFile((String)e);
                    if (NativeInterface.class.getResource("/" + e) == null) {
                        throw new IllegalStateException("A resource that is needed in the classpath is missing: " + e);
                    }
                }
                File file = clazzClassPath = e instanceof Class ? Utils.getClassPathFile((Class)e) : Utils.getClassPathFile((String)e);
                if (clazzClassPath != null) {
                    String path = clazzClassPath.getAbsolutePath();
                    if (classPathList.contains(path)) continue;
                    classPathList.add(path);
                    continue;
                }
                isProxyClassLoaderUsed = true;
            }
        }
        if (isProxyClassLoaderUsed) {
            classPathList.clear();
            File file = new File(System.getProperty("java.io.tmpdir"), ".djnativeswing/classpath");
            Utils.deleteAll(file);
            String classPath = String.valueOf(NetworkURLClassLoader.class.getName().replace('.', '/')) + ".class";
            File mainClassFile = new File(file, classPath);
            mainClassFile.getParentFile().mkdirs();
            if (!mainClassFile.exists()) {
                try {
                    int n2;
                    BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(mainClassFile));
                    BufferedInputStream in = new BufferedInputStream(NativeInterface.class.getResourceAsStream("/" + classPath));
                    byte[] bytes = new byte[1024];
                    while ((n2 = in.read(bytes)) != -1) {
                        void n3;
                        out.write(bytes, 0, (int)n3);
                    }
                    in.close();
                    out.close();
                }
                catch (Exception out) {
                    // empty catch block
                }
                mainClassFile.deleteOnExit();
            }
            classPathList.add(file.getAbsolutePath());
        }
        StringBuilder stringBuilder = new StringBuilder();
        int i = 0;
        while (i < classPathList.size()) {
            if (i > 0) {
                stringBuilder.append(pathSeparator);
            }
            stringBuilder.append((String)classPathList.get(i));
            ++i;
        }
        String javaHome = System.getProperty("java.home");
        String[] candidateBinaries = new String[]{new File(javaHome, "bin/java").getAbsolutePath(), new File("/usr/lib/java").getAbsolutePath(), "java"};
        Process p = null;
        ArrayList<String> argList = new ArrayList<String>();
        argList.add(null);
        String[] peerVMParams = nativeInterfaceConfiguration.getPeerVMParams();
        if (peerVMParams != null) {
            String[] stringArray = peerVMParams;
            int n4 = 0;
            n = stringArray.length;
            while (n4 < n) {
                String param = stringArray[n4];
                argList.add(param);
                ++n4;
            }
        }
        String[] stringArray = flags = new String[]{"nativeswing.interface.syncmessages", "nativeswing.interface.debug.printmessages", "nativeswing.peervm.debug.printstartmessage", "nativeswing.swt.debug.device", "nativeswing.swt.devicedata.debug", "nativeswing.swt.devicedata.tracking"};
        n = 0;
        int n5 = stringArray.length;
        while (n < n5) {
            String flag = stringArray[n];
            if (Boolean.parseBoolean(System.getProperty(flag))) {
                argList.add("-D" + flag + "=true");
            }
            ++n;
        }
        argList.add("-classpath");
        argList.add(stringBuilder.toString());
        if (isProxyClassLoaderUsed) {
            argList.add(NetworkURLClassLoader.class.getName());
            argList.add(WebServer.getDefaultWebServer().getClassPathResourceURL("", ""));
        }
        argList.add(NativeInterface.class.getName());
        argList.add(String.valueOf(port));
        stringArray = candidateBinaries;
        n = 0;
        n5 = stringArray.length;
        while (n < n5) {
            String candidateBinary = stringArray[n];
            argList.set(0, candidateBinary);
            if (Boolean.parseBoolean(System.getProperty("nativeswing.peervm.debug.printcommandline"))) {
                System.err.println("Native Command: " + Arrays.toString(argList.toArray()));
            }
            try {
                p = new ProcessBuilder(argList).start();
                break;
            }
            catch (IOException iOException) {
                ++n;
            }
        }
        if (p == null) {
            throw new IllegalStateException("Failed to spawn the VM!");
        }
        NativeInterface.connectStream(System.err, p.getErrorStream());
        NativeInterface.connectStream(System.out, p.getInputStream());
        return p;
    }

    private static MessagingInterface createMessagingInterface() {
        int port = Integer.parseInt(System.getProperty("nativeswing.interface.port", "-1"));
        if (port <= 0) {
            ServerSocket serverSocket;
            try {
                serverSocket = new ServerSocket();
                serverSocket.setReuseAddress(false);
                serverSocket.bind(new InetSocketAddress(0));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            port = serverSocket.getLocalPort();
            try {
                serverSocket.close();
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        Process p = Boolean.parseBoolean(System.getProperty("nativeswing.peervm.create", "true")) ? NativeInterface.createProcess(port) : null;
        Socket socket = null;
        int i = 99;
        while (i >= 0) {
            try {
                socket = new Socket("127.0.0.1", port);
                break;
            }
            catch (IOException e) {
                if (i == 0) {
                    throw new RuntimeException(e);
                }
                try {
                    Thread.sleep(200L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                --i;
            }
        }
        if (socket == null) {
            if (p != null) {
                p.destroy();
            }
            throw new IllegalStateException("Failed to connect to spawned VM!");
        }
        return new MessagingInterface(socket, false){

            protected void asyncUIExec(Runnable runnable) {
                SwingUtilities.invokeLater(runnable);
            }

            public boolean isUIThread() {
                return SwingUtilities.isEventDispatchThread();
            }
        };
    }

    private static void connectStream(final PrintStream out, InputStream in) {
        final BufferedInputStream bin = new BufferedInputStream(in);
        Thread streamThread = new Thread("NativeSwing Stream Connector"){

            public void run() {
                try {
                    int i;
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    String lineSeparator = Utils.LINE_SEPARATOR;
                    byte lastByte = (byte)lineSeparator.charAt(lineSeparator.length() - 1);
                    boolean addMessage = true;
                    byte[] bytes = new byte[1024];
                    while ((i = bin.read(bytes)) != -1) {
                        baos.reset();
                        int j = 0;
                        while (j < i) {
                            byte b = bytes[j];
                            if (addMessage) {
                                baos.write("NativeSwing: ".getBytes());
                            }
                            addMessage = b == lastByte;
                            baos.write(b);
                            ++j;
                        }
                        try {
                            out.write(baos.toByteArray());
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
        streamThread.setDaemon(true);
        streamThread.start();
    }

    private NativeInterface() {
    }

    static MessagingInterface getMessagingInterface() {
        return messagingInterface;
    }

    static Object syncSend(Message message) {
        NativeInterface.checkOpen();
        if (message instanceof LocalMessage) {
            LocalMessage localMessage = (LocalMessage)message;
            return localMessage.runCommand();
        }
        return messagingInterface.syncSend(message);
    }

    static void asyncSend(Message message) {
        if (IS_SYNCING_MESSAGES) {
            NativeInterface.syncSend(message);
        } else {
            NativeInterface.checkOpen();
            if (message instanceof LocalMessage) {
                LocalMessage localMessage = (LocalMessage)message;
                localMessage.runCommand();
                return;
            }
            messagingInterface.asyncSend(message);
        }
    }

    public static Display getDisplay() {
        return display;
    }

    static boolean isNativeSide() {
        return display != null;
    }

    public static boolean isUIThread() {
        if (!NativeInterface.isAlive()) {
            throw new IllegalStateException("The native interface is not alive!");
        }
        return messagingInterface.isUIThread();
    }

    static void checkUIThread() {
        if (!NativeInterface.isAlive()) {
            throw new IllegalStateException("The native interface is not alive!");
        }
        messagingInterface.checkUIThread();
    }

    public static void main(String[] args) throws Exception {
        Socket socket;
        if (Boolean.parseBoolean(System.getProperty("nativeswing.peervm.debug.printstartmessage"))) {
            System.err.println("Starting spawned VM");
        }
        isOpen = true;
        int port = Integer.parseInt(args[0]);
        ServerSocket serverSocket = null;
        int i = 19;
        while (i >= 0) {
            try {
                serverSocket = new ServerSocket();
                serverSocket.setReuseAddress(true);
                serverSocket.bind(new InetSocketAddress(port));
                break;
            }
            catch (IOException e2) {
                if (i == 0) {
                    throw e2;
                }
                try {
                    Thread.sleep(100L);
                }
                catch (Exception e2) {
                    // empty catch block
                }
                --i;
            }
        }
        final ServerSocket serverSocket_ = serverSocket;
        if (!Boolean.parseBoolean(System.getProperty("nativeswing.peervm.keepalive"))) {
            Thread shutdownThread = new Thread("NativeSwing Shutdown"){

                public void run() {
                    try {
                        4.sleep(10000L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (messagingInterface == null) {
                        try {
                            serverSocket_.close();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
            };
            shutdownThread.setDaemon(true);
            shutdownThread.start();
        }
        try {
            socket = serverSocket.accept();
        }
        catch (Exception e) {
            throw new IllegalStateException("The native side did not receive an incoming connection!");
        }
        Device.DEBUG = Boolean.parseBoolean(System.getProperty("nativeswing.swt.debug.device"));
        DeviceData data = new DeviceData();
        data.debug = Boolean.parseBoolean(System.getProperty("nativeswing.swt.devicedata.debug"));
        data.tracking = Boolean.parseBoolean(System.getProperty("nativeswing.swt.devicedata.tracking"));
        display = new Display(data);
        Display.setAppName((String)"DJ Native Swing");
        messagingInterface = new MessagingInterface(socket, true){

            protected void asyncUIExec(Runnable runnable) {
                display.asyncExec(runnable);
            }

            public boolean isUIThread() {
                return Thread.currentThread() == display.getThread();
            }
        };
        while (display != null && !display.isDisposed()) {
            try {
                if (display.readAndDispatch()) continue;
                display.sleep();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static void addNativeInterfaceListener(NativeInterfaceListener listener) {
        listenerList.add(NativeInterfaceListener.class, listener);
    }

    public static void removeNativeInterfaceListener(NativeInterfaceListener listener) {
        listenerList.remove(NativeInterfaceListener.class, listener);
    }

    public static NativeInterfaceListener[] getNativeInterfaceListeners() {
        return (NativeInterfaceListener[])listenerList.getListeners(NativeInterfaceListener.class);
    }

    private static class CMN_setProperties
    extends CommandMessage {
        private CMN_setProperties() {
        }

        public Object run(Object[] args) {
            Properties systemProperties = System.getProperties();
            Properties properties = (Properties)args[0];
            for (Object o : properties.keySet()) {
                if (systemProperties.containsKey(o)) continue;
                try {
                    System.setProperty((String)o, properties.getProperty((String)o));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return null;
        }
    }

    private static class HeavyweightForcer
    implements HierarchyListener {
        private Canvas canvas;
        private HeavyweightForcerWindow forcer;

        private HeavyweightForcer(Canvas canvas) {
            this.canvas = canvas;
            if (canvas.isShowing()) {
                this.createForcer();
            }
        }

        public static void activate(Canvas canvas) {
            canvas.addHierarchyListener(new HeavyweightForcer(canvas));
        }

        private void destroyForcer() {
            if (this.forcer == null) {
                return;
            }
            int count = this.forcer.getCount() - 1;
            this.forcer.setCount(count);
            if (count == 0) {
                this.forcer.dispose();
            }
            this.forcer = null;
        }

        private void createForcer() {
            Window windowAncestor = SwingUtilities.getWindowAncestor(this.canvas);
            Window[] windowArray = windowAncestor.getOwnedWindows();
            int n = 0;
            int n2 = windowArray.length;
            while (n < n2) {
                Window window = windowArray[n];
                if (window instanceof HeavyweightForcerWindow) {
                    this.forcer = (HeavyweightForcerWindow)window;
                    break;
                }
                ++n;
            }
            if (this.forcer == null) {
                this.forcer = new HeavyweightForcerWindow(windowAncestor);
            }
            this.forcer.setCount(this.forcer.getCount() + 1);
        }

        public void hierarchyChanged(HierarchyEvent e) {
            long changeFlags = e.getChangeFlags();
            if ((changeFlags & 2L) != 0L) {
                if (!this.canvas.isDisplayable()) {
                    this.canvas.removeHierarchyListener(this);
                    this.destroyForcer();
                }
            } else if ((changeFlags & 4L) != 0L) {
                if (this.canvas.isShowing()) {
                    this.createForcer();
                } else {
                    this.destroyForcer();
                }
            }
        }
    }

    private static class HeavyweightForcerWindow
    extends Window {
        private boolean isPacked;
        private int count;

        public HeavyweightForcerWindow(Window parent) {
            super(parent);
            this.pack();
            this.isPacked = true;
        }

        public boolean isVisible() {
            return this.isPacked;
        }

        public Rectangle getBounds() {
            return this.getOwner().getBounds();
        }

        public void setCount(int count) {
            this.count = count;
        }

        public int getCount() {
            return this.count;
        }
    }
}

