/*
 * Decompiled with CFR 0.152.
 */
package chrriis.dj.nativeswing;

import chrriis.common.Utils;
import chrriis.dj.nativeswing.NativeComponent;
import chrriis.dj.nativeswing.NativeComponentProxy;
import com.sun.jna.examples.WindowUtils;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.HierarchyBoundsListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.beans.PropertyVetoException;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import javax.swing.JDialog;
import javax.swing.JInternalFrame;
import javax.swing.SwingUtilities;

class NativeComponentProxyWindow
extends NativeComponentProxy {
    private static int instanceCount;
    private static volatile boolean isFocusBlocked;
    private static AWTEventListener focusAdjustmentEventListener;
    private HierarchyBoundsListener hierarchyBoundsListener = new HierarchyBoundsListener(){

        public void ancestorMoved(HierarchyEvent e) {
            NativeComponentProxyWindow.this.adjustPeerBounds();
        }

        public void ancestorResized(HierarchyEvent e) {
            NativeComponentProxyWindow.this.adjustPeerBounds();
        }
    };
    private EmbeddedWindow window;
    private volatile boolean isInvoking;
    private Rectangle[] lastArea = new Rectangle[0];

    static {
        focusAdjustmentEventListener = new AWTEventListener(){

            public void eventDispatched(AWTEvent e) {
                if (e.getSource() instanceof NativeComponent) {
                    return;
                }
                switch (e.getID()) {
                    case 502: 
                    case 503: 
                    case 504: 
                    case 505: {
                        isFocusBlocked = false;
                        break;
                    }
                    case 501: 
                    case 506: {
                        isFocusBlocked = true;
                    }
                }
            }
        };
    }

    protected NativeComponentProxyWindow(NativeComponent nativeComponent, boolean isVisibilityConstrained, boolean isDestructionOnFinalization) {
        super(nativeComponent, isVisibilityConstrained, isDestructionOnFinalization);
        this.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                if (isFocusBlocked) {
                    return;
                }
                if (!NativeComponentProxyWindow.this.window.isFocused()) {
                    NativeComponentProxyWindow.this.window.toFront();
                }
                NativeComponentProxyWindow.this.nativeComponent.requestFocus();
            }
        });
    }

    protected Component createPeer() {
        if (instanceCount == 0) {
            isFocusBlocked = true;
            Toolkit.getDefaultToolkit().addAWTEventListener(focusAdjustmentEventListener, 48L);
        }
        ++instanceCount;
        Window windowAncestor = SwingUtilities.getWindowAncestor(this);
        this.window = Utils.IS_JAVA_6_OR_GREATER ? new EmbeddedWindow(this, windowAncestor) : (windowAncestor instanceof Dialog ? new EmbeddedWindow(this, (Dialog)windowAncestor) : new EmbeddedWindow(this, (Frame)windowAncestor));
        this.window.addWindowFocusListener(new NWindowFocusListener(this));
        this.window.getContentPane().add((Component)new NativeComponent.SimpleNativeComponentHolder(this.nativeComponent), "Center");
        return this.window;
    }

    protected void connectPeer() {
        this.addHierarchyBoundsListener(this.hierarchyBoundsListener);
    }

    protected void disconnectPeer() {
        this.removeHierarchyBoundsListener(this.hierarchyBoundsListener);
    }

    protected void addPeer() {
        this.window.setVisible(true);
    }

    protected void destroyPeer() {
        this.window.dispose();
        this.window = null;
        if (--instanceCount == 0) {
            Toolkit.getDefaultToolkit().removeAWTEventListener(focusAdjustmentEventListener);
        }
    }

    protected void adjustPeerShape() {
        if (this.isInvoking) {
            return;
        }
        this.isInvoking = true;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                NativeComponentProxyWindow.this.isInvoking = false;
                NativeComponentProxyWindow.this.adjustPeerShape_();
            }
        });
    }

    protected Rectangle[] getPeerShapeArea() {
        return this.lastArea;
    }

    protected void adjustPeerShape_() {
        Object[] s;
        Dimension size;
        if (this.window == null) {
            return;
        }
        Object[] area = this.computePeerShapeArea();
        if (Arrays.equals(this.lastArea, area)) {
            return;
        }
        this.lastArea = area;
        if (area.length == 0) {
            size = new Dimension(1, 1);
            s = new Rectangle[]{new Rectangle(1, 1, 1, 1)};
        } else {
            size = this.getSize();
            s = area;
        }
        if (!this.window.getSize().equals(size)) {
            this.window.setSize(size);
        }
        WindowUtils.setWindowMask((Window)this.window, (Rectangle[])s);
    }

    protected Dimension getPeerSize() {
        if (!this.isVisibilityConstrained) {
            return super.getPeerSize();
        }
        if (this.lastArea.length == 0) {
            return new Dimension(1, 1);
        }
        return super.getPeerSize();
    }

    static class EmbeddedWindow
    extends JDialog {
        protected Reference<NativeComponentProxyWindow> nativeComponentEmbedder;

        public EmbeddedWindow(NativeComponentProxyWindow nativeComponentEmbedder, Window w) {
            super(w);
            this.init(nativeComponentEmbedder);
        }

        public EmbeddedWindow(NativeComponentProxyWindow nativeComponentEmbedder, Frame w) {
            super(w);
            this.init(nativeComponentEmbedder);
        }

        public EmbeddedWindow(NativeComponentProxyWindow nativeComponentEmbedder, Dialog w) {
            super(w);
            this.init(nativeComponentEmbedder);
        }

        protected void init(NativeComponentProxyWindow nativeComponentEmbedder) {
            this.nativeComponentEmbedder = new WeakReference<NativeComponentProxyWindow>(nativeComponentEmbedder);
            this.setUndecorated(true);
        }

        public boolean getFocusableWindowState() {
            NativeComponentProxyWindow nativeComponentEmbedder = this.nativeComponentEmbedder.get();
            if (nativeComponentEmbedder == null) {
                return false;
            }
            return !isFocusBlocked || nativeComponentEmbedder.isFocusOwner() || nativeComponentEmbedder.nativeComponent.isFocusOwner();
        }
    }

    private static class NWindowFocusListener
    implements WindowFocusListener {
        protected Reference<NativeComponentProxyWindow> nativeComponentEmbedder;

        protected NWindowFocusListener(NativeComponentProxyWindow nativeComponentEmbedder) {
            this.nativeComponentEmbedder = new WeakReference<NativeComponentProxyWindow>(nativeComponentEmbedder);
        }

        public void windowGainedFocus(WindowEvent e) {
            NativeComponentProxyWindow nativeComponentEmbedder = this.nativeComponentEmbedder.get();
            if (nativeComponentEmbedder == null) {
                return;
            }
            Container parent = nativeComponentEmbedder;
            while (parent != null && !(parent instanceof Window)) {
                if (parent instanceof JInternalFrame) {
                    Window windowAncestor = SwingUtilities.getWindowAncestor(nativeComponentEmbedder);
                    if (windowAncestor == null) break;
                    boolean focusableWindowState = windowAncestor.getFocusableWindowState();
                    windowAncestor.setFocusableWindowState(false);
                    try {
                        ((JInternalFrame)parent).setSelected(true);
                    }
                    catch (PropertyVetoException propertyVetoException) {
                        // empty catch block
                    }
                    windowAncestor.setFocusableWindowState(focusableWindowState);
                    break;
                }
                parent = parent.getParent();
            }
        }

        public void windowLostFocus(WindowEvent e) {
        }
    }
}

