/*
 * Decompiled with CFR 0.152.
 */
package chrriis.dj.nativeswing;

import chrriis.common.ObjectRegistry;
import chrriis.dj.nativeswing.CommandMessage;
import chrriis.dj.nativeswing.Message;
import chrriis.dj.nativeswing.NativeInterface;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.Socket;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.swt.SWT;

abstract class MessagingInterface {
    private static final boolean IS_DEBUGGING_MESSAGES = Boolean.parseBoolean(System.getProperty("nativeswing.interface.debug.printmessages"));
    private Object RECEIVER_LOCK = new Object();
    private ObjectOutputStream oos;
    private ObjectInputStream ois;
    private boolean isAlive = true;
    private List<Message> receivedMessageList = new LinkedList<Message>();
    private boolean isWaitingResponse;
    private ObjectRegistry syncThreadRegistry = new ObjectRegistry();
    private final Object LOCK = new Object();
    private static final int OOS_RESET_THRESHOLD;
    private int oosByteCount;

    static {
        String maxByteCountProperty = System.getProperty("nativeswing.interface.streamresetthreshold");
        OOS_RESET_THRESHOLD = maxByteCountProperty != null ? Integer.parseInt(maxByteCountProperty) : 500000;
    }

    public boolean isAlive() {
        return this.isAlive;
    }

    public void destroy() {
        this.isAlive = false;
        try {
            this.ois.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public MessagingInterface(final Socket socket, final boolean exitOnEndOfStream) {
        try {
            this.oos = new ObjectOutputStream(new BufferedOutputStream(socket.getOutputStream()){

                public synchronized void write(int b) throws IOException {
                    super.write(b);
                    MessagingInterface messagingInterface = MessagingInterface.this;
                    messagingInterface.oosByteCount = messagingInterface.oosByteCount + 1;
                }

                public synchronized void write(byte[] b, int off, int len) throws IOException {
                    super.write(b, off, len);
                    MessagingInterface messagingInterface = MessagingInterface.this;
                    messagingInterface.oosByteCount = messagingInterface.oosByteCount + len;
                }
            });
            this.oos.flush();
            this.ois = new ObjectInputStream(new BufferedInputStream(socket.getInputStream()));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        Thread receiverThread = new Thread("NativeSwing Receiver"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Unable to fully structure code
             */
            public void run() {
                while (MessagingInterface.access$4(MessagingInterface.this)) {
                    block29: {
                        message = null;
                        try {
                            message = MessagingInterface.access$5(MessagingInterface.this);
                            break block29;
                        }
                        catch (Exception e) {
                            isRespawned = false;
                            if (MessagingInterface.access$4(MessagingInterface.this)) {
                                MessagingInterface.access$6(MessagingInterface.this, false);
                                if (exitOnEndOfStream) {
                                    System.exit(0);
                                }
                                e.printStackTrace();
                                try {
                                    isRespawned = NativeInterface.notifyKilled();
                                }
                                catch (Exception ex) {
                                    ex.printStackTrace();
                                }
                            }
                            ex = MessagingInterface.access$7(MessagingInterface.this);
                            synchronized (ex) {
                                MessagingInterface.access$8(MessagingInterface.this).clear();
                                MessagingInterface.access$7(MessagingInterface.this).notify();
                            }
                            var7_13 = MessagingInterface.access$0(MessagingInterface.this).getInstanceIDs();
                            var5_11 = 0;
                            var6_12 = var7_13.length;
                            ** while (var5_11 < var6_12)
                        }
lbl-1000:
                        // 1 sources

                        {
                            instanceID = var7_13[var5_11];
                            thread = (Thread)MessagingInterface.access$0(MessagingInterface.this).get(instanceID);
                            if (thread != null) {
                                var9_15 = thread;
                                synchronized (var9_15) {
                                    thread.notify();
                                }
                            }
                            ++var5_11;
                            continue;
                        }
lbl42:
                        // 1 sources

                        if (isRespawned) {
                            NativeInterface.notifyRespawned();
                        }
                    }
                    if (message == null) continue;
                    if (!message.isUI()) {
                        message_ = message;
                        new Thread("NativeSwing Async"){

                            public void run() {
                                MessagingInterface.this.runMessage(message_);
                            }
                        }.start();
                        continue;
                    }
                    var2_5 = MessagingInterface.access$7(MessagingInterface.this);
                    synchronized (var2_5) {
                        MessagingInterface.access$8(MessagingInterface.this).add(message);
                        if (MessagingInterface.access$9(MessagingInterface.this)) {
                            MessagingInterface.access$7(MessagingInterface.this).notify();
                        } else if (MessagingInterface.access$8(MessagingInterface.this).size() == 1) {
                            MessagingInterface.this.asyncUIExec(new Runnable(){

                                public void run() {
                                    MessagingInterface.this.processReceivedMessages();
                                }
                            });
                        }
                    }
                }
                try {
                    MessagingInterface.access$11(MessagingInterface.this).close();
                }
                catch (Exception var1_2) {
                    // empty catch block
                }
                try {
                    MessagingInterface.access$12(MessagingInterface.this).close();
                }
                catch (Exception var1_3) {
                    // empty catch block
                }
                try {
                    socket.close();
                }
                catch (Exception var1_4) {
                    // empty catch block
                }
            }
        };
        receiverThread.setDaemon(true);
        receiverThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CommandResultMessage processReceivedMessages() {
        while (true) {
            Message message;
            Object object = this.RECEIVER_LOCK;
            synchronized (object) {
                block6: {
                    if (!this.receivedMessageList.isEmpty()) break block6;
                    return null;
                }
                message = this.receivedMessageList.remove(0);
            }
            if (message instanceof CommandResultMessage) {
                return (CommandResultMessage)message;
            }
            this.runMessage(message);
        }
    }

    private CommandResultMessage runMessage(Message message) {
        CommandResultMessage commandResultMessage;
        if (IS_DEBUGGING_MESSAGES) {
            System.err.println(">RUN: " + message.getID() + ", " + message);
        }
        if (message instanceof CommandMessage) {
            CommandMessage commandMessage = (CommandMessage)message;
            Object result = null;
            Throwable throwable = null;
            if (message.isValid()) {
                try {
                    result = commandMessage.runCommand();
                }
                catch (Throwable t) {
                    throwable = t;
                }
            }
            if (commandMessage.isSyncExec()) {
                commandResultMessage = new CommandResultMessage(commandMessage.getID(), result, throwable);
                this.asyncSend(commandResultMessage);
            } else {
                if (throwable != null) {
                    throwable.printStackTrace();
                }
                commandResultMessage = new CommandResultMessage(message.getID(), result, throwable);
            }
        } else {
            commandResultMessage = new CommandResultMessage(message.getID(), null, null);
            if (message.isSyncExec()) {
                this.asyncSend(commandResultMessage);
            }
        }
        if (IS_DEBUGGING_MESSAGES) {
            System.err.println("<RUN: " + message.getID());
        }
        return commandResultMessage;
    }

    protected abstract void asyncUIExec(Runnable var1);

    public abstract boolean isUIThread();

    public void checkUIThread() {
        if (!this.isUIThread()) {
            if (NativeInterface.isNativeSide()) {
                SWT.error((int)22);
                return;
            }
            throw new IllegalStateException("This call must happen in the AWT Event Dispatch Thread! Please refer to http://java.sun.com/docs/books/tutorial/uiswing/concurrency/index.html and http://java.sun.com/javase/6/docs/api/javax/swing/SwingUtilities.html#invokeLater(java.lang.Runnable)");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Object nonUISyncExec(Message message) {
        Thread thread = Thread.currentThread();
        int instanceID = this.syncThreadRegistry.add(Thread.currentThread());
        CM_asyncExec asyncExec = new CM_asyncExec();
        asyncExec.setArgs(instanceID, message);
        this.asyncSend(asyncExec);
        Thread thread2 = thread;
        synchronized (thread2) {
            do {
                if (!(this.syncThreadRegistry.get(instanceID) instanceof Thread)) {
                    CommandResultMessage commandResultMessage = (CommandResultMessage)this.syncThreadRegistry.get(instanceID);
                    this.syncThreadRegistry.remove(instanceID);
                    return this.processCommandResult(commandResultMessage);
                }
                try {
                    thread.wait();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            } while (this.isAlive());
            this.syncThreadRegistry.remove(instanceID);
            this.printFailedInvocation(message);
            return null;
        }
    }

    private void printFailedInvocation(Message message) {
        System.err.println("Failed messaging: " + message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object syncSend(Message message) {
        if (!this.isUIThread()) {
            return this.nonUISyncExec(message);
        }
        Object object = this.LOCK;
        synchronized (object) {
            message.setUI(true);
            message.setSyncExec(true);
            if (!this.isAlive()) {
                this.printFailedInvocation(message);
                return null;
            }
            CommandResultMessage commandResultMessage = null;
            try {
                Object object2;
                ArrayList<CommandResultMessage> commandResultMessageList;
                block20: {
                    this.writeMessage(message);
                    commandResultMessageList = new ArrayList<CommandResultMessage>();
                    do {
                        if ((commandResultMessage = this.processReceivedMessages()) != null) {
                            if (commandResultMessage.getOriginalID() != message.getID()) {
                                commandResultMessageList.add(commandResultMessage);
                                commandResultMessage = null;
                                continue;
                            }
                            break block20;
                        }
                        object2 = this.RECEIVER_LOCK;
                        synchronized (object2) {
                            if (this.receivedMessageList.isEmpty()) {
                                this.isWaitingResponse = true;
                                this.RECEIVER_LOCK.wait();
                                this.isWaitingResponse = false;
                            }
                        }
                    } while (this.isAlive());
                    this.printFailedInvocation(message);
                    return null;
                }
                object2 = this.RECEIVER_LOCK;
                synchronized (object2) {
                    if (!commandResultMessageList.isEmpty()) {
                        this.receivedMessageList.addAll(0, commandResultMessageList);
                    } else if (!this.receivedMessageList.isEmpty()) {
                        this.asyncUIExec(new Runnable(){

                            public void run() {
                                MessagingInterface.this.processReceivedMessages();
                            }
                        });
                    }
                }
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
            return this.processCommandResult(commandResultMessage);
        }
    }

    private Object processCommandResult(CommandResultMessage commandResultMessage) {
        Throwable exception;
        if (IS_DEBUGGING_MESSAGES) {
            System.err.println("<USE: " + commandResultMessage.getID());
        }
        if ((exception = commandResultMessage.getException()) != null) {
            throw new RuntimeException(exception);
        }
        return commandResultMessage.getResult();
    }

    public void asyncSend(Message message) {
        message.setUI(this.isUIThread());
        message.setSyncExec(false);
        try {
            this.writeMessage(message);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeMessage(Message message) throws IOException {
        if (!this.isAlive()) {
            this.printFailedInvocation(message);
            return;
        }
        if (IS_DEBUGGING_MESSAGES) {
            System.err.println(String.valueOf(message.isSyncExec() ? "SYNDS" : "SYNDA") + ": " + message.getID() + ", " + message);
        }
        ObjectOutputStream objectOutputStream = this.oos;
        synchronized (objectOutputStream) {
            this.oos.writeUnshared(message);
            this.oos.flush();
            if (this.oosByteCount > OOS_RESET_THRESHOLD) {
                this.oos.reset();
                this.oosByteCount = 0;
            }
        }
    }

    private Message readMessage() throws IOException, ClassNotFoundException {
        Object o = this.ois.readUnshared();
        if (o instanceof Message) {
            Message message = (Message)o;
            if (IS_DEBUGGING_MESSAGES) {
                System.err.println("RECV: " + message.getID() + ", " + message);
            }
            return message;
        }
        System.err.println("Unknown message: " + o);
        return null;
    }

    static /* synthetic */ boolean access$4(MessagingInterface messagingInterface) {
        return messagingInterface.isAlive;
    }

    static /* synthetic */ Message access$5(MessagingInterface messagingInterface) throws IOException, ClassNotFoundException {
        return messagingInterface.readMessage();
    }

    static /* synthetic */ void access$6(MessagingInterface messagingInterface, boolean bl) {
        messagingInterface.isAlive = bl;
    }

    static /* synthetic */ Object access$7(MessagingInterface messagingInterface) {
        return messagingInterface.RECEIVER_LOCK;
    }

    static /* synthetic */ List access$8(MessagingInterface messagingInterface) {
        return messagingInterface.receivedMessageList;
    }

    static /* synthetic */ boolean access$9(MessagingInterface messagingInterface) {
        return messagingInterface.isWaitingResponse;
    }

    static /* synthetic */ ObjectOutputStream access$11(MessagingInterface messagingInterface) {
        return messagingInterface.oos;
    }

    static /* synthetic */ ObjectInputStream access$12(MessagingInterface messagingInterface) {
        return messagingInterface.ois;
    }

    private static class CM_asyncExec
    extends CommandMessage {
        private CM_asyncExec() {
        }

        public Object run(Object[] args) {
            Message message = (Message)args[1];
            message.setSyncExec(false);
            MessagingInterface messagingInterface = NativeInterface.getMessagingInterface();
            CM_asyncExecResponse asyncExecResponse = new CM_asyncExecResponse();
            asyncExecResponse.setArgs(args[0], messagingInterface.runMessage(message));
            messagingInterface.asyncSend(asyncExecResponse);
            return null;
        }
    }

    private static class CM_asyncExecResponse
    extends CommandMessage {
        private CM_asyncExecResponse() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object run(Object[] args) {
            MessagingInterface messagingInterface = NativeInterface.getMessagingInterface();
            int instanceID = (Integer)args[0];
            Thread thread = (Thread)messagingInterface.syncThreadRegistry.get(instanceID);
            messagingInterface.syncThreadRegistry.remove(instanceID);
            if (thread == null) {
                return null;
            }
            Thread thread2 = thread;
            synchronized (thread2) {
                messagingInterface.syncThreadRegistry.add(args[1], instanceID);
                thread.notify();
            }
            return null;
        }
    }

    private static class CommandResultMessage
    extends Message {
        private int originalID;
        private Object result;
        private Throwable exception;

        CommandResultMessage(int originalID, Object result, Throwable exception) {
            this.originalID = originalID;
            this.result = result;
            this.exception = exception;
        }

        int getOriginalID() {
            return this.originalID;
        }

        public Object getResult() {
            return this.result;
        }

        public Throwable getException() {
            return this.exception;
        }

        public String toString() {
            return String.valueOf(super.toString()) + "(" + this.originalID + ")";
        }
    }
}

