/*
 * Decompiled with CFR 0.152.
 */
package chrriis.dj.nativeswing;

import chrriis.dj.nativeswing.CommandMessage;
import chrriis.dj.nativeswing.NativeComponent;
import chrriis.dj.nativeswing.NativeInterface;
import org.eclipse.swt.widgets.Control;

public abstract class ControlCommandMessage
extends CommandMessage {
    private int componentID;

    int getComponentID() {
        return this.componentID;
    }

    public void setControl(Control control) {
        this.componentID = (Integer)control.getData("NS_ID");
    }

    public void setNativeComponent(NativeComponent nativeComponent) {
        this.componentID = nativeComponent.getComponentID();
    }

    public Control getControl() {
        return (Control)NativeComponent.getRegistry().get(this.componentID);
    }

    public NativeComponent getNativeComponent() {
        return (NativeComponent)NativeComponent.getRegistry().get(this.componentID);
    }

    public void asyncExec(NativeComponent nativeComponent, Object ... args) {
        this.setNativeComponent(nativeComponent);
        this.asyncExec(args);
    }

    public void asyncExec(Control control, Object ... args) {
        this.setControl(control);
        this.asyncExec(args);
    }

    public Object syncExec(NativeComponent nativeComponent, Object ... args) {
        this.setNativeComponent(nativeComponent);
        return this.syncExec(args);
    }

    public Object syncExec(Control control, Object ... args) {
        this.setControl(control);
        return this.syncExec(args);
    }

    public Object syncExec(Object ... args) {
        if (this.componentID == 0) {
            if (NativeInterface.isNativeSide()) {
                throw new IllegalStateException("The control was not specified!");
            }
            throw new IllegalStateException("The native component was not specified!");
        }
        return super.syncExec(args);
    }

    public void asyncExec(Object ... args) {
        if (this.componentID == 0) {
            if (NativeInterface.isNativeSide()) {
                throw new IllegalStateException("The control was not specified!");
            }
            throw new IllegalStateException("The native component was not specified!");
        }
        super.asyncExec(args);
    }

    protected boolean isValid() {
        if (NativeInterface.isNativeSide()) {
            return this.getControl() != null;
        }
        return this.getNativeComponent() != null;
    }
}

