/*
 * Decompiled with CFR 0.152.
 */
package com.aibonware.viewnaver.djbrowser;

import chrriis.dj.nativeswing.NSOption;
import chrriis.dj.nativeswing.components.JWebBrowser;
import chrriis.dj.nativeswing.components.WebBrowserAdapter;
import chrriis.dj.nativeswing.components.WebBrowserListener;
import chrriis.dj.nativeswing.components.WebBrowserNavigationEvent;
import com.aibonware.viewnaver.browser.SimpleBrowserImpl;
import java.awt.Component;
import java.util.Vector;
import javax.swing.SwingUtilities;

public class DJBrowserImpl
extends SimpleBrowserImpl {
    private JWebBrowser browser;
    private boolean notified = false;
    private Vector<Runnable> browserCommands = new Vector();
    private Boolean isIE = null;
    private StringBuffer docBuf = null;

    private void setNotified() {
        this.notified = true;
    }

    public DJBrowserImpl(String initialHtml) {
        this.browser = new JWebBrowser(new NSOption[0]){

            public void addNotify() {
                super.addNotify();
                DJBrowserImpl.this.setNotified();
                DJBrowserImpl.this.flushCommands();
            }
        };
        this.browser.setHTMLContent(initialHtml);
        this.browser.setBarsVisible(false);
        this.browser.setStatusBarVisible(false);
        this.browser.addWebBrowserListener((WebBrowserListener)new WebBrowserAdapter(){

            public void locationChanging(WebBrowserNavigationEvent e) {
                if (!e.getNewResourceLocation().equals("about:blank")) {
                    DJBrowserImpl.this.notifyBeforeNavigate(e.getNewResourceLocation());
                    e.consume();
                }
            }

            public void locationChanged(WebBrowserNavigationEvent e) {
            }
        });
    }

    private void flushCommands() {
        if (this.browserCommands.size() > 0) {
            int i = 0;
            while (i < this.browserCommands.size()) {
                Runnable r = this.browserCommands.elementAt(i);
                try {
                    if (SwingUtilities.isEventDispatchThread()) {
                        r.run();
                    } else {
                        SwingUtilities.invokeAndWait(r);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                ++i;
            }
            this.browserCommands.clear();
        }
    }

    private void executeCommand(Runnable r) {
        this.browserCommands.addElement(r);
        if (this.notified) {
            this.flushCommands();
        }
    }

    public Component getComponent() {
        return this.browser;
    }

    private String escapeHtml(String src) {
        return "'" + src.replaceAll("'", "\\\\'").replaceAll("[\\n\\r]+", "\\\\n") + "'";
    }

    public void clearDocHtml() {
        this.executeCommand(new Runnable(){

            @Override
            public void run() {
                DJBrowserImpl.this.browser.setHTMLContent("");
            }
        });
    }

    public void closeDocHtml() {
    }

    public void insertBodyHtml(final String tagid, final String html) {
        this.executeCommand(new Runnable(){

            @Override
            public void run() {
                if (DJBrowserImpl.this.isIE == null) {
                    DJBrowserImpl.this.isIE = "Microsoft Internet Explorer".equals(DJBrowserImpl.this.browser.executeJavascriptWithResult("return navigator.appName;"));
                }
                if (DJBrowserImpl.this.isIE.booleanValue()) {
                    DJBrowserImpl.this.browser.executeJavascript("document.getElementById(" + DJBrowserImpl.this.escapeHtml(tagid) + ").insertAdjacentHTML('AfterEnd', " + DJBrowserImpl.this.escapeHtml(html) + ");");
                } else {
                    String script = "var c = document.getElementById(" + DJBrowserImpl.this.escapeHtml(tagid) + ");" + "var r = document.createRange(); " + "r.selectNode(c); " + "var t = r.createContextualFragment(" + DJBrowserImpl.this.escapeHtml(html) + "); " + "c.parentNode.insertBefore(t,c.nextSibling);";
                    DJBrowserImpl.this.browser.executeJavascript(script);
                }
            }
        });
    }

    public void refresh() {
    }

    public void replaceBodyHtml(final String tagid, final String html) {
        this.executeCommand(new Runnable(){

            @Override
            public void run() {
                String script = "document.getElementById(" + DJBrowserImpl.this.escapeHtml(tagid) + ").innerHTML = " + DJBrowserImpl.this.escapeHtml(html) + ";";
                DJBrowserImpl.this.browser.executeJavascript(script);
            }
        });
    }

    public void reset() {
    }

    public void scrollTop(final String tagid) {
        this.executeCommand(new Runnable(){

            @Override
            public void run() {
                String script = "document.getElementById(" + DJBrowserImpl.this.escapeHtml(tagid) + ").scrollIntoView(true);";
                DJBrowserImpl.this.browser.executeJavascript(script);
            }
        });
    }

    public void setBodyHtml(final String html) {
        this.executeCommand(new Runnable(){

            @Override
            public void run() {
                DJBrowserImpl.this.browser.executeJavascript("document.body.innerHTML = " + DJBrowserImpl.this.escapeHtml(html));
            }
        });
    }

    public void beginDocWriting() {
        this.executeCommand(new Runnable(){

            @Override
            public void run() {
                DJBrowserImpl.this.docBuf = new StringBuffer();
            }
        });
    }

    public void writeDocHtml(final String html) {
        this.executeCommand(new Runnable(){

            @Override
            public void run() {
                DJBrowserImpl.this.docBuf.append(html);
            }
        });
    }

    public void endDocWriting() {
        this.executeCommand(new Runnable(){

            @Override
            public void run() {
                DJBrowserImpl.this.browser.setHTMLContent(DJBrowserImpl.this.docBuf.toString());
                DJBrowserImpl.this.docBuf = null;
            }
        });
    }
}

