/*
 * Decompiled with CFR 0.152.
 */
package com.aibonware.viewnaver.view;

import com.aibonware.viewnaver.ViewNaver;
import com.aibonware.viewnaver.browser.EditableBrowser;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GraphicsEnvironment;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Formatter;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.border.BevelBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ThreadContentsEditorView
extends Container {
    public EditableBrowser browser;
    public JTextArea htmlSourceView;
    public JTextField threadTitleText;
    public JTabbedPane tab;
    private String delayHtml = null;

    private void buildBrowserPanel(JTabbedPane tab) {
        this.browser = ViewNaver.instance.getBrowserFactory().createEditableBrowser();
        if (this.browser == null) {
            return;
        }
        this.browser.beginDocWriting();
        this.browser.writeDocHtml("<html><head><meta http-equiv=\"Content-Type\" content=\"text/html\"></head><body></body></html>");
        this.browser.endDocWriting();
        JPanel browserPanel = new JPanel(new BorderLayout());
        browserPanel.setBorder(new BevelBorder(1));
        JPanel browserAndToolPanel = new JPanel(new BorderLayout());
        JToolBar toolbar = new JToolBar();
        toolbar.setFloatable(false);
        JButton toggleBoldButton = new JButton("B");
        JButton toggleItalicButton = new JButton("I");
        JButton toggleUnderlineButton = new JButton("U");
        JButton insertHRButton = new JButton("HR");
        final JComboBox<String> fontNameCombo = new JComboBox<String>(GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames());
        final JComboBox<String> fontSizeCombo = new JComboBox<String>(new String[]{"-2", "-1", "+0", "+1", "+2", "+3", "+4", "+5"});
        JButton colorButton = new JButton("Color");
        fontNameCombo.setEditable(true);
        fontSizeCombo.setEditable(true);
        fontNameCombo.setSelectedItem("");
        fontSizeCombo.setSelectedItem("");
        toggleBoldButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ThreadContentsEditorView.this.browser.toggleBold();
            }
        });
        toggleItalicButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ThreadContentsEditorView.this.browser.toggleItalic();
            }
        });
        toggleUnderlineButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ThreadContentsEditorView.this.browser.toggleUnderLine();
            }
        });
        insertHRButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ThreadContentsEditorView.this.browser.insertHR();
            }
        });
        fontNameCombo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ThreadContentsEditorView.this.browser.setFontName((String)fontNameCombo.getSelectedItem());
            }
        });
        fontSizeCombo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ThreadContentsEditorView.this.browser.setFontSize((String)fontSizeCombo.getSelectedItem());
            }
        });
        colorButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Color color = JColorChooser.showDialog(ThreadContentsEditorView.this, "Color Chooser", Color.black);
                if (color == null) {
                    return;
                }
                String colorText = new Formatter().format("#%02x%02x%02x", color.getRed(), color.getGreen(), color.getBlue()).toString();
                ThreadContentsEditorView.this.browser.setColor(colorText);
            }
        });
        toolbar.add(toggleBoldButton);
        toolbar.add(toggleItalicButton);
        toolbar.add(toggleUnderlineButton);
        toolbar.add(insertHRButton);
        toolbar.addSeparator();
        toolbar.add(fontNameCombo);
        toolbar.addSeparator();
        toolbar.add(new JLabel("Size:"));
        toolbar.add(fontSizeCombo);
        toolbar.addSeparator();
        toolbar.add(colorButton);
        browserPanel.add(this.browser.getComponent(), "Center");
        browserAndToolPanel.add((Component)toolbar, "North");
        browserAndToolPanel.add((Component)browserPanel, "Center");
        tab.add("\u7de8\u96c6", browserAndToolPanel);
    }

    public ThreadContentsEditorView() {
        this.setLayout(new BorderLayout());
        this.htmlSourceView = new JTextArea();
        this.htmlSourceView.setLineWrap(true);
        this.tab = new JTabbedPane();
        this.threadTitleText = new JTextField();
        this.buildBrowserPanel(this.tab);
        this.tab.add("HTML", new JScrollPane(this.htmlSourceView));
        this.tab.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                if (ThreadContentsEditorView.this.browser != null) {
                    if (ThreadContentsEditorView.this.tab.getSelectedIndex() == 1) {
                        ThreadContentsEditorView.this.htmlSourceView.setText(ThreadContentsEditorView.this.browser.getBodyHtml());
                    } else {
                        ThreadContentsEditorView.this.browser.setBodyHtml(ThreadContentsEditorView.this.htmlSourceView.getText());
                    }
                }
            }
        });
        Box threadTitleBox = new Box(2){
            {
                this.setAlignmentX(0.0f);
                this.add(new JLabel("Title: "));
                this.add(ThreadContentsEditorView.this.threadTitleText);
            }
        };
        this.add((Component)threadTitleBox, "North");
        this.add((Component)this.tab, "Center");
        this.setVisible(true);
    }

    public void addNotify() {
        super.addNotify();
        if (this.browser == null) {
            return;
        }
        this.browser.setEditable(true);
        if (this.delayHtml != null) {
            this.browser.setBodyHtml(this.delayHtml);
        }
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
    }

    public String getThreadTitle() {
        return this.threadTitleText.getText();
    }

    public String getHtmlContent() {
        if (this.browser == null) {
            return this.htmlSourceView.getText();
        }
        if (this.tab.getSelectedIndex() == 0) {
            return this.browser.getBodyHtml();
        }
        return this.htmlSourceView.getText();
    }

    public void setHtmlContents(String html) {
        this.htmlSourceView.setText(html);
        this.delayHtml = html;
    }
}

