/*
 * Decompiled with CFR 0.152.
 */
package com.aibonware.viewnaver.server.servlet;

import Acme.Serve.servlet.ServletOutputStream;
import Acme.Serve.servlet.http.HttpServletRequest;
import Acme.Serve.servlet.http.HttpServletResponse;
import com.aibonware.viewnaver.model.Article;
import com.aibonware.viewnaver.model.ArticleList;
import com.aibonware.viewnaver.model.CompositeThread;
import com.aibonware.viewnaver.model.NThread;
import com.aibonware.viewnaver.server.MiniServer;
import com.aibonware.viewnaver.server.UserSession;
import com.aibonware.viewnaver.server.servlet.BaseServlet;
import com.aibonware.viewnaver.server.servlet.BoardServlet;
import com.aibonware.viewnaver.server.servlet.ConfirmDelServlet;
import com.aibonware.viewnaver.server.servlet.WriteReplyThreadServlet;
import java.text.SimpleDateFormat;

public class ThreadServlet
extends BaseServlet {
    private static SimpleDateFormat df = new SimpleDateFormat("MM/dd HH:mm");
    private static SimpleDateFormat tf = new SimpleDateFormat("HH:mm");

    public String getName() {
        return "thread";
    }

    public static String createUrl(UserSession user, String boardName, int nid, int start, boolean showAll) {
        String url = "thread?sid=" + user.sid + "&b=" + boardName + "&t=" + nid + "&s=" + start;
        if (showAll) {
            url = String.valueOf(url) + "&c=a";
        }
        return url;
    }

    public void dispContents(MiniServer server, UserSession user, HttpServletRequest request, HttpServletResponse response, ServletOutputStream out) throws Exception {
        String sNID = request.getParameter("t");
        String sStart = request.getParameter("s");
        String boardName = request.getParameter("b");
        boolean showAll = "a".equals(request.getParameter("c"));
        int nid = Integer.parseInt(sNID);
        int start = Integer.parseInt(sStart);
        CompositeThread compositeThread = user.getCachedThread(user, server.conv, boardName, nid, start);
        NThread thread = compositeThread.thread;
        ArticleList articles = compositeThread.articleList;
        out.println("<a name=\"top\">");
        int prevStart = start - server.articlesPerPage;
        int nextStart = start + server.articlesPerPage;
        if (prevStart < 0) {
            prevStart = 0;
        }
        if (nextStart >= articles.getArticleCount()) {
            nextStart = articles.getArticleCount();
        }
        if (showAll) {
            out.print("<a name=\"top\"></a>");
            out.print(String.valueOf(thread.title) + " ");
            out.print(String.valueOf(thread.country.toHtml()) + " ");
            out.print("<b>" + thread.poster + "</b> ");
            out.print(String.valueOf(df.format(thread.createDate)) + " ");
            out.println("[" + compositeThread.articleList.getArticleCount() + "]<br>");
            out.println(compositeThread.contents);
        } else {
            out.print("<a href=\"main?sid=" + user.sid + "\">\u5165\u53e3</a>");
            if (prevStart != start) {
                out.print("<a href=\"" + ThreadServlet.createUrl(user, boardName, nid, prevStart, false) + "\">\u524d</a>");
            }
            out.print("<a href=\"" + ThreadServlet.createUrl(user, boardName, nid, nextStart, false) + "\">\u6b21</a>");
            out.print("<a href=\"#bottom\">\u4e0b</a>");
            out.print("<a href=\"" + BoardServlet.createUrl(user, boardName, 1) + "\">\u677f</a>");
            out.print("<a href=\"" + WriteReplyThreadServlet.createUrl(user, compositeThread) + "\">\u8fd4</a>");
            out.print("<a href=\"" + ConfirmDelServlet.createUrl(user, boardName, nid, start) + "\">\u524a</a>");
            out.print(" <a href=\"logout?sid=" + user.sid + "\">\uff9b\uff78\uff9e\uff71\uff73\uff84</a>");
            out.println("<hr>");
            if (start == 0) {
                out.println(String.valueOf(thread.title) + " " + thread.country.toHtml() + " " + "<b>" + thread.poster + "</b> " + df.format(thread.createDate) + "[" + compositeThread.articleList.getArticleCount() + "]<br>");
                String link = "<b><a href=\"" + ThreadServlet.createUrl(user, boardName, nid, start, true) + "\">ALL(" + compositeThread.contents.length() + "\u5b57)</a></b>";
                String shortContents = server.conv.getShortContents(10, 200, compositeThread.contents, link);
                out.println(shortContents);
                out.println("<hr>");
            }
            int i = start;
            while (i < start + server.articlesPerPage) {
                if (i >= articles.getArticleCount()) break;
                Article art = articles.getArticle(i);
                out.print(i + 1 + ".");
                out.print(String.valueOf(art.country.toHtml()) + " ");
                out.print("<b>" + art.author + "</b> ");
                out.print(String.valueOf(tf.format(art.postDate)) + "<br>");
                if (art.isReply) {
                    out.print("\u2514");
                }
                out.println(art.content);
                out.print("<hr>");
                ++i;
            }
            out.println("<form method=post action=\"postart?sid=" + user.sid + "\">");
            out.println("<input type=\"hidden\" name=\"b\" value=\"" + boardName + "\">");
            out.println("<input type=\"hidden\" name=\"t\" value=\"" + nid + "\">");
            out.println("<textarea name=ArticleContent></textarea>");
            out.println("<input type=submit value=\"\uff9a\uff7d\">");
            out.println("</form>");
            out.print("<hr>");
            out.print("<a href=\"main?sid=" + user.sid + "\">\u5165\u53e3</a>");
            if (prevStart != start) {
                out.print("<a href=\"" + ThreadServlet.createUrl(user, boardName, nid, prevStart, false) + "\">\u524d</a>");
            }
            out.print("<a href=\"" + ThreadServlet.createUrl(user, boardName, nid, nextStart, false) + "\">\u6b21</a>");
            out.print("<a href=\"#top\">\u4e0a</a>");
            out.print("<a href=\"" + BoardServlet.createUrl(user, boardName, 1) + "\">\u677f</a>");
            out.print("<a href=\"" + WriteReplyThreadServlet.createUrl(user, compositeThread) + "\">\u8fd4</a>");
            out.print("<a href=\"" + ConfirmDelServlet.createUrl(user, boardName, nid, start) + "\">\u524a</a>");
            out.print(" <a href=\"logout?sid=" + user.sid + "\">\uff9b\uff78\uff9e\uff71\uff73\uff84</a>");
            out.println("<a name=\"bottom\">");
        }
    }
}

