/*
 * Decompiled with CFR 0.152.
 */
package com.aibonware.viewnaver.parser;

import com.aibonware.viewnaver.ViewNaver;
import com.aibonware.viewnaver.model.Country;
import com.aibonware.viewnaver.model.Message;
import com.aibonware.viewnaver.model.MessageTitle;
import com.aibonware.viewnaver.net.NetException;
import com.aibonware.viewnaver.parser.ParsingContext;
import com.aibonware.viewnaver.parser.ParsingException;
import java.io.BufferedReader;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class MessageParser {
    private final String urlString;
    private final MessageTitle messageTitle;
    private static SimpleDateFormat df = new SimpleDateFormat("yy-MM-dd HH:mm:ss");

    public MessageParser(MessageTitle messageTitle, String urlString) {
        this.messageTitle = messageTitle;
        this.urlString = urlString;
    }

    public Message parse() throws NetException, ParsingException {
        BufferedReader reader = ViewNaver.instance.naverSession.open(this.urlString, "UTF8");
        Message result = this.parse(reader);
        try {
            reader.close();
        }
        catch (IOException e) {
            throw new RuntimeException("URL\u30af\u30ed\u30fc\u30ba\u5931\u6557", e);
        }
        return result;
    }

    private String removeBlank(String src) {
        StringBuffer buf = new StringBuffer(src);
        while (buf.charAt(0) == '\t' || buf.charAt(0) == ' ') {
            buf.deleteCharAt(0);
        }
        while (buf.charAt(buf.length() - 1) == '\t' || buf.charAt(buf.length() - 1) == ' ') {
            buf.deleteCharAt(buf.length() - 1);
        }
        return buf.toString();
    }

    public Message parse(BufferedReader reader) throws ParsingException, NetException {
        ParsingContext ct = new ParsingContext(reader);
        try {
            ct.seek("<form");
            ct.seek("\u30e1\u30c3\u30bb\u30fc\u30b8");
            ct.seek("<span class");
            String dateText = ct.cut(">", "</span></td></tr>").trim();
            String countryText = ct.cut("http://static.naver.com/enjoyjapan/tbbs/img_09/ico_", ".gif").trim();
            String poster = ct.cut(">", "</b></td>").trim();
            ct.seek("<table");
            ct.seek("<table");
            ct.seek("ln15");
            String messageText = this.removeBlank(ct.cut(">", "</td>").trim());
            messageText = messageText.replace("<br />", "<br>");
            Date date = df.parse(dateText);
            Country country = countryText.equals("jpn") ? Country.JAPAN : (countryText.equals("kor") ? Country.KOREA : Country.UNKNOWN);
            return new Message(this.messageTitle.messageId, poster, country, date, messageText, this.messageTitle.title);
        }
        catch (ParseException e) {
            throw new ParsingException(e, ct.text.toString());
        }
    }
}

