/*
 * Decompiled with CFR 0.152.
 */
package com.aibonware.viewnaver.content.thread;

import com.aibonware.viewnaver.ViewNaver;
import com.aibonware.viewnaver.config.ThreadWindowConfig;
import com.aibonware.viewnaver.content.TabContainer;
import com.aibonware.viewnaver.content.TabContainerView;
import com.aibonware.viewnaver.content.TabContentCategory;
import com.aibonware.viewnaver.content.TabContentProxy;
import com.aibonware.viewnaver.content.TabContentView;
import com.aibonware.viewnaver.content.thread.ThreadContent;
import com.aibonware.viewnaver.content.thread.ThreadView;
import com.aibonware.viewnaver.model.CompositeThread;
import com.aibonware.viewnaver.task.GUITask;
import com.aibonware.viewnaver.task.TaskFlow;
import com.aibonware.viewnaver.task.WorkerTask;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ThreadContent
extends TabContentProxy<CompositeThread> {
    private final String dispName;
    private final String boardName;

    private static String titleToDispName(String poster, String title) {
        ThreadWindowConfig config = (ThreadWindowConfig)ViewNaver.instance.config.getAncestor("ThreadWindow");
        if (title.length() > config.maxThreadTabTitleLen) {
            title = String.valueOf(title.substring(0, config.maxThreadTabTitleLen)) + "..";
        }
        return String.valueOf(poster) + ":" + title;
    }

    public ThreadContent(CompositeThread target, String boardName) {
        super(target);
        this.boardName = boardName;
        this.dispName = ThreadContent.titleToDispName(target.thread.poster, target.thread.title);
    }

    public static ThreadClientContentCategory getCategory(String boardName, int nid, String poster, String title) {
        return new ThreadClientContentCategory(boardName, nid, ThreadContent.titleToDispName(poster, title));
    }

    public static ThreadClientContentCategory getCategory(String boardName, int nid) {
        return new ThreadClientContentCategory(boardName, nid, String.valueOf("thread:" + nid));
    }

    @Override
    public String getContentTitle() {
        return this.dispName;
    }

    @Override
    public TabContentCategory getCategory() {
        return new ThreadClientContentCategory(this.boardName, ((CompositeThread)this.target).thread.nid, this.dispName);
    }

    @Override
    public void replaceUpdatedContent(final TabContainer container, final TabContainerView containerView, TabContentView contentView) {
        TaskFlow taskFlow = ViewNaver.instance.taskFlowList.getThreadFlow(this.boardName, ((CompositeThread)this.target).thread.nid);
        taskFlow.addStatusReceiver(((ThreadView)contentView).createTaskStatusReceiver(taskFlow));
        taskFlow.execute(new WorkerTask(){

            public void exec() {
                CompositeThread thread = ViewNaver.instance.cache.getCompositeThread(ThreadContent.this.boardName, ((CompositeThread)ThreadContent.this.target).thread.nid, true);
                this.taskFlow.execute(new GUITask(this, thread, container, containerView){
                    final /* synthetic */ 3 this$1;
                    private final /* synthetic */ CompositeThread val$thread;
                    private final /* synthetic */ TabContainer val$container;
                    private final /* synthetic */ TabContainerView val$containerView;
                    {
                        this.this$1 = var1_1;
                        this.val$thread = compositeThread;
                        this.val$container = tabContainer;
                        this.val$containerView = tabContainerView;
                    }

                    public void exec() {
                        ThreadContent newContent = new ThreadContent(this.val$thread, ThreadContent.access$0(3.access$0(this.this$1)));
                        this.val$container.replace(3.access$0(this.this$1), newContent);
                        this.val$containerView.activate(newContent.getCategory());
                    }
                });
            }

            static /* synthetic */ ThreadContent access$0(3 var0) {
                return var0.ThreadContent.this;
            }
        });
    }

    private static class ThreadClientContentCategory
    implements TabContentCategory {
        private final String boardName;
        private final int nid;
        private final String dispName;
        static /* synthetic */ Class class$0;

        public ThreadClientContentCategory(String boardName, int nid, String dispName) {
            this.boardName = boardName;
            this.nid = nid;
            this.dispName = dispName;
        }

        public boolean equals(Object o) {
            if (!(o instanceof ThreadClientContentCategory)) {
                return false;
            }
            ThreadClientContentCategory dest = (ThreadClientContentCategory)o;
            if (!this.boardName.equals(dest.boardName)) {
                return false;
            }
            return this.nid == dest.nid;
        }

        public void createInitialContent(TabContainer container, TabContainerView containerView, TabContentView initialView) {
            TaskFlow taskFlow = ViewNaver.instance.taskFlowList.getThreadFlow(this.boardName, this.nid);
            taskFlow.addStatusReceiver(((ThreadView)initialView).createTaskStatusReceiver(taskFlow));
            taskFlow.execute(new WorkerTask(this, containerView, container){
                final /* synthetic */ ThreadClientContentCategory this$1;
                private final /* synthetic */ TabContainerView val$containerView;
                private final /* synthetic */ TabContainer val$container;
                {
                    this.this$1 = threadClientContentCategory;
                    this.val$containerView = tabContainerView;
                    this.val$container = tabContainer;
                }

                public void exec() {
                    CompositeThread newThread = ViewNaver.instance.cache.getCompositeThread(ThreadClientContentCategory.access$0(this.this$1), ThreadClientContentCategory.access$1(this.this$1), false);
                    if (newThread != null) {
                        ViewNaver.instance.cache.putCompositeThread(newThread);
                        ViewNaver.instance.threadStorage.storeThread(newThread);
                    }
                    this.taskFlow.execute(new GUITask(this, newThread, this.val$containerView, this.val$container){
                        final /* synthetic */ 1 this$2;
                        private final /* synthetic */ CompositeThread val$newThread;
                        private final /* synthetic */ TabContainerView val$containerView;
                        private final /* synthetic */ TabContainer val$container;
                        {
                            this.this$2 = var1_1;
                            this.val$newThread = compositeThread;
                            this.val$containerView = tabContainerView;
                            this.val$container = tabContainer;
                        }

                        public void exec() {
                            if (this.val$newThread == null) {
                                this.val$containerView.revertEmptyView(1.access$0(this.this$2));
                                return;
                            }
                            ThreadContent content = new ThreadContent(this.val$newThread, ThreadClientContentCategory.access$0(1.access$0(this.this$2)));
                            this.val$container.addContent(content);
                            this.val$containerView.activate(content.getCategory());
                        }
                    });
                }

                static /* synthetic */ ThreadClientContentCategory access$0(1 var0) {
                    return var0.this$1;
                }
            });
        }

        public String getCategoryName() {
            return this.dispName;
        }

        public int hashCode() {
            return this.boardName.hashCode() + this.nid;
        }

        public Class getContentClass() {
            return ThreadContent.class;
        }

        static /* synthetic */ String access$0(ThreadClientContentCategory threadClientContentCategory) {
            return threadClientContentCategory.boardName;
        }

        static /* synthetic */ int access$1(ThreadClientContentCategory threadClientContentCategory) {
            return threadClientContentCategory.nid;
        }
    }
}

