/*
 * Decompiled with CFR 0.152.
 */
package com.aibonware.viewnaver.content.localsearch;

import com.aibonware.viewnaver.ViewNaver;
import com.aibonware.viewnaver.browser.Browser;
import com.aibonware.viewnaver.browser.BrowserListener;
import com.aibonware.viewnaver.command.ShowThreadCommand;
import com.aibonware.viewnaver.content.TabContent;
import com.aibonware.viewnaver.content.TabContentCategory;
import com.aibonware.viewnaver.content.TabContentView;
import com.aibonware.viewnaver.content.localsearch.LocalFoundContent;
import com.aibonware.viewnaver.model.Article;
import com.aibonware.viewnaver.model.CompositeThread;
import com.aibonware.viewnaver.model.FilterType;
import com.aibonware.viewnaver.model.Poster;
import com.aibonware.viewnaver.storage.ThreadStorageWalker;
import com.aibonware.viewnaver.task.GUITask;
import com.aibonware.viewnaver.task.TaskCanceller;
import com.aibonware.viewnaver.task.TaskFlow;
import com.aibonware.viewnaver.task.TaskStatusReceiver;
import com.aibonware.viewnaver.task.WorkerTask;
import com.aibonware.viewnaver.view.LocalSearchType;
import com.aibonware.viewnaver.window.SearchLocalThreadDialog;
import com.aibonware.viewnaver.xml.BaseXMLReader;
import com.aibonware.viewnaver.xml.CompositeThreadReader;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.text.SimpleDateFormat;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import javax.swing.border.BevelBorder;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;

public class LocalFoundContentView
extends TabContentView {
    public Browser browser;
    private boolean mustCancel = false;
    private String SPAN;
    private String HR;
    private LocalFoundContent clientContent;
    private static SimpleDateFormat df = new SimpleDateFormat("MM/dd HH:mm");
    JButton searchThreadButton;
    JButton closeButton;
    AbstractAction searchThreadAction;
    private int count;
    private String curBoardName;

    public LocalFoundContentView(TabContentCategory category) {
        super(category);
        this.SPAN = ViewNaver.instance.getBrowserFactory().SPAN;
        this.HR = ViewNaver.instance.getBrowserFactory().HR;
        this.clientContent = null;
        this.searchThreadButton = new JButton();
        this.closeButton = new JButton("\u9589\u3058\u308b");
        this.searchThreadAction = new AbstractAction("\u691c\u7d22"){

            public void actionPerformed(ActionEvent e) {
                SearchLocalThreadDialog dialog = new SearchLocalThreadDialog(ViewNaver.instance.mainWindow, ((LocalFoundContentView)LocalFoundContentView.this).clientContent.category.keyword, ((LocalFoundContentView)LocalFoundContentView.this).clientContent.category.localSearchType);
                dialog.setVisible(true);
            }
        };
        this.count = 0;
        this.curBoardName = "";
        this.setLayout(new BorderLayout());
        this.browser = ViewNaver.instance.getBrowserFactory().createBrowser();
        this.browser.beginDocWriting();
        this.browser.writeDocHtml("<html><head><meta http-equiv=\"Content-Type\" content=\"text/html\"></head><body></body></html>");
        this.browser.endDocWriting();
        JPanel panel = new JPanel(new BorderLayout());
        panel.setBorder(new BevelBorder(1));
        panel.add(this.browser.getComponent());
        this.closeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                LocalFoundContentView.this.mustCancel = true;
                ViewNaver.instance.mainWindow.container.removeContent(LocalFoundContentView.this.clientContent);
            }
        });
        JToolBar toolbar = new JToolBar();
        toolbar.add(this.closeButton);
        this.searchThreadButton.setAction(this.searchThreadAction);
        toolbar.add(this.searchThreadButton);
        toolbar.setFloatable(false);
        this.add((Component)toolbar, "North");
        this.add((Component)panel, "Center");
        this.browser.addBrowserListener(new BrowserListener(){

            public boolean beforeNavigate(String url) {
                if (url.startsWith("thread:")) {
                    url = url.substring("thread:".length());
                    int dotPos = url.indexOf(46);
                    String boardName = url.substring(0, dotPos);
                    int nid = Integer.parseInt(url.substring(dotPos + 1));
                    TaskFlow taskFlow = ViewNaver.instance.taskFlowList.getThreadFlow(boardName, nid);
                    taskFlow.execute(new ShowThreadCommand(boardName, nid));
                }
                return false;
            }
        });
    }

    public TaskStatusReceiver createTaskStatusReceiver(final TaskFlow taskFlow) {
        return new TaskStatusReceiver(){

            public void statusChanged(int status) {
                if (status == 0) {
                    LocalFoundContentView.this.searchThreadButton.setAction(new AbstractAction(this, "\u4e2d\u6b62", taskFlow){
                        final /* synthetic */ 4 this$1;
                        private final /* synthetic */ TaskFlow val$taskFlow;
                        {
                            this.this$1 = var1_1;
                            this.val$taskFlow = taskFlow;
                            super($anonymous0);
                        }

                        public void actionPerformed(ActionEvent e) {
                            this.val$taskFlow.cancel();
                        }
                    });
                    LocalFoundContentView.this.closeButton.setEnabled(false);
                } else if (status == 1) {
                    LocalFoundContentView.this.searchThreadButton.setAction(LocalFoundContentView.this.searchThreadAction);
                    LocalFoundContentView.this.closeButton.setEnabled(true);
                }
            }
        };
    }

    public void setClientContent(TabContent content) {
        this.clientContent = (LocalFoundContent)content;
        final LocalSearchType localSearchType = this.clientContent.category.localSearchType;
        final String poster = this.clientContent.category.poster;
        final String keyword = this.clientContent.category.keyword;
        this.count = 0;
        this.curBoardName = null;
        this.browser.setBodyHtml("<font size=-1><" + this.SPAN + " id=\"hit:0\"></" + this.SPAN + "></font>");
        TaskFlow taskFlow = ViewNaver.instance.taskFlowList.getSearchLocalThreadFlow(localSearchType, poster, keyword);
        taskFlow.addStatusReceiver(this.createTaskStatusReceiver(taskFlow));
        taskFlow.execute(new WorkerTask(){

            public void exec() {
                TaskCanceller canceller = new TaskCanceller(this){
                    final /* synthetic */ 6 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void cancel() {
                        LocalFoundContentView.access$1(6.access$0(this.this$1), true);
                    }
                };
                this.taskFlow.addTaskCanceller(canceller);
                try {
                    try {
                        DocumentBuilderFactory dbfactory = DocumentBuilderFactory.newInstance();
                        DocumentBuilder builder = dbfactory.newDocumentBuilder();
                        CompositeThreadReader compositeThreadReader = new CompositeThreadReader();
                        ViewNaver.instance.threadStorage.flash();
                        ViewNaver.instance.threadStorage.walkFiles(new ThreadStorageWalker(this, poster, keyword, builder, compositeThreadReader, localSearchType){
                            final /* synthetic */ 6 this$1;
                            private final /* synthetic */ String val$poster;
                            private final /* synthetic */ String val$keyword;
                            private final /* synthetic */ DocumentBuilder val$builder;
                            private final /* synthetic */ CompositeThreadReader val$compositeThreadReader;
                            private final /* synthetic */ LocalSearchType val$localSearchType;
                            {
                                this.this$1 = var1_1;
                                this.val$poster = string;
                                this.val$keyword = string2;
                                this.val$builder = documentBuilder;
                                this.val$compositeThreadReader = compositeThreadReader;
                                this.val$localSearchType = localSearchType;
                            }

                            public void finished() {
                                ViewNaver.println("\u30ed\u30b0\u691c\u7d22\u5b8c\u4e86\u3002");
                            }

                            public void canceled() {
                                ViewNaver.println("\u30ed\u30b0\u691c\u7d22\u30ad\u30e3\u30f3\u30bb\u30eb\u3002");
                            }

                            public boolean walk(File file) {
                                try {
                                    String line;
                                    if (LocalFoundContentView.access$2(6.access$0(this.this$1))) {
                                        LocalFoundContentView.access$1(6.access$0(this.this$1), false);
                                        return false;
                                    }
                                    StringBuffer buf = new StringBuffer();
                                    BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF8"));
                                    while ((line = reader.readLine()) != null) {
                                        buf.append(line);
                                    }
                                    reader.close();
                                    String text = buf.toString();
                                    boolean preMatch = true;
                                    if (this.val$poster != null && !text.contains(this.val$poster)) {
                                        preMatch = false;
                                    }
                                    if (this.val$keyword != null && preMatch && !text.contains(this.val$keyword)) {
                                        preMatch = false;
                                    }
                                    if (!preMatch) {
                                        return true;
                                    }
                                    Document doc = this.val$builder.parse(new InputSource(new StringReader(text)));
                                    Element root = doc.getDocumentElement();
                                    Element threadElem = BaseXMLReader.getAttrElem(root, "CompositeThread");
                                    CompositeThread compositeThread = this.val$compositeThreadReader.parse(threadElem);
                                    if (this.val$localSearchType.equals((Object)((Object)LocalSearchType.SearchThreadTitle))) {
                                        if (this.val$poster != null && !this.val$poster.equals(compositeThread.thread.poster)) {
                                            return true;
                                        }
                                        if (this.val$keyword != null && !compositeThread.thread.title.contains(this.val$keyword)) {
                                            return true;
                                        }
                                        LocalFoundContentView.access$3(6.access$0(this.this$1), this.this$1.taskFlow, compositeThread);
                                    } else if (this.val$localSearchType.equals((Object)((Object)LocalSearchType.SearchThreadContent))) {
                                        if (this.val$poster != null && !this.val$poster.equals(compositeThread.thread.poster)) {
                                            return true;
                                        }
                                        if (this.val$keyword != null && !compositeThread.contents.contains(this.val$keyword)) {
                                            return true;
                                        }
                                        LocalFoundContentView.access$3(6.access$0(this.this$1), this.this$1.taskFlow, compositeThread);
                                    } else {
                                        int artNum = compositeThread.articleList.getArticleCount();
                                        int i = artNum - 1;
                                        while (i >= 0) {
                                            Article art = compositeThread.articleList.getArticle(i);
                                            if ((this.val$poster == null || this.val$poster.equals(art.author)) && (this.val$keyword == null || art.content.contains(this.val$keyword))) {
                                                LocalFoundContentView.access$4(6.access$0(this.this$1), this.this$1.taskFlow, compositeThread, art, this.val$keyword);
                                            }
                                            --i;
                                        }
                                    }
                                    return true;
                                }
                                catch (Exception e) {
                                    ViewNaver.err(e);
                                    return false;
                                }
                            }
                        });
                    }
                    catch (Exception e) {
                        ViewNaver.err(e);
                    }
                }
                finally {
                    this.taskFlow.removeTaskCanceller(canceller);
                }
            }

            static /* synthetic */ LocalFoundContentView access$0(6 var0) {
                return var0.LocalFoundContentView.this;
            }
        });
    }

    private void addBoardName(String name) {
        ++this.count;
        this.browser.insertBodyHtml("hit:" + (this.count - 1), String.valueOf(this.HR) + "<" + this.SPAN + " id=\"hit:" + this.count + "\">" + name + "\uff1a<br><br>\n</" + this.SPAN + ">");
    }

    private void addThreadHit(TaskFlow taskFlow, final CompositeThread compositeThread) {
        FilterType filterType = ViewNaver.instance.config.filterConfig.filters.get(new Poster(compositeThread.thread.poster, compositeThread.thread.country));
        if (filterType != null) {
            return;
        }
        taskFlow.execute(new GUITask(){

            public void exec() {
                if (!compositeThread.boardName.equals(LocalFoundContentView.this.curBoardName)) {
                    LocalFoundContentView.this.curBoardName = compositeThread.boardName;
                    LocalFoundContentView.this.addBoardName(LocalFoundContentView.this.curBoardName);
                }
                LocalFoundContentView localFoundContentView = LocalFoundContentView.this;
                localFoundContentView.count = localFoundContentView.count + 1;
                LocalFoundContentView.this.browser.insertBodyHtml("hit:" + (LocalFoundContentView.this.count - 1), "<" + LocalFoundContentView.this.SPAN + " id=\"hit:" + LocalFoundContentView.this.count + "\">" + "<a href=\"thread:" + compositeThread.boardName + "." + compositeThread.thread.nid + "\">" + compositeThread.thread.dispId + "</a> " + df.format(compositeThread.thread.createDate) + " " + compositeThread.thread.country.toHtml() + " " + " <b>" + compositeThread.thread.poster + "</b> " + ViewNaver.htmlToStr(compositeThread.thread.title) + "<br><br>\n</" + LocalFoundContentView.this.SPAN + ">");
            }
        });
    }

    private void addArticleHit(TaskFlow taskFlow, final CompositeThread compositeThread, final Article article, final String keyword) {
        FilterType filterType = ViewNaver.instance.config.filterConfig.filters.get(new Poster(compositeThread.thread.poster, compositeThread.thread.country));
        if (filterType != null) {
            return;
        }
        taskFlow.execute(new GUITask(){

            public void exec() {
                if (!compositeThread.boardName.equals(LocalFoundContentView.this.curBoardName)) {
                    LocalFoundContentView.this.curBoardName = compositeThread.boardName;
                    LocalFoundContentView.this.addBoardName(LocalFoundContentView.this.curBoardName);
                }
                LocalFoundContentView localFoundContentView = LocalFoundContentView.this;
                localFoundContentView.count = localFoundContentView.count + 1;
                String articleContent = ViewNaver.htmlToStr(article.content);
                if (keyword != null) {
                    articleContent = articleContent.replace(keyword, "<b>" + keyword + "</b>");
                }
                LocalFoundContentView.this.browser.insertBodyHtml("hit:" + (LocalFoundContentView.this.count - 1), "<" + LocalFoundContentView.this.SPAN + " id=\"hit:" + LocalFoundContentView.this.count + "\">" + "<a href=\"thread:" + compositeThread.boardName + "." + compositeThread.thread.nid + "\">" + compositeThread.thread.dispId + "</a> " + df.format(article.postDate) + " " + article.country.toHtml() + " " + " " + article.author + " " + articleContent + "<br><br>\n</" + LocalFoundContentView.this.SPAN + ">");
            }
        });
    }

    static /* synthetic */ boolean access$2(LocalFoundContentView localFoundContentView) {
        return localFoundContentView.mustCancel;
    }

    static /* synthetic */ void access$3(LocalFoundContentView localFoundContentView, TaskFlow taskFlow, CompositeThread compositeThread) {
        localFoundContentView.addThreadHit(taskFlow, compositeThread);
    }

    static /* synthetic */ void access$4(LocalFoundContentView localFoundContentView, TaskFlow taskFlow, CompositeThread compositeThread, Article article, String string) {
        localFoundContentView.addArticleHit(taskFlow, compositeThread, article, string);
    }
}

