/*
 * Decompiled with CFR 0.152.
 */
package com.aibonware.viewnaver.content.board;

import com.aibonware.viewnaver.ViewNaver;
import com.aibonware.viewnaver.config.ThreadListConfig;
import com.aibonware.viewnaver.content.TabContentCategory;
import com.aibonware.viewnaver.content.board.BaseBoardView;
import com.aibonware.viewnaver.content.board.BoardContent;
import com.aibonware.viewnaver.model.Board;
import com.aibonware.viewnaver.model.BoardTitle;
import com.aibonware.viewnaver.task.GUITask;
import com.aibonware.viewnaver.task.TaskFlow;
import com.aibonware.viewnaver.task.TaskStatusReceiver;
import com.aibonware.viewnaver.task.WorkerTask;
import com.aibonware.viewnaver.window.PostThreadWindow;
import com.aibonware.viewnaver.window.SearchRemoteThreadDialog;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.JButton;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BoardView
extends BaseBoardView<Board> {
    JButton updateButton = new JButton("\u66f4\u65b0");
    JButton newThreadButton = new JButton("\u65b0\u898f\uff7d\uff9a");
    JButton searchThreadButton = new JButton();
    AbstractAction updateAction = new AbstractAction("\u66f4\u65b0"){

        public void actionPerformed(ActionEvent e) {
            int newPageNo = BoardView.this.getSpecifiedPageNo();
            if (newPageNo < 1) {
                ViewNaver.println("\u4e0d\u6b63\u306a\u30da\u30fc\u30b8\u756a\u53f7\u3067\u3059\u3002");
                return;
            }
            BoardView.this.loadNewPage(BoardView.this.board, newPageNo, true);
        }
    };

    public BoardView(TabContentCategory category) {
        super(category);
        this.updateButton.setAction(this.updateAction);
        this.newThreadButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (!ViewNaver.instance.naverSession.nowLogin()) {
                    ViewNaver.println("\u30ed\u30b0\u30a4\u30f3\u3057\u3066\u3044\u307e\u305b\u3093\u3002");
                    return;
                }
                PostThreadWindow postThreadWindow = new PostThreadWindow(ViewNaver.instance.mainWindow, BoardView.this.board.boardName);
                postThreadWindow.setVisible(true);
            }
        });
        this.searchThreadButton.setAction(new AbstractAction("\u691c\u7d22"){

            public void actionPerformed(ActionEvent e) {
                if (!ViewNaver.instance.naverSession.nowLogin()) {
                    ViewNaver.println("\u30ed\u30b0\u30a4\u30f3\u3057\u3066\u3044\u307e\u305b\u3093\u3002");
                    return;
                }
                BoardContent.BoardClientContentCategory boardCategory = (BoardContent.BoardClientContentCategory)BoardView.this.category;
                SearchRemoteThreadDialog dialog = new SearchRemoteThreadDialog(ViewNaver.instance.mainWindow, new BoardTitle(boardCategory.boardName, boardCategory.dispName));
                dialog.setVisible(true);
            }
        });
        this.toolbar.add((Component)this.updateButton, 0);
        this.toolbar.add(this.newThreadButton);
        this.toolbar.addSeparator();
        this.toolbar.add(this.searchThreadButton);
    }

    public TaskStatusReceiver createTaskStatusReceiver(final TaskFlow taskFlow) {
        return new TaskStatusReceiver(){

            public void statusChanged(int status) {
                if (status == 0) {
                    BoardView.this.updateButton.setAction(new AbstractAction(this, "\u4e2d\u6b62", taskFlow){
                        final /* synthetic */ 4 this$1;
                        private final /* synthetic */ TaskFlow val$taskFlow;
                        {
                            this.this$1 = var1_1;
                            this.val$taskFlow = taskFlow;
                            super($anonymous0);
                        }

                        public void actionPerformed(ActionEvent e) {
                            this.val$taskFlow.cancel();
                        }
                    });
                    BoardView.this.newThreadButton.setEnabled(false);
                    BoardView.this.prevButton.setEnabled(false);
                    BoardView.this.nextButton.setEnabled(false);
                    BoardView.this.closeButton.setEnabled(false);
                } else if (status == 1) {
                    BoardView.this.updateButton.setAction(BoardView.this.updateAction);
                    BoardView.this.newThreadButton.setEnabled(true);
                    BoardView.this.prevButton.setEnabled(true);
                    BoardView.this.nextButton.setEnabled(true);
                    BoardView.this.closeButton.setEnabled(true);
                }
            }
        };
    }

    @Override
    protected void loadNewPage(final Board oldboard, final int pageNo, final boolean forceUpdate) {
        TaskFlow taskFlow = ViewNaver.instance.taskFlowList.getBoardFlow(oldboard.boardName, pageNo);
        taskFlow.addStatusReceiver(this.createTaskStatusReceiver(taskFlow));
        taskFlow.execute(new WorkerTask(){

            public void exec() {
                Board board = ViewNaver.instance.cache.getBoard(oldboard.boardName, pageNo, forceUpdate);
                if (board == null) {
                    return;
                }
                this.taskFlow.execute(new GUITask(this, board){
                    final /* synthetic */ 6 this$1;
                    private final /* synthetic */ Board val$board;
                    {
                        this.this$1 = var1_1;
                        this.val$board = board;
                    }

                    public void exec() {
                        ViewNaver.instance.mainWindow.containerView.update(new BoardContent(this.val$board));
                    }
                });
            }
        });
    }

    @Override
    protected ThreadListConfig getConfig() {
        return ViewNaver.instance.config.boardConfig;
    }
}

