/*
 * Decompiled with CFR 0.152.
 */
package com.aibonware.viewnaver.content.board;

import com.aibonware.viewnaver.ViewNaver;
import com.aibonware.viewnaver.content.TabContainer;
import com.aibonware.viewnaver.content.TabContainerView;
import com.aibonware.viewnaver.content.TabContentCategory;
import com.aibonware.viewnaver.content.TabContentView;
import com.aibonware.viewnaver.content.board.BaseBoardContent;
import com.aibonware.viewnaver.content.board.BoardContent;
import com.aibonware.viewnaver.content.board.BoardView;
import com.aibonware.viewnaver.model.Board;
import com.aibonware.viewnaver.model.BoardTitle;
import com.aibonware.viewnaver.task.GUITask;
import com.aibonware.viewnaver.task.TaskFlow;
import com.aibonware.viewnaver.task.WorkerTask;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BoardContent
extends BaseBoardContent<Board> {
    public BoardContent(Board board) {
        super(board);
    }

    @Override
    public String getContentTitle() {
        return ((Board)this.target).dispName;
    }

    @Override
    public TabContentCategory getCategory() {
        return BoardContent.getCategory(((Board)this.target).boardName);
    }

    public static TabContentCategory getCategory(String boardName) {
        BoardTitle board = ViewNaver.instance.boardTitles.getBoardTitle(boardName);
        if (board == null) {
            return new BoardClientContentCategory(boardName, boardName);
        }
        return new BoardClientContentCategory(boardName, board.dispName);
    }

    @Override
    public void replaceUpdatedContent(final TabContainer container, final TabContainerView containerView, TabContentView contentView) {
        TaskFlow taskFlow = ViewNaver.instance.taskFlowList.getBoardFlow(((Board)this.target).boardName, ((Board)this.target).pageNo);
        taskFlow.addStatusReceiver(((BoardView)contentView).createTaskStatusReceiver(taskFlow));
        taskFlow.execute(new WorkerTask(){

            public void exec() {
                Board newBoard = ViewNaver.instance.cache.getBoard(((Board)BoardContent.this.target).boardName, ((Board)BoardContent.this.target).pageNo, true);
                this.taskFlow.execute(new GUITask(this, newBoard, container, containerView){
                    final /* synthetic */ 3 this$1;
                    private final /* synthetic */ Board val$newBoard;
                    private final /* synthetic */ TabContainer val$container;
                    private final /* synthetic */ TabContainerView val$containerView;
                    {
                        this.this$1 = var1_1;
                        this.val$newBoard = board;
                        this.val$container = tabContainer;
                        this.val$containerView = tabContainerView;
                    }

                    public void exec() {
                        if (this.val$newBoard != null) {
                            BoardContent newContent = new BoardContent(this.val$newBoard);
                            this.val$container.replace(3.access$0(this.this$1), newContent);
                            this.val$containerView.activate(newContent.getCategory());
                        }
                    }
                });
            }

            static /* synthetic */ BoardContent access$0(3 var0) {
                return var0.BoardContent.this;
            }
        });
    }

    static class BoardClientContentCategory
    implements TabContentCategory {
        public final String boardName;
        public final String dispName;
        static /* synthetic */ Class class$0;

        public BoardClientContentCategory(String boardName, String dispName) {
            this.boardName = boardName;
            this.dispName = dispName;
        }

        public boolean equals(Object o) {
            if (!(o instanceof BoardClientContentCategory)) {
                return false;
            }
            BoardClientContentCategory dest = (BoardClientContentCategory)o;
            return this.boardName.equals(dest.boardName);
        }

        public void createInitialContent(TabContainer container, TabContainerView containerView, TabContentView initialView) {
            TaskFlow taskFlow = ViewNaver.instance.taskFlowList.getBoardFlow(this.boardName, 1);
            taskFlow.addStatusReceiver(((BoardView)initialView).createTaskStatusReceiver(taskFlow));
            taskFlow.execute(new WorkerTask(this, containerView, container){
                final /* synthetic */ BoardClientContentCategory this$1;
                private final /* synthetic */ TabContainerView val$containerView;
                private final /* synthetic */ TabContainer val$container;
                {
                    this.this$1 = boardClientContentCategory;
                    this.val$containerView = tabContainerView;
                    this.val$container = tabContainer;
                }

                public void exec() {
                    Board board = ViewNaver.instance.cache.getBoard(this.this$1.boardName, 1, true);
                    this.taskFlow.execute(new GUITask(this, board, this.val$containerView, this.val$container){
                        final /* synthetic */ 1 this$2;
                        private final /* synthetic */ Board val$board;
                        private final /* synthetic */ TabContainerView val$containerView;
                        private final /* synthetic */ TabContainer val$container;
                        {
                            this.this$2 = var1_1;
                            this.val$board = board;
                            this.val$containerView = tabContainerView;
                            this.val$container = tabContainer;
                        }

                        public void exec() {
                            if (this.val$board == null) {
                                this.val$containerView.revertEmptyView(1.access$0(this.this$2));
                                return;
                            }
                            BoardContent content = new BoardContent(this.val$board);
                            this.val$container.addContent(content);
                            this.val$containerView.activate(content.getCategory());
                        }
                    });
                }

                static /* synthetic */ BoardClientContentCategory access$0(1 var0) {
                    return var0.this$1;
                }
            });
        }

        public String getCategoryName() {
            return this.dispName;
        }

        public int hashCode() {
            return this.boardName.hashCode();
        }

        public Class getContentClass() {
            return BoardContent.class;
        }
    }
}

