/*
 * Decompiled with CFR 0.152.
 */
package com.aibonware.viewnaver.content;

import com.aibonware.viewnaver.content.TabContainerListener;
import com.aibonware.viewnaver.content.TabContent;
import com.aibonware.viewnaver.content.TabContentCategory;
import com.aibonware.viewnaver.content.TabContentOrder;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TabContainer {
    private Vector<TabContent> children = new Vector();
    private Vector<TabContainerListener> listeners = new Vector();
    public TabContentOrder comparator;

    public TabContainer(TabContentOrder comparator) {
        this.comparator = comparator;
    }

    public int getInsertPosition(Class<? extends TabContent> dest) {
        int i = 0;
        while (i < this.children.size()) {
            TabContent src = this.children.elementAt(i);
            int comp = this.comparator.compare(src.getClass(), dest);
            if (comp > 0) {
                return i;
            }
            ++i;
        }
        return this.children.size();
    }

    public void addContent(TabContent content) {
        int pos = this.getInsertPosition(content.getClass());
        this.children.insertElementAt(content, pos);
        int i = 0;
        while (i < this.listeners.size()) {
            this.listeners.elementAt(i).added(content, pos);
            ++i;
        }
    }

    public void removeContent(TabContent content) {
        this.children.removeElement(content);
        int i = 0;
        while (i < this.listeners.size()) {
            this.listeners.elementAt(i).removed(content);
            ++i;
        }
    }

    public void replace(TabContent oldContent, TabContent newContent) {
        this.children.set(this.children.indexOf(oldContent), newContent);
        int i = 0;
        while (i < this.listeners.size()) {
            this.listeners.elementAt(i).replaced(oldContent, newContent);
            ++i;
        }
    }

    public int getContentCount() {
        return this.children.size();
    }

    public int getContentIndex(TabContentCategory category) {
        int i = 0;
        while (i < this.children.size()) {
            if (this.children.elementAt(i).getCategory().equals(category)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public TabContent getContent(int index) {
        return this.children.elementAt(index);
    }

    public void addListener(TabContainerListener listener) {
        this.listeners.addElement(listener);
    }

    public void removeListener(TabContainerListener listener) {
        this.listeners.removeElement(listener);
    }

    public TabContent getContentByCategory(TabContentCategory category) {
        int i = 0;
        while (i < this.children.size()) {
            TabContent child = this.children.elementAt(i);
            if (category.equals(child.getCategory())) {
                return child;
            }
            ++i;
        }
        return null;
    }
}

