/*
 * Decompiled with CFR 0.152.
 */
package com.aibonware.viewnaver.config;

import com.aibonware.viewnaver.config.Config;
import com.aibonware.viewnaver.config.ConfigException;
import com.aibonware.viewnaver.config.ConfigItem;
import com.aibonware.viewnaver.config.ConfigItemView;
import com.aibonware.viewnaver.model.Country;
import com.aibonware.viewnaver.model.FilterType;
import com.aibonware.viewnaver.model.Poster;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JButton;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class FilterConfig
extends ConfigItem {
    public Map<Poster, FilterType> filters = new TreeMap<Poster, FilterType>();

    public FilterConfig() {
        super("FilterList");
        this.loadConfig(null);
    }

    public void loadConfig(Element elem) {
        this.filters = new TreeMap<Poster, FilterType>();
        if (elem == null) {
            return;
        }
        NodeList children = elem.getElementsByTagName("Filter");
        int i = 0;
        while (i < children.getLength()) {
            Element filterElem = (Element)children.item(i);
            Poster poster = Config.getPosterConfig(filterElem, "Poster");
            String filterTypeName = Config.getStringConfig(filterElem, "FilterType", FilterType.Visible.name());
            FilterType filterType = FilterType.valueOf(filterTypeName);
            this.filters.put(poster, filterType);
            ++i;
        }
    }

    public void saveConfig(Element elem) {
        NodeList children = elem.getElementsByTagName("Filter");
        int i = 0;
        while (i < children.getLength()) {
            elem.removeChild(children.item(i));
            ++i;
        }
        for (Poster poster : this.filters.keySet()) {
            Document doc = elem.getOwnerDocument();
            Element filterElem = doc.createElement("Filter");
            elem.appendChild(filterElem);
            Config.setPosterConfig(filterElem, "Poster", poster);
            Config.setStringConfig(filterElem, "FilterType", this.filters.get(poster).name());
        }
    }

    public String getDispPath() {
        return "\u57fa\u672c.\uff8c\uff68\uff99\uff80\uff98\uff9d\uff78\uff9e";
    }

    public ConfigItemView getView() {
        return new FilterConfigView();
    }

    private static class FilterConfigView
    extends ConfigItemView {
        JTable table;
        JButton deleteButton;
        private FilterConfig filterConfig;
        private DefaultTableModel tableModel = new DefaultTableModel(new Object[]{"Country", "Poster", "Type"}, 0);

        public FilterConfigView() {
            this.table = new JTable(this.tableModel);
            this.deleteButton = new JButton("\u524a\u9664");
            this.addLine(FilterConfigView.glue(this.table.getTableHeader()), this.newline(0), FilterConfigView.glue(this.table), "\n", FilterConfigView.glue(), this.deleteButton);
            this.deleteButton.addActionListener(new ActionListener(this){
                final /* synthetic */ FilterConfigView this$1;
                {
                    this.this$1 = filterConfigView;
                }

                public void actionPerformed(ActionEvent e) {
                    int row = this.this$1.table.getSelectedRow();
                    if (row < 0) {
                        return;
                    }
                    FilterConfigView.access$0(this.this$1).removeRow(row);
                }
            });
        }

        public void setConfig(ConfigItem config) {
            this.filterConfig = (FilterConfig)config;
            for (Poster poster : this.filterConfig.filters.keySet()) {
                FilterType filterType = this.filterConfig.filters.get(poster);
                this.tableModel.addRow(new Object[]{poster.country, poster.name, filterType});
            }
        }

        public void applyConfig() throws ConfigException {
            this.filterConfig.filters.clear();
            int i = 0;
            while (i < this.tableModel.getRowCount()) {
                Country country = (Country)((Object)this.tableModel.getValueAt(i, 0));
                String name = (String)this.tableModel.getValueAt(i, 1);
                FilterType filterType = (FilterType)((Object)this.tableModel.getValueAt(i, 2));
                this.filterConfig.filters.put(new Poster(name, country), filterType);
                ++i;
            }
        }

        static /* synthetic */ DefaultTableModel access$0(FilterConfigView filterConfigView) {
            return filterConfigView.tableModel;
        }
    }
}

