/*
 * Decompiled with CFR 0.152.
 */
package com.aibonware.viewnaver.config;

import com.aibonware.viewnaver.config.ConfigException;
import com.aibonware.viewnaver.config.ConfigItemView;
import java.util.Vector;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ConfigItem
implements Cloneable {
    public final String configName;
    protected Vector<ConfigItem> children = new Vector();

    public ConfigItem(String configName) {
        this.configName = configName;
    }

    public void addChild(ConfigItem config) {
        this.children.addElement(config);
    }

    public ConfigItem getChild(int index) {
        return this.children.elementAt(index);
    }

    public int getChildCount() {
        return this.children.size();
    }

    public ConfigItem cloneTree() {
        ConfigItem config = this.cloneThis();
        int i = 0;
        while (i < this.children.size()) {
            config.addChild(this.children.elementAt(i).cloneThis());
            ++i;
        }
        return config;
    }

    public void validateTree() throws ConfigException {
        this.validateThis();
        int i = 0;
        while (i < this.children.size()) {
            this.children.elementAt(i).validateThis();
            ++i;
        }
    }

    public void loadConfigTree(Element elem) {
        this.loadConfig(elem);
        int i = 0;
        while (i < this.children.size()) {
            ConfigItem childConfig = this.children.elementAt(i);
            if (elem != null) {
                NodeList childElements = elem.getElementsByTagName(childConfig.configName);
                if (childElements.getLength() == 0) {
                    childConfig.loadConfigTree(null);
                } else {
                    childConfig.loadConfigTree((Element)childElements.item(0));
                }
            } else {
                childConfig.loadConfigTree(null);
            }
            ++i;
        }
    }

    public void saveConfigTree(Element elem) {
        this.saveConfig(elem);
        int i = 0;
        while (i < this.children.size()) {
            Element childElem;
            ConfigItem childConfig = this.children.elementAt(i);
            NodeList childElements = elem.getElementsByTagName(childConfig.configName);
            if (childElements.getLength() == 0) {
                childElem = elem.getOwnerDocument().createElement(childConfig.configName);
                elem.appendChild(childElem);
            } else {
                childElem = (Element)childElements.item(0);
            }
            childConfig.saveConfigTree(childElem);
            ++i;
        }
    }

    protected ConfigItem getChildByName(String childName) {
        int i = 0;
        while (i < this.children.size()) {
            ConfigItem child = this.children.elementAt(i);
            if (child.configName.equals(childName)) {
                return child;
            }
            ++i;
        }
        return null;
    }

    public void validateThis() throws ConfigException {
    }

    public void loadConfig(Element elem) {
    }

    public void saveConfig(Element elem) {
    }

    public String getDispPath() {
        return null;
    }

    public ConfigItemView getView() {
        return null;
    }

    public ConfigItem cloneThis() {
        try {
            ConfigItem obj = (ConfigItem)this.clone();
            obj.children = new Vector();
            return obj;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }
}

