/*
 * Decompiled with CFR 0.152.
 */
package com.aibonware.viewnaver.config;

import com.aibonware.viewnaver.config.Config;
import com.aibonware.viewnaver.config.ConfigException;
import com.aibonware.viewnaver.config.ConfigItem;
import com.aibonware.viewnaver.config.ConfigItemView;
import java.awt.Dimension;
import javax.swing.JTextField;
import org.w3c.dom.Element;

public class CapacityConfig
extends ConfigItem {
    public int maxBoardPageCache = 10;
    public int maxCompositeThreadCache = 300;
    public int maxStorageThreads = 1000;

    public CapacityConfig() {
        super("Capacity");
        this.loadConfig(null);
    }

    public void loadConfig(Element elem) {
        this.maxBoardPageCache = Config.getIntConfig(elem, "MaxBoardPageCache", 10);
        this.maxCompositeThreadCache = Config.getIntConfig(elem, "MaxCompositeThreadCache", 300);
        this.maxStorageThreads = Config.getIntConfig(elem, "MaxStorageThreads", 1000);
    }

    public void saveConfig(Element elem) {
        Config.setIntConfig(elem, "MaxBoardPageCache", this.maxBoardPageCache);
        Config.setIntConfig(elem, "MaxCompositeThreadCache", this.maxCompositeThreadCache);
        Config.setIntConfig(elem, "MaxStorageThreads", this.maxStorageThreads);
    }

    public String getDispPath() {
        return "\u5bb9\u91cf";
    }

    public ConfigItemView getView() {
        return new CapacityConfigView();
    }

    private static class CapacityConfigView
    extends ConfigItemView {
        JTextField maxBoardPageCacheText;
        JTextField maxCompositeThreadCacheText;
        JTextField maxStorageThreadsText;
        private CapacityConfig capacityConfig;

        public CapacityConfigView() {
            Dimension maxTextFieldSize = new Dimension(1000, 20);
            this.maxBoardPageCacheText = new JTextField();
            this.maxBoardPageCacheText.setMaximumSize(maxTextFieldSize);
            this.maxCompositeThreadCacheText = new JTextField();
            this.maxCompositeThreadCacheText.setMaximumSize(maxTextFieldSize);
            this.maxStorageThreadsText = new JTextField();
            this.maxStorageThreadsText.setMinimumSize(maxTextFieldSize);
            this.addLine("\u677f\u3054\u3068\u306e\u30ad\u30e3\u30c3\u30b7\u30e5\u30da\u30fc\u30b8\u6570\uff1a\t", CapacityConfigView.glue(this.maxBoardPageCacheText), "\n", "\u677f\u3054\u3068\u306e\u30b9\u30ec\u30c3\u30c9\u5185\u5bb9\u30ad\u30e3\u30c3\u30b7\u30e5\u30b9\u30ec\u30c3\u30c9\u6570\uff1a\t", CapacityConfigView.glue(this.maxCompositeThreadCacheText), "\n", "\u677f\u3054\u3068\u306e\u30b9\u30ec\u30c3\u30c9\u30ed\u30b0\u4fdd\u7ba1\u6570\uff1a\t", CapacityConfigView.glue(this.maxStorageThreadsText));
        }

        public void setConfig(ConfigItem config) {
            this.capacityConfig = (CapacityConfig)config;
            this.maxBoardPageCacheText.setText(String.valueOf(this.capacityConfig.maxBoardPageCache));
            this.maxCompositeThreadCacheText.setText(String.valueOf(this.capacityConfig.maxCompositeThreadCache));
            this.maxStorageThreadsText.setText(String.valueOf(this.capacityConfig.maxStorageThreads));
        }

        public void applyConfig() throws ConfigException {
            try {
                this.capacityConfig.maxBoardPageCache = Integer.parseInt(this.maxBoardPageCacheText.getText());
                this.capacityConfig.maxCompositeThreadCache = Integer.parseInt(this.maxCompositeThreadCacheText.getText());
                this.capacityConfig.maxStorageThreads = Integer.parseInt(this.maxStorageThreadsText.getText());
            }
            catch (NumberFormatException e) {
                throw new ConfigException("\u6570\u5024\u3092\u6307\u5b9a\u3057\u3066\u304f\u3060\u3055\u3044\u3002");
            }
        }
    }
}

