/*
 * Decompiled with CFR 0.152.
 */
package com.aibonware.viewnaver.command;

import com.aibonware.viewnaver.ViewNaver;
import com.aibonware.viewnaver.command.PosterSelection;
import com.aibonware.viewnaver.command.PosterSelectionListener;
import com.aibonware.viewnaver.content.TabContentView;
import com.aibonware.viewnaver.model.FilterType;
import com.aibonware.viewnaver.model.IDJitenList;
import com.aibonware.viewnaver.model.Poster;
import com.aibonware.viewnaver.window.IDJitenWindow;
import com.aibonware.viewnaver.window.WriteMessageWindow;
import java.awt.Container;
import java.awt.Window;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

public class PosterMenuItemCreator {
    private Window searchParentWindow(Container container) {
        while (!((container = container.getParent()) instanceof Window)) {
        }
        return (Window)container;
    }

    public void addPosterMenuItems(final TabContentView contentView, final PosterSelection posterSelection, JPopupMenu popup) {
        JMenuItem sendMessageMenu = new JMenuItem(new AbstractAction("\u30e1\u30c3\u30bb\u30fc\u30b8\u9001\u4fe1"){

            public void actionPerformed(ActionEvent e) {
                Poster poster = posterSelection.getCurrentPoster();
                if (poster == null) {
                    return;
                }
                WriteMessageWindow messageWindow = new WriteMessageWindow(ViewNaver.instance.mainWindow, poster.name, poster.country, "");
                messageWindow.setVisible(true);
            }
        });
        final JMenuItem idJitenMenu = new JMenuItem(new AbstractAction("ID\u8f9e\u5178..."){

            public void actionPerformed(ActionEvent e) {
                Poster poster = posterSelection.getCurrentPoster();
                if (poster == null) {
                    return;
                }
                IDJitenList idJiten = ViewNaver.instance.idJiten;
                if (idJiten == null) {
                    return;
                }
                String explain = idJiten.getExplain(poster);
                if (explain != null) {
                    IDJitenWindow idwindow = IDJitenWindow.createIDJitenWindow(PosterMenuItemCreator.this.searchParentWindow(contentView), poster.name, explain);
                    idwindow.setLocation(100, 100);
                    idwindow.setVisible(true);
                }
            }
        });
        JMenuItem favMenu = new JMenuItem(new AbstractAction("\u304a\u6c17\u306b\u5165\u308aID\u306b\u8ffd\u52a0"){

            public void actionPerformed(ActionEvent e) {
                Poster poster = posterSelection.getCurrentPoster();
                if (poster == null) {
                    return;
                }
                ViewNaver.instance.config.favoritePersonConfig.persons.add(poster);
                contentView.refreshContent();
            }
        });
        JMenuItem filterMenu = new JMenuItem(new AbstractAction("\uff8c\uff68\uff99\uff80\uff98\uff9d\uff78\uff9e"){

            public void actionPerformed(ActionEvent e) {
                Poster poster = posterSelection.getCurrentPoster();
                if (poster == null) {
                    return;
                }
                ViewNaver.instance.config.filterConfig.filters.put(new Poster(poster.name, poster.country), FilterType.Visible);
                contentView.refreshContent();
            }
        });
        JMenuItem hiddenFilterMenu = new JMenuItem(new AbstractAction("\u900f\u660e\uff8c\uff68\uff99\uff80\uff98\uff9d\uff78\uff9e"){

            public void actionPerformed(ActionEvent e) {
                Poster poster = posterSelection.getCurrentPoster();
                if (poster == null) {
                    return;
                }
                ViewNaver.instance.config.filterConfig.filters.put(new Poster(poster.name, poster.country), FilterType.Hidden);
                contentView.refreshContent();
            }
        });
        idJitenMenu.setEnabled(false);
        popup.add(sendMessageMenu);
        popup.add(idJitenMenu);
        popup.add(favMenu);
        popup.add(filterMenu);
        popup.add(hiddenFilterMenu);
        posterSelection.addPosterSelectionListener(new PosterSelectionListener(){

            public void selected(Poster poster) {
                IDJitenList idJiten;
                if (poster == null) {
                    idJitenMenu.setEnabled(false);
                }
                if ((idJiten = ViewNaver.instance.idJiten) == null || idJiten.getExplain(poster) == null) {
                    idJitenMenu.setEnabled(false);
                } else {
                    idJitenMenu.setEnabled(true);
                }
            }
        });
    }
}

