/*
 * Decompiled with CFR 0.152.
 */
package com.aibonware.viewnaver.command;

import com.aibonware.viewnaver.ViewNaver;
import com.aibonware.viewnaver.command.ShowThreadCommand;
import com.aibonware.viewnaver.content.TabContainerView;
import com.aibonware.viewnaver.content.board.BoardContent;
import com.aibonware.viewnaver.content.board.BoardView;
import com.aibonware.viewnaver.model.Board;
import com.aibonware.viewnaver.task.GUITask;
import com.aibonware.viewnaver.task.TaskFlow;
import com.aibonware.viewnaver.task.WorkerTask;
import java.awt.Component;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JOptionPane;
import org.apache.commons.httpclient.HttpURL;
import org.apache.commons.httpclient.URIException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OpenURLCommand {
    private final String urlText;
    private final boolean onlyNaverUrl;
    private final Component parentComponent;
    private Vector<String> naverHosts = new Vector();

    public OpenURLCommand(Component parentComponent, String urlText, boolean onlyNaverUrl) {
        this.urlText = urlText;
        this.onlyNaverUrl = onlyNaverUrl;
        this.parentComponent = parentComponent;
        this.naverHosts.addElement("bbs.enjoykorea.jp");
        this.naverHosts.addElement("enjoykorea.jp");
        this.naverHosts.addElement("www.enjoykorea.jp");
        this.naverHosts.addElement("enjoyjapan.naver.com");
        this.naverHosts.addElement("bbs.enjoyjapan.naver.com");
    }

    private static Map<String, String> parseUrlParam(HttpURL url) throws URIException {
        String query = url.getQuery();
        HashMap<String, String> map = new HashMap<String, String>();
        StringTokenizer params = new StringTokenizer(query, "&");
        while (params.hasMoreTokens()) {
            String token = params.nextToken();
            int index = token.indexOf("=");
            String name = token.substring(0, index);
            String value = token.substring(index + 1);
            map.put(name, value);
        }
        return map;
    }

    public void run() {
        try {
            this.openNaverUrl(this.urlText);
            return;
        }
        catch (NotNaverUrlException e) {
            if (this.onlyNaverUrl) {
                ViewNaver.println(e.getMessage());
                return;
            }
            JOptionPane.showMessageDialog(this.parentComponent, String.valueOf(this.urlText) + "\n\n\u3053\u306eURL\u306fviewNVR\u3067\u306f\u958b\u3051\u307e\u305b\u3093\u3002\n\u53f3\u30af\u30ea\u30c3\u30af\u2192\u300c\u65b0\u3057\u3044\u30a6\u30a3\u30f3\u30c9\u30a6\u3067\u958b\u304f\u300d\u3092\u9078\u629e\u3057\u3001" + "IE\u3092\u4f7f\u7528\u3057\u3066\u958b\u3044\u3066\u304f\u3060\u3055\u3044\u3002");
            return;
        }
    }

    private void openNaverUrl(String urlText) throws NotNaverUrlException {
        block8: {
            try {
                HttpURL url = new HttpURL(urlText);
                if ("http:".equals(url.getScheme())) {
                    throw new NotNaverUrlException("'" + url.getScheme() + "' \u672a\u30b5\u30dd\u30fc\u30c8\u306e\u30d7\u30ed\u30c8\u30b3\u30eb\u3067\u3059\u3002");
                }
                if (!this.naverHosts.contains(url.getHost())) {
                    throw new NotNaverUrlException("'" + url.getHost() + "' \u672a\u30b5\u30dd\u30fc\u30c8\u306e\u30db\u30b9\u30c8\u540d\u3067\u3059\u3002");
                }
                if (url.getPort() != 80) {
                    throw new NotNaverUrlException("'" + url.getPort() + "' \u672a\u30b5\u30dd\u30fc\u30c8\u306e\u30dd\u30fc\u30c8\u756a\u53f7\u3067\u3059\u3002");
                }
                if ("read.php".equals(url.getName())) {
                    Map<String, String> params = OpenURLCommand.parseUrlParam(url);
                    String boardName = params.get("board_id");
                    int nid = Integer.parseInt(params.get("nid"));
                    String showPollText = params.get("chk_poll");
                    boolean showPoll = "YES".equalsIgnoreCase(showPollText);
                    TaskFlow taskFlow = ViewNaver.instance.taskFlowList.getThreadFlow(boardName, nid);
                    taskFlow.execute(new ShowThreadCommand(boardName, nid));
                    break block8;
                }
                if ("list.php".equals(url.getName())) {
                    Map<String, String> params = OpenURLCommand.parseUrlParam(url);
                    final String boardName = params.get("board_id");
                    String pageText = params.get("page");
                    if (pageText == null) {
                        pageText = "1";
                    }
                    final int pageNo = Integer.parseInt(pageText);
                    final TabContainerView containerView = ViewNaver.instance.mainWindow.containerView;
                    BoardView view = (BoardView)containerView.registerEmptyView(BoardContent.getCategory(boardName));
                    TaskFlow taskFlow = ViewNaver.instance.taskFlowList.getBoardFlow(boardName, pageNo);
                    taskFlow.addStatusReceiver(view.createTaskStatusReceiver(taskFlow));
                    taskFlow.execute(new WorkerTask(){

                        public void exec() {
                            Board newBoard = ViewNaver.instance.cache.getBoard(boardName, pageNo, false);
                            this.taskFlow.execute(new GUITask(this, newBoard, containerView, boardName){
                                final /* synthetic */ 1 this$1;
                                private final /* synthetic */ Board val$newBoard;
                                private final /* synthetic */ TabContainerView val$containerView;
                                private final /* synthetic */ String val$boardName;
                                {
                                    this.this$1 = var1_1;
                                    this.val$newBoard = board;
                                    this.val$containerView = tabContainerView;
                                    this.val$boardName = string;
                                }

                                public void exec() {
                                    if (this.val$newBoard == null) {
                                        this.val$containerView.revertEmptyView(BoardContent.getCategory(this.val$boardName));
                                        return;
                                    }
                                    this.val$containerView.update(new BoardContent(this.val$newBoard));
                                }
                            });
                        }
                    });
                    break block8;
                }
                throw new NotNaverUrlException("'" + url.getName() + "' \u672a\u30b5\u30dd\u30fc\u30c8\u306eCGI\u540d\u3067\u3059\u3002");
            }
            catch (URIException e) {
                throw new NotNaverUrlException("\u672a\u30b5\u30dd\u30fc\u30c8\u306eURL\u3067\u3059\u3002");
            }
        }
    }

    private class NotNaverUrlException
    extends Exception {
        public NotNaverUrlException(String message) {
            super(message);
        }
    }
}

