/*
 * Decompiled with CFR 0.152.
 */
package com.aibonware.viewnaver;

import com.aibonware.viewnaver.Cache;
import com.aibonware.viewnaver.Plugin;
import com.aibonware.viewnaver.Version;
import com.aibonware.viewnaver.browser.BrowserFactory;
import com.aibonware.viewnaver.browser.basic.BasicBrowserFactory;
import com.aibonware.viewnaver.browser.win32.Win32BrowserFactory;
import com.aibonware.viewnaver.command.PosterMenuItemCreator;
import com.aibonware.viewnaver.component.DefaultTextOperation;
import com.aibonware.viewnaver.config.Config;
import com.aibonware.viewnaver.content.DefaultTabContentOrder;
import com.aibonware.viewnaver.decorator.DecoratorChain;
import com.aibonware.viewnaver.decorator.EmbeddedMovieDecorator;
import com.aibonware.viewnaver.decorator.GoyakuDecorator;
import com.aibonware.viewnaver.decorator.LinkGenerator;
import com.aibonware.viewnaver.model.BoardTitle;
import com.aibonware.viewnaver.model.BoardTitles;
import com.aibonware.viewnaver.model.BoardType;
import com.aibonware.viewnaver.model.FavoriteThreads;
import com.aibonware.viewnaver.model.GoyakuJiten;
import com.aibonware.viewnaver.model.IDJitenList;
import com.aibonware.viewnaver.net.NaverSession;
import com.aibonware.viewnaver.net.RemoteSite;
import com.aibonware.viewnaver.server.MiniServer;
import com.aibonware.viewnaver.storage.MessageStorage;
import com.aibonware.viewnaver.storage.ThreadStorage;
import com.aibonware.viewnaver.task.TaskFlow;
import com.aibonware.viewnaver.task.TaskFlowList;
import com.aibonware.viewnaver.task.ThreadPool;
import com.aibonware.viewnaver.task.WorkerTask;
import com.aibonware.viewnaver.view.LogView;
import com.aibonware.viewnaver.window.ChildWindowActivator;
import com.aibonware.viewnaver.window.LoginDialog;
import com.aibonware.viewnaver.window.MainWindow;
import com.aibonware.viewnaver.window.ThreadWindow;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class ViewNaver
implements Runnable {
    public Config config;
    public MainWindow mainWindow;
    public ThreadWindow threadWindow;
    public static ViewNaver instance;
    public RemoteSite web;
    public ThreadPool threadPool;
    public BrowserFactory browserFactory = null;
    public NaverSession naverSession = null;
    public Cache cache;
    public GoyakuJiten goyakuList = null;
    public IDJitenList idJiten = null;
    public BoardTitles boardTitles = null;
    public ChildWindowActivator childWindowActivator = null;
    public ThreadStorage threadStorage = null;
    public MessageStorage messageStorage = null;
    public DefaultTabContentOrder defaultCategoryComparator = null;
    public FavoriteThreads favoriteThreads = null;
    public DefaultTextOperation deftex = null;
    public MiniServer server = null;
    public DecoratorChain threadDecorator = null;
    public DecoratorChain articleDecorator = null;
    public TaskFlowList taskFlowList = null;
    public PosterMenuItemCreator posterMenuItemCreator = null;
    private static LogView logView;
    private HashMap<Class, Character> allocatedPUAList = new HashMap();

    static {
        logView = new LogView(5, 80);
    }

    public synchronized BrowserFactory getBrowserFactory() {
        return this.browserFactory;
    }

    public ViewNaver() {
        instance = this;
        this.config = new Config();
        this.taskFlowList = new TaskFlowList();
        this.threadPool = new ThreadPool();
        this.web = new RemoteSite();
        this.cache = new Cache();
        this.boardTitles = this.createBoardTitles();
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        JPopupMenu.setDefaultLightWeightPopupEnabled(false);
    }

    private BoardTitles createBoardTitles() {
        BoardTitles group = new BoardTitles();
        group.addBoardTitle(new BoardTitle("ttravel", "\u65c5\u884c", BoardType.Text));
        group.addBoardTitle(new BoardTitle("tlife", "\u751f\u6d3b/\u6587\u5316", BoardType.Text));
        group.addBoardTitle(new BoardTitle("thistory", "\u4f1d\u7d71", BoardType.Text));
        group.addBoardTitle(new BoardTitle("tbook", "BOOK", BoardType.Text));
        group.addBoardTitle(new BoardTitle("tselftalk", "\u3072\u3068\u308a\u8a00", BoardType.Text));
        group.addBoardTitle(new BoardTitle("ttrouble", "\u60a9\u307f", BoardType.Text));
        group.addBoardTitle(new BoardTitle("tjob", "\u5c31\u8077", BoardType.Text));
        group.addBoardTitle(new BoardTitle("thumor", "\u30e6\u30fc\u30e2\u30a2", BoardType.Text));
        group.addBoardTitle(new BoardTitle("tpop", "\u97f3\u697d", BoardType.Text));
        group.addBoardTitle(new BoardTitle("tdrama", "\u30c9\u30e9\u30de", BoardType.Text));
        group.addBoardTitle(new BoardTitle("tmovie", "\u6620\u753b", BoardType.Text));
        group.addBoardTitle(new BoardTitle("tactor", "\u82b8\u80fd\u4eba", BoardType.Text));
        group.addBoardTitle(new BoardTitle("tcosmetic", "\u30d5\u30a1\u30c3\u30b7\u30e7\u30f3", BoardType.Text));
        group.addBoardTitle(new BoardTitle("tgame", "\u30b2\u30fc\u30e0", BoardType.Text));
        group.addBoardTitle(new BoardTitle("tanimation", "\u30de\u30f3\u30ac/\u30a2\u30cb\u30e1", BoardType.Text));
        group.addBoardTitle(new BoardTitle("tinternet", "IT/\u30c7\u30b8\u30bf\u30eb", BoardType.Text));
        group.addBoardTitle(new BoardTitle("tdigital", "\u30ab\u30e1\u30e9/\u96fb\u5316\u88fd\u54c1", BoardType.Text));
        group.addBoardTitle(new BoardTitle("teconomy", "\u6642\u4e8b\u30cb\u30e5\u30fc\u30b9", BoardType.Text));
        group.addBoardTitle(new BoardTitle("tsports", "\u30b9\u30dd\u30fc\u30c4", BoardType.Text));
        group.addBoardTitle(new BoardTitle("ttalk", "Hot! \u8a0e\u8ad6", BoardType.Text));
        group.addBoardTitle(new BoardTitle("tfree", "\u81ea\u7531\u63b2\u793a\u677f", BoardType.Text));
        group.addBoardTitle(new BoardTitle("ptravel", "\u89b3\u5149/\u98a8\u666f", BoardType.Image));
        group.addBoardTitle(new BoardTitle("pfood", "\u30b0\u30eb\u30e1", BoardType.Image));
        group.addBoardTitle(new BoardTitle("pfriend", "\u604b\u4eba/\u53cb\u9054/\u5bb6\u65cf", BoardType.Image));
        group.addBoardTitle(new BoardTitle("ppet", "\u30da\u30c3\u30c8", BoardType.Image));
        group.addBoardTitle(new BoardTitle("pvillage", "\u308f\u305f\u3057\u306e\u8857", BoardType.Image));
        group.addBoardTitle(new BoardTitle("pmything", "\u81ea\u6162\u306e\u4e00\u54c1", BoardType.Image));
        group.addBoardTitle(new BoardTitle("pstar", "\u82b8\u80fd\u4eba", BoardType.Image));
        group.addBoardTitle(new BoardTitle("psports", "\u30b9\u30dd\u30fc\u30c4", BoardType.Image));
        group.addBoardTitle(new BoardTitle("phumor", "\u30e6\u30fc\u30e2\u30a2", BoardType.Image));
        group.addBoardTitle(new BoardTitle("phistory", "\u4f1d\u7d71", BoardType.Image));
        group.addBoardTitle(new BoardTitle("pcar", "\u30af\u30eb\u30de", BoardType.Image));
        group.addBoardTitle(new BoardTitle("pbike", "\u30d0\u30a4\u30af", BoardType.Image));
        group.addBoardTitle(new BoardTitle("pmodel", "\u30d7\u30e9\u30e2\u30c7\u30eb/\u30d5\u30a3\u30ae\u30e5\u30a2", BoardType.Image));
        group.addBoardTitle(new BoardTitle("pgame", "\u30b2\u30fc\u30e0", BoardType.Image));
        group.addBoardTitle(new BoardTitle("panimation", "\u30de\u30f3\u30ac/\u30a2\u30cb\u30e1", BoardType.Image));
        group.addBoardTitle(new BoardTitle("pfree", "\u81ea\u7531\u30d5\u30a9\u30c8\u63b2\u793a\u677f", BoardType.Image));
        return group;
    }

    public void run() {
        this.defaultCategoryComparator = new DefaultTabContentOrder();
        this.mainWindow = new MainWindow();
        this.childWindowActivator = new ChildWindowActivator(this.mainWindow);
        this.threadWindow = new ThreadWindow(this.mainWindow);
        this.threadStorage = new ThreadStorage();
        this.messageStorage = new MessageStorage();
        this.favoriteThreads = new FavoriteThreads();
        this.deftex = new DefaultTextOperation();
        this.threadDecorator = new DecoratorChain();
        this.articleDecorator = new DecoratorChain();
        this.threadDecorator.addDecorator(new EmbeddedMovieDecorator());
        this.articleDecorator.addDecorator(new LinkGenerator());
        this.threadDecorator.addDecorator(new GoyakuDecorator());
        this.articleDecorator.addDecorator(new GoyakuDecorator());
        this.posterMenuItemCreator = new PosterMenuItemCreator();
        this.config.loadFile("config.xml");
        this.favoriteThreads.load("favorite.xml");
        ViewNaver.makeSureDir("plugins");
        String[] fileNames = new File("plugins").list();
        Vector<Plugin> plugins = new Vector<Plugin>();
        if (fileNames != null) {
            String[] stringArray = fileNames;
            int n = 0;
            int n2 = stringArray.length;
            while (n < n2) {
                String fileName = stringArray[n];
                if (new File(fileName).isFile() && fileName.endsWith(".jar")) {
                    try {
                        String pluginName = fileName.substring(0, fileName.length() - 4);
                        if (pluginName.contains(".")) {
                            pluginName = "com.aibonware.viewnaver.plugins." + pluginName;
                        }
                        Plugin plugin = (Plugin)Class.forName(pluginName).newInstance();
                        plugins.addElement(plugin);
                    }
                    catch (Exception e) {
                        ViewNaver.println("\u30d7\u30e9\u30b0\u30a4\u30f3" + fileName + "\u306e\u30ed\u30fc\u30c9\u306b\u5931\u6557\u3057\u307e\u3057\u305f(" + e.getMessage() + ")\u3002");
                    }
                }
                ++n;
            }
        }
        Collections.sort(plugins, new Comparator<Plugin>(){

            @Override
            public int compare(Plugin src, Plugin dest) {
                return src.getPriorityPoint() - dest.getPriorityPoint();
            }
        });
        for (Plugin plugin : plugins) {
            try {
                plugin.initialize();
            }
            catch (Exception e) {
                ViewNaver.println("\u30d7\u30e9\u30b0\u30a4\u30f3" + plugin.getName() + "\u306e\u521d\u671f\u5316\u306b\u5931\u6557\u3057\u307e\u3057\u305f(" + e.getMessage() + ")\u3002");
            }
        }
        try {
            if (this.browserFactory == null) {
                this.browserFactory = new Win32BrowserFactory();
            }
            this.browserFactory.initialize();
        }
        catch (Throwable e) {
            ViewNaver.println("HTML\u30ec\u30f3\u30c0\u30ea\u30f3\u30b0\u30a8\u30f3\u30b8\u30f3\u306e\u521d\u671f\u5316\u306b\u5931\u6557\u3057\u307e\u3057\u305f(" + e.getMessage() + ")\u3002\u4ee3\u66ff\u51e6\u7406\u3092\u884c\u3044\u307e\u3059\u3002");
            this.browserFactory = new BasicBrowserFactory();
            this.browserFactory.initialize();
        }
        ViewNaver.println("viewNVR " + Version.STATUS + " " + 0 + "." + 2 + " rev." + Version.REVISION);
        ViewNaver.println("Rendering Engine: " + this.browserFactory.getEngineName());
        ViewNaver.println("");
        final LoginDialog loginDialog = new LoginDialog(null, logView, this.config);
        loginDialog.addWindowListener(new WindowAdapter(){

            public void windowClosed(WindowEvent e) {
                if (!loginDialog.confirmed) {
                    ViewNaver.this.browserFactory.terminate();
                    System.exit(-1);
                    return;
                }
                ViewNaver.this.mainWindow.logView.print(logView.getText());
                ViewNaver.logView = ViewNaver.this.mainWindow.logView;
                ViewNaver.this.mainWindow.setVisible(true);
            }
        });
        loginDialog.setVisible(true);
    }

    private static boolean runGUI(final Runnable runnable) {
        if (SwingUtilities.isEventDispatchThread()) {
            try {
                runnable.run();
            }
            catch (RuntimeException e) {
                ViewNaver.err(e);
            }
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    try {
                        runnable.run();
                    }
                    catch (RuntimeException e) {
                        ViewNaver.err(e);
                    }
                }
            });
        }
        return true;
    }

    public static void err(final Exception e) {
        e.printStackTrace();
        ViewNaver.runGUI(new Runnable(){

            public void run() {
                StringWriter buf = new StringWriter();
                PrintWriter writer = new PrintWriter(buf);
                e.printStackTrace(writer);
                logView.append(buf.toString());
                writer.close();
            }
        });
    }

    public static void println(final String s) {
        ViewNaver.runGUI(new Runnable(){

            public void run() {
                logView.print(String.valueOf(s) + "\n");
            }
        });
    }

    public void exit() {
        this.config.saveFile("config.xml");
        TaskFlow taskFlow = this.taskFlowList.createNewFlow();
        taskFlow.execute(new WorkerTask(){

            public void exec() {
                try {
                    ViewNaver.println("\u30b9\u30ec\u30c3\u30c9\u30ed\u30b0\u51fa\u529b\u958b\u59cb...");
                    int num = ViewNaver.instance.threadStorage.flash();
                    ViewNaver.println("\u30b9\u30ec\u30c3\u30c9\u30ed\u30b0\u51fa\u529b\u7d42\u4e86(" + num + "\u30b9\u30ec\u30c3\u30c9\u4fdd\u5b58)");
                }
                catch (Exception e) {
                    ViewNaver.err(e);
                }
                try {
                    ViewNaver.println("\u30ed\u30b0\u30a2\u30a6\u30c8\u958b\u59cb..");
                    if (ViewNaver.this.naverSession != null && ViewNaver.this.naverSession.nowLogin()) {
                        ViewNaver.this.naverSession.logout();
                    }
                    ViewNaver.println("\u30ed\u30b0\u30a2\u30a6\u30c8\u7d42\u4e86\u3002");
                }
                catch (Exception e) {
                    ViewNaver.err(e);
                }
                ViewNaver.runGUI(new Runnable(this){
                    final /* synthetic */ 6 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void run() {
                        ViewNaver.println("\u30d0\u30c3\u30af\u30b0\u30e9\u30a6\u30f3\u30c9\u30bf\u30b9\u30af\u306e\u7d42\u4e86...");
                        6.access$0(this.this$1).threadPool.shutdownNow();
                        6.access$0(this.this$1).mainWindow.dispose();
                        if (6.access$0(this.this$1).browserFactory != null) {
                            6.access$0(this.this$1).browserFactory.terminate();
                        }
                        System.exit(0);
                    }
                });
            }

            static /* synthetic */ ViewNaver access$0(6 var0) {
                return var0.ViewNaver.this;
            }
        });
    }

    public static String strToHtml(String s) {
        return ViewNaver.getArticleHtml(s, false, '\u0000', '\u0000');
    }

    public static String htmlToStr(String s) {
        s = s.replaceAll("&quot;", "\"");
        s = s.replaceAll("&amp;", "&");
        s = s.replaceAll("&lt;", "<");
        s = s.replaceAll("&gt;", ">");
        s = s.replaceAll("&nbsp;", " ");
        s = s.replaceAll("<br>", "\n");
        return s;
    }

    public static String getArticleHtml(String s, boolean unicode, char unicodeStartChar, char unicodeEndChar) {
        if (s == null) {
            return "";
        }
        StringBuffer buf = new StringBuffer();
        int len = s.length();
        int i = 0;
        while (i < len) {
            char c = s.charAt(i);
            switch (c) {
                case '\"': {
                    buf.append("&quot;");
                    break;
                }
                case '&': {
                    buf.append("&amp;");
                    break;
                }
                case '<': {
                    buf.append("&lt;");
                    break;
                }
                case '>': {
                    buf.append("&gt;");
                    break;
                }
                case ' ': {
                    buf.append("&nbsp;");
                    break;
                }
                default: {
                    buf.append(c);
                }
            }
            ++i;
        }
        s = buf.toString();
        if (unicode) {
            int start;
            while ((start = s.indexOf(unicodeStartChar)) != -1) {
                int end = s.indexOf(unicodeEndChar, start);
                if (end == -1) break;
                s = String.valueOf(s.substring(0, start)) + ViewNaver.toUnicode(s.substring(start + 1, end)) + s.substring(end + 1);
            }
        }
        return s;
    }

    private static String toUnicode(String s) {
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < s.length()) {
            buf.append("&#" + s.charAt(i) + ";");
            ++i;
        }
        return buf.toString();
    }

    public static boolean makeSureDir(String dirName) {
        File dir = new File(dirName);
        if (dir.exists()) {
            return true;
        }
        return dir.mkdirs();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public char getPUA(Class clazz) {
        HashMap<Class, Character> hashMap = this.allocatedPUAList;
        synchronized (hashMap) {
            if (this.allocatedPUAList.containsKey(clazz)) {
                return this.allocatedPUAList.get(clazz).charValue();
            }
            char c = (char)(57344 + this.allocatedPUAList.size());
            if (c >= '\ue400') {
                throw new IndexOutOfBoundsException("PUA is full");
            }
            this.allocatedPUAList.put(clazz, Character.valueOf(c));
            return c;
        }
    }
}

