/*
 * Decompiled with CFR 0.152.
 */
package com.aibonware.viewnaver;

import java.io.File;
import java.util.StringTokenizer;
import javax.swing.JOptionPane;

public class Launcher {
    public static void main(String[] args) throws Exception {
        if (args.length < 1 || !args[0].equals("main")) {
            new Launcher().start();
        } else {
            Class<?> viewNaverClass = Class.forName("com.aibonware.viewnaver.ViewNaver");
            Runnable app = (Runnable)viewNaverClass.newInstance();
            app.run();
        }
    }

    public void start() {
        String fileName;
        int i;
        String pluginsDir;
        String libDir;
        boolean isWindows = System.getProperty("os.name").toLowerCase().contains("windows");
        String version = System.getProperty("java.version");
        StringTokenizer verTokens = new StringTokenizer(version, ".");
        verTokens.nextToken();
        String minor = verTokens.nextToken();
        if (Integer.parseInt(minor) < 5) {
            JOptionPane.showMessageDialog(null, "\u53e4\u3044Java\u30e9\u30f3\u30bf\u30a4\u30e0\u74b0\u5883\u3067\u3059\u3002");
            return;
        }
        String home = System.getProperty("java.home");
        String binDir = home.endsWith(File.separator) ? String.valueOf(home) + "bin" : String.valueOf(home) + File.separator + "bin";
        String userDir = System.getProperty("user.dir");
        if (userDir.endsWith("File.separator")) {
            libDir = String.valueOf(userDir) + "lib";
            pluginsDir = String.valueOf(userDir) + "plugins";
        } else {
            libDir = String.valueOf(userDir) + File.separator + "lib";
            pluginsDir = String.valueOf(userDir) + File.separator + "plugins";
        }
        String classes = "viewnvr.jar";
        File[] files = new File(libDir).listFiles();
        if (files != null) {
            i = 0;
            while (i < files.length) {
                if (files[i].isFile() && ((fileName = files[i].getName()).endsWith(".jar") || fileName.endsWith(".zip"))) {
                    classes = String.valueOf(classes) + File.pathSeparatorChar + "lib" + File.separator + fileName;
                }
                ++i;
            }
        }
        if ((files = new File(pluginsDir).listFiles()) != null) {
            i = 0;
            while (i < files.length) {
                if (files[i].isFile() && ((fileName = files[i].getName()).endsWith(".jar") || fileName.endsWith(".zip"))) {
                    classes = String.valueOf(classes) + File.pathSeparatorChar + "plugins" + File.separator + fileName;
                }
                ++i;
            }
        }
        String javaExe = isWindows ? "javaw.exe" : "java";
        String cmd = String.valueOf(binDir) + File.separator + javaExe;
        if (cmd.contains(" ")) {
            cmd = "\"" + cmd + "\"";
        }
        String[] cmdline = new String[]{cmd, "-cp", classes, "com.aibonware.viewnaver.Launcher", "main"};
        ProcessBuilder builder = new ProcessBuilder(cmdline);
        String pathKey = "Path";
        String path = builder.environment().get(pathKey);
        if (path == null) {
            pathKey = "PATH";
            path = builder.environment().get(pathKey);
        }
        if (path == null) {
            path = "";
        }
        path = path.endsWith(File.pathSeparator) ? String.valueOf(path) + binDir : String.valueOf(path) + File.pathSeparator + binDir;
        if (isWindows) {
            path = String.valueOf(path) + File.pathSeparator + libDir;
        } else {
            String ldPath = builder.environment().get("LD_LIBRARY_PATH");
            if (ldPath == null) {
                ldPath = "";
            }
            ldPath = ldPath.endsWith(File.pathSeparator) ? String.valueOf(ldPath) + libDir : String.valueOf(ldPath) + File.pathSeparator + libDir;
            builder.environment().put("LD_LIBRARY_PATH", ldPath);
            System.out.println("ldpath:" + ldPath);
        }
        builder.environment().put(pathKey, path);
        builder.directory(new File(userDir));
        System.out.println("command lines: ");
        String[] stringArray = cmdline;
        int n = 0;
        int n2 = stringArray.length;
        while (n < n2) {
            String cmditem = stringArray[n];
            System.out.println(cmditem);
            ++n;
        }
        System.out.println("userDir: " + userDir);
        System.out.println("path:" + path);
        try {
            System.out.println("now exit this process and launch again, wait a minute... ");
            builder.start();
            System.exit(-1);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, "\u8d77\u52d5\u5931\u6557");
            return;
        }
    }
}

