/*
 * Created on 2005/01/15
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package com.aibonware.nvrlib.xml;

import org.w3c.dom.*;
import com.aibonware.nvrlib.model.*;

public class ThreadSerializer extends BaseSerializer {
	public ThreadSerializer(Document doc) {
		super(doc);
	}

	public Element serialize(int boardId, NThread thread, String content, int numberOfRegisteredComments, int maxCommentId) {
		Element threadElem = doc.createElement("Thread");
		threadElem.setAttribute("BoardID", String.valueOf(boardId));
        threadElem.setAttribute("NID", String.valueOf(thread.nid));
        threadElem.appendChild(createAttrElem("Country", countryToText(thread.country)));
        if(thread.dispId != null) threadElem.appendChild(createAttrElem("DispID", thread.dispId));
        if(thread.depth > 0) threadElem.appendChild(createAttrElem("Depth", thread.depth));
        threadElem.appendChild(createAttrElem("Writer", thread.poster));
        if(thread.mail != null) threadElem.appendChild(createAttrElem("Mail", thread.mail));
        threadElem.appendChild(createAttrElem("Subject", thread.title));
        threadElem.appendChild(createAttrElem("Content", content));
        threadElem.appendChild(createAttrElem("CreateDate", tf.format(thread.createDate)));
        threadElem.appendChild(createAttrElem("ModifiyDate", tf.format(thread.modifiedDate)));
        threadElem.appendChild(createAttrElem("RegisterDate", tf.format(thread.lastCrawlTime)));
        threadElem.appendChild(createAttrElem("MaxCommentID", maxCommentId));
        threadElem.appendChild(createAttrElem("NumberOfComments", thread.articleNum));
        threadElem.appendChild(createAttrElem("NumberOfRegisteredComments", numberOfRegisteredComments));
		
		return threadElem;
	}

}
