/*
 * Copyright (c) 2006, team-naver.com
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package com.aibonware.nvrlib.web;

import java.io.*;
import org.apache.commons.httpclient.*;
import org.apache.commons.httpclient.methods.*;
import com.aibonware.nvrlib.*;

/**
 * ̐ꂽRg̑}ev[gύX邽
 * EBhE > ݒ > Java > R[h > R[hƃRg
 */
public class HttpClientWebSession implements WebSession {
	public BufferedReader reader = null;
	public GetMethod method = null;
	public final String urlString;
	private AppTools appTools;
	
	public HttpClientWebSession(AppTools appTools, String urlString) {
		this.urlString = urlString;
		this.appTools = appTools;
 	}

	public void open() throws IOException, NetException {
		HttpClient client = new HttpClient();
		client.setConnectionTimeout(100*1000);
		client.setTimeout(90*1000);

		if(appTools.getProxyHost() != null) {
			client.getHostConfiguration().setProxy(appTools.getProxyHost(), appTools.getProxyPort());
		}
	
		method = new GetMethod(urlString);
		method.addRequestHeader("user-agent", "Mozilla/5.0 (Windows; U; Windows NT 5.1; ja-JP; rv:1.7.12) Gecko/20050915");
		
		int httpStatus = client.executeMethod(method);
		if(httpStatus >= 300) throw new NetException("Invalid Status Code=" + httpStatus);

		reader = new BufferedReader(new InputStreamReader(method.getResponseBodyAsStream(), "UTF-8"));
	}

	public void close() throws IOException {
		if(reader != null) reader.close();
		if(method != null) method.releaseConnection();
	}

	public BufferedReader getReader() {
		return reader;
	}
}
