/*
 * Copyright (c) 2006, team-naver.com
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package com.aibonware.nvrlib.model;

import java.util.*;

/**
 * f[^x[XɊi[ĂXbh̏i[NXB
 */
public class ThreadFullPath {
	public final int boardId;
	public final int depth;
	public final String dispId;
	public final boolean isAdminThread;
	public final int nid;
	public final int country;
	public final String title;
	public final int articleNum;
	public final String poster;
	public final Date createDate;
	public final Date modifiedDate;
	public final int viewNum;
	public final String mail;
	public final Date lastCrawlTime;
	public final boolean isHot;

	public ThreadFullPath(
			int boardId,
			int depth,
			String dispId,
			boolean isAdminThread,
			int nid,
			int country,
			String title,
			int articleNum,
			String poster,
			Date createDate,
			Date modifiedDate,
			int viewNum,
			String mail,
			Date lastCrawlTime,
			boolean isHot) {
		this.boardId = boardId;
		this.depth = depth;
		this.dispId = dispId;
		this.isAdminThread = isAdminThread;
		this.nid = nid;
		this.country = country;
		this.title = title;
		this.articleNum = articleNum;
		this.poster = poster;
		this.createDate = createDate;
		this.modifiedDate = modifiedDate;
		this.viewNum = viewNum;
		this.mail = mail;
		this.lastCrawlTime = lastCrawlTime;
		this.isHot = isHot;
	}
}
