/*
 * Copyright (c) 2006, team-naver.com
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package com.aibonware.nvrlib.model;

import java.util.*;

/**
 * \NXB
 */
public class Board {
	// ʃR[h
	public static final int COUNTRY_UNKNOWN = 0; // s
	public static final int COUNTRY_JAPAN = 1; // {
	public static final int COUNTRY_KOREA = 2; // ؍

	public static final int BOARD_TYPE_TEXT = 0;
	public static final int BOARD_TYPE_IMAGE = 1;

	public final int boardId; // ̎ʎq
	public final String boardName; // ̓
	public final String dispName; // ̕\
	public final int maxPageNum; // bB񂷂ׂy[W
	public final Date lastCrawlTime;
	public final boolean visible;
    public final int interval;
    public final boolean mustCrawl;
    public final int boardType;
    public final int lockNid; // NIDÕXbh̍XV֎~

	/**
	 * RXgN^B̓eޔB
	 * @param boardId ̓ʎq
	 * @param boardName ̓
	 * @param dispName ̕\
	 * @param boardUrl URL
	 */
	public Board(int boardId, String boardName, String dispName, int maxPageNum, Date lastCrawlTime, boolean visible, int interval, boolean mustCrawl, int boardType, int lockNid) {
		this.boardId = boardId;
		this.boardName = boardName;
		this.dispName = dispName;
		this.maxPageNum = maxPageNum;
		this.lastCrawlTime = lastCrawlTime;
		this.visible = visible;
        this.interval = interval;
        this.mustCrawl = mustCrawl;
        this.boardType = boardType;
        this.lockNid = lockNid;
	}
}
